package com.ejianc.business.bid.controller;

import cn.hutool.core.date.DateUtil;
import com.ejianc.business.bid.consts.NoticeEnum;
import com.ejianc.business.bid.service.EnrollMessageService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;


@RestController
@RequestMapping(value = "/enrollWarn")
public class EnrollWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private EnrollMessageService messageService;
    @Autowired
    private IEnrollService enrollservice;
    //提前7/5/3天进行三次预警
    private static  int[] arr= {3,5,7};


    @RequestMapping(value = "/expireWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> overdue(HttpServletRequest request) {
        logger.info("接收到投标报名Task参数：{}", request);
        List<EnrollVO> enrollVOS = enrollservice.queryBidOpeningSoon();
        if (CollectionUtils.isNotEmpty(enrollVOS)){
         enrollVOS.forEach(item->{
             //开标日期
             String biddingDate = DateUtil.format(item.getBiddingDate(), "yyyy-MM-dd");
             String today= DateUtil.today();
             //提前7/5/3天进行三次预警
             long l = (DateUtil.parse(today).getTime() +arr[0]*(24 * 3600 * 1000));
             long l1 = (DateUtil.parse(today).getTime() +arr[1]*(24 * 3600 * 1000));
             long l2 = (DateUtil.parse(today).getTime() +arr[2]*(24 * 3600 * 1000));
             if (l==DateUtil.parse(biddingDate).getTime() || l1==DateUtil.parse(biddingDate).getTime() || l2==DateUtil.parse(biddingDate).getTime()) {
                 messageService.sendMsg(item,new String[]{String.valueOf(item.getFollowPerson())},NoticeEnum.BID_ENROLL);
             }
         });
        }
        return CommonResponse.success("发送消息成功！");
    }
}
