package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.ChoosePersonEntity;
import com.ejianc.business.bid.bean.ChoosePersonZiEntity;
import com.ejianc.business.bid.service.IChoosePersonService;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Service("choosePerson") 
public class ChoosePersonBpmServiceImpl implements ICommonBusinessService {

	 @Autowired
     private IZjllApi zjllApi;
	 @Autowired
	 private IChoosePersonService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ChoosePersonEntity entity = service.selectById(billId);
		if(null!=entity){
			List<ChoosePersonZiEntity> list = entity.getChoosePersonZiList();
			List<ZjllVO> zill =new ArrayList<>();
			for(ChoosePersonZiEntity ziEntity:list){
				ZjllVO zjllVO = new ZjllVO();
				zjllVO.setYxzt(0);
				zjllVO.setZt(1);
				zjllVO.setProjectId(entity.getXmId());
				zjllVO.setProjectName(entity.getXm());
				zjllVO.setXmId(ziEntity.getRyId());
				zjllVO.setXmName(ziEntity.getRyName());
				zjllVO.setGw(ziEntity.getGw());
				zjllVO.setOrgId(entity.getOrgId());
				zjllVO.setOrgName(entity.getOrgName());
				zjllVO.setKssj(new Date());
				zill.add(zjllVO);
			}
			zjllApi.saveorupdateBatch(zill);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
