package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidBillTypeEnum;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("stopApply")
public class StopApplyBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IStopApplyService stopApplyService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IEnrollService enrollService;

    @Autowired
    private HttpServletRequest request;

    @Autowired
    private IBpmApi iBpmApi;
    //投标信息跟踪
    @Autowired
    private IInfoTrackService infoTrackService;
    //资格预审
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    //招标文件评审
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    //投标文件评审
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    //投标总结
    @Autowired
    private ISummaryService summaryService;

    @Autowired
    private IZjllApi zjllApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ////向记录表里插入投标信息跟踪数据
        if (billId != null) {
            StopApplyEntity stopApply = stopApplyService.selectById(billId);
            if (stopApply != null) {
                String authority = request.getHeader("authority");
                int taskSize = 5;
                //创建一个固定数量的线程池
                ExecutorService threadPool = Executors.newFixedThreadPool(taskSize);
                try {
                    Callable<JSONObject> myTodoAndSubmitCallable = new MyTodoAndSubmitTask(RequestContextHolder.getRequestAttributes(), stopApply.getEnrollId(), authority);
                    threadPool.submit(myTodoAndSubmitCallable);
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    threadPool.shutdown();
                }

                /**根据投标中止的工程信息查询投标报名**/
                EnrollEntity enrollEntity = enrollService.selectById(stopApply.getEnrollId());
                if(enrollEntity != null){
                    //判断当前投标报名是参照信息跟踪
                    if(BidCommonConsts.NO.equals(enrollEntity.getSourceType())){
                        LambdaUpdateWrapper<InfoTrackEntity> infoTrackWrapper = new LambdaUpdateWrapper<>();
                        //投标信息跟踪改为已终止 0
                        infoTrackWrapper.eq(InfoTrackEntity::getId,enrollEntity.getSourceId());
                        infoTrackWrapper.set(InfoTrackEntity::getFollowState,BidStateEnum.YI_JIE_SHU.getCode());
                        infoTrackService.update(infoTrackWrapper);
                    }
                }

                LambdaUpdateWrapper<EnrollEntity> wrapper = new LambdaUpdateWrapper<>();
                //投标停止
                wrapper.eq(EnrollEntity::getId, stopApply.getEnrollId());
                wrapper.set(EnrollEntity::getIsStop, BidCommonConsts.YES);
                wrapper.set(EnrollEntity::getBidStage, BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode());
                wrapper.set(EnrollEntity::getBidState, BidStateEnum.YI_JIE_SHU.getCode());
                enrollService.update(wrapper);
                //插入记录表数据
                recordService.saveRecord(BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING, billId, stopApply.getEngineeringCode());

               /*
               * 投标终止释放占用人员
               * */
                LambdaQueryWrapper<BidFileReviewEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(BidFileReviewEntity::getEngineeringCode,stopApply.getEngineeringCode());
                BidFileReviewEntity bidFileReviewEntity = bidFileReviewService.getOne(queryWrapper);
                HashMap condition =new HashMap();
                condition.put("zsbh",bidFileReviewEntity.getZcbh());
                condition.put("enrollId",bidFileReviewEntity.getEnrollId());
                condition.put("builtConstructorId",bidFileReviewEntity.getBuiltConstructorId());
                zjllApi.updateZjll(condition);
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.error("投标停止申请单据无法弃审！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    class MyTodoAndSubmitTask implements Callable<JSONObject> {

        private RequestAttributes context;
        private Long enrollId;
        private String authority;

        public MyTodoAndSubmitTask(RequestAttributes context, Long enrollId, String authority) {
            this.context = context;
            this.enrollId = enrollId;
            this.authority = authority;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject resp = new JSONObject();
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);

            QueryParam param = new QueryParam();
            param.getParams().put("engineeringId", new Parameter(QueryParam.EQ, enrollId));
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                    BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                    BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()
            )));
            //查询该投标报名信息的审批中的资格预审，中止流程
            List<PrequaliFicationEntity> prequaliFicationList = prequaliFicationService.queryList(param, false);
            prequaliFicationList.forEach((item) -> {
                String id = item.getId().toString();
                CommonResponse<String> stringCommonResponse = iBpmApi.stopProcess(id, BidBillTypeEnum.ZI_GE_YU_SHEN.getCode());
                logger.info("22222222终身返回信息：{}", stringCommonResponse.toString());
            });
            //查询该投标报名信息的审批中的招标文件评审，中止流程
            List<BiddingFileReviewEntity> biddingFileReviewList = biddingFileReviewService.queryList(param, false);
            biddingFileReviewList.forEach((item) -> {
                String id = item.getId().toString();
                iBpmApi.stopProcess(id, BidBillTypeEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            //查询该投标报名信息的审批中的投标文件评审，中止流程
            List<BidFileReviewEntity> bidFileReviewList = bidFileReviewService.queryList(param, false);
            bidFileReviewList.forEach((item) -> {
                String id = item.getId().toString();
                iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            //查询该投标报名信息的审批中的投标总结，中止流程
            param = new QueryParam();
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                    BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                    BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()
            )));
            param.getParams().put("enrollId", new Parameter(QueryParam.EQ, enrollId));
            List<SummaryEntity> summaryList = summaryService.queryList(param, false);
            summaryList.forEach((item) -> {
                String id = item.getId().toString();
                iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_ZONG_JIE.getCode());
            });
            return resp;
        }

    }

}
