package com.ejianc.business.bid.controller.external;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Controller
@RequestMapping("statistic")
public class StatisticController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description getBidState 投标状态
     * @param timeFlag
     */
    @RequestMapping(value = "/getBidState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidState(String timeFlag) {
        List<ResultVO> resultVOS = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        // 工程编码
        List<String> engineeringCodeS = new ArrayList<>();
        engineeringCodeS.add("T999999");
        // 跟踪
        QueryWrapper<InfoTrackEntity> infoTrackWrapper = new QueryWrapper<>();
        infoTrackWrapper.in("org_id",orgIdList);
        infoTrackWrapper.eq("follow_state", BidStateEnum.GEN_ZONG_ZHONG.getCode());
        if(!StringUtils.isEmpty(timeFlag) && timeFlag.equals("thisYear")){
            infoTrackWrapper.ge("bill_date", DateUtil.getYear()+"-01-01");
        }
        List<InfoTrackEntity> infoTrackList = infoTrackService.list(infoTrackWrapper);
        infoTrackList.forEach(item->{
            engineeringCodeS.add(item.getBillCode());
        });
        ResultVO InfoTrackResultVO = new ResultVO("跟踪信息",infoTrackList.size());
        // 报名
        List<EnrollEntity> enrollList = new ArrayList<>();
        QueryWrapper<EnrollEntity> enrollWrapper = new QueryWrapper<>();
        enrollWrapper.in("org_id",orgIdList);
        enrollWrapper.ne("bid_stage",BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode());
        if(!StringUtils.isEmpty(timeFlag) && timeFlag.equals("thisYear")){
            enrollWrapper.ge("sign_date",DateUtil.getYear()+"-01-01");
            // 查询时间是本年的
            List<EnrollEntity> list1 = enrollService.list(enrollWrapper);
            // 查询时间不是本年 但是却符合信息跟踪的数据
            enrollWrapper = new QueryWrapper<>();
            enrollWrapper.in("org_id",orgIdList);
            enrollWrapper.ne("bid_stage",BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode());
            enrollWrapper.in("bill_code",engineeringCodeS);
            enrollWrapper.lt("sign_date",DateUtil.getYear()+"-01-01");
            List<EnrollEntity> list2 = enrollService.list(enrollWrapper);
            list1.addAll(list2);
            enrollList = list1;
        }else{
            enrollList = enrollService.list(enrollWrapper);
        }
        ResultVO enrollResultVO = new ResultVO("投标报名",enrollList.size());
        List<Long> enrollIds = new ArrayList<>();
        enrollIds.add(999999L);
        enrollList.forEach(item->{
            enrollIds.add(item.getId());
        });

        logger.info("----------------");
        logger.info(enrollIds.toString());
        // 资格预算
        QueryWrapper<PrequaliFicationEntity> prequaliFicationWrapper = new QueryWrapper<>();
        prequaliFicationWrapper.in("org_id",orgIdList);
        prequaliFicationWrapper.eq("estimated_examine_result", BidCommonConsts.YES);
        prequaliFicationWrapper.in("enroll_id",enrollIds);
        int count = prequaliFicationService.count(prequaliFicationWrapper);
        ResultVO prequaliFicationResultVO = new ResultVO("资格入围",count);

        // 投标评审
        QueryWrapper<BidFileReviewEntity> bidFileReviewWrapper = new QueryWrapper<>();
        bidFileReviewWrapper.in("org_id",orgIdList);
        bidFileReviewWrapper.in("enroll_id",enrollIds);
        int count1 = bidFileReviewService.count(bidFileReviewWrapper);
        ResultVO bidFileReviewFicationResultVO = new ResultVO("投标评审",count1);

        // 中标
        QueryWrapper<SummaryEntity> summaryWrapper = new QueryWrapper<>();
        summaryWrapper.in("org_id",orgIdList);
        summaryWrapper.eq("bid_result", 0);
        summaryWrapper.in("enroll_id",enrollIds);
        int count2 = summaryService.count(summaryWrapper);
        ResultVO summaryResultVO = new ResultVO("中标",count2);

        resultVOS.add(InfoTrackResultVO);
        resultVOS.add(enrollResultVO);
        resultVOS.add(prequaliFicationResultVO);
        resultVOS.add(bidFileReviewFicationResultVO);
        resultVOS.add(summaryResultVO);
        return CommonResponse.success(resultVOS);
    }

    /**
     * @Description getBidSurvey 投标t统计
     * @param timeFlag
     */
    @RequestMapping(value = "/getBidSurvey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidSurvey(String timeFlag) {
        List<ResultVO> resultVOS = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());

        // 投标总数
        List<EnrollEntity> enrollList = new ArrayList<>();
        QueryWrapper<EnrollEntity> enrollWrapper = new QueryWrapper<>();
        enrollWrapper.in("org_id",orgIdList);
        enrollWrapper.ne("bid_stage",BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode());
        if(!StringUtils.isEmpty(timeFlag) && timeFlag.equals("thisYear")){
            enrollWrapper.ge("sign_date",DateUtil.getYear()+"-01-01");
        }
        enrollList = enrollService.list(enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("投标总数",enrollList.size());

        // 预计开标数
        List<EnrollEntity> collect = enrollList.stream().filter(enroll -> BidStateEnum.JIN_XING_ZHONG.getCode().equals(enroll.getBidState())).collect(Collectors.toList());
        ResultVO collectResultVO = new ResultVO("预计开标数",collect.size());

        // 中标数
        List<Long> enrollIds = new ArrayList<>();
        enrollIds.add(999999L);
        enrollList.forEach(item->{
            enrollIds.add(item.getId());
        });
        QueryWrapper<SummaryEntity> summaryWrapper = new QueryWrapper<>();
        summaryWrapper.in("org_id",orgIdList);
        summaryWrapper.eq("bid_result", 0);
        summaryWrapper.in("enroll_id",enrollIds);
        int count = summaryService.count(summaryWrapper);
        ResultVO summaryResultVO = new ResultVO("中标数",count);

        resultVOS.add(enrollResultVO);
        resultVOS.add(summaryResultVO);
        resultVOS.add(collectResultVO);
        return CommonResponse.success(resultVOS);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



}
