package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.BidFileReviewEntity;
import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.bean.ZjllEntity;
import com.ejianc.business.constructor.service.IZjllService;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("bidFileReview")
public class BidFileReviewBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBidFileReviewService bidFileReviewService;
	@Autowired
	private IRecordService recordService;
	@Autowired
	private IEnrollService enrollService;
	@Autowired
	private IInstoreApi iInstoreApi;
	@Autowired
	private IZjllApi zjllApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IEmployeeApi employeeApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("投标文件评审，提交前回调");
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		logger.info("投标数据提交回调，开始回写状态,billId:"+billId);
		BidFileReviewEntity bidFileReviewEntity = bidFileReviewService.selectById(billId);
		if(null != bidFileReviewEntity) {
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, bidFileReviewEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
			if(!"不投标".equals(bidFileReviewEntity.getReviewResultName())){
				updateWrapper.set(EnrollEntity::getIsBidChecked, BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("投标文件评审，有审批流的撤回前回调，billId："+billId);
		BidFileReviewEntity bidFileReviewEntity = bidFileReviewService.selectById(billId);
		if (bidFileReviewEntity != null) {
			recordService.saveRecord(BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN, billId, bidFileReviewEntity.getEngineeringCode());
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, bidFileReviewEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
			if(!"不投标".equals(bidFileReviewEntity.getReviewResultName())) {
				updateWrapper.set(EnrollEntity::getIsBidChecked, BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("投标文件评审，有审批流的撤回后回调，billId："+billId);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审完成，开始回写状态，billId:"+billId);
		BidFileReviewEntity bidFileReviewEntity = bidFileReviewService.selectById(billId);
		if (bidFileReviewEntity != null) {
			recordService.saveRecord(BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN, billId, bidFileReviewEntity.getEngineeringCode());
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, bidFileReviewEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
			if(!"不投标".equals(bidFileReviewEntity.getReviewResultName())) {
				updateWrapper.set(EnrollEntity::getIsBidChecked, BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);

			/*
			 * 投标评审后更新在建人员履历
			 * */

			//通过建造师编号查询员工信息
//			CommonResponse<EmployeeVO> byEmpmloyeeCode = employeeApi.getByEmpmloyeeCode(bidFileReviewEntity.getEmployeeCode());
//
//			if (!byEmpmloyeeCode.isSuccess()){
//				throw new BusinessException("通过EmpmloyeeCode获取员工信息数据失败！ 员工编码为： " +bidFileReviewEntity.getEmployeeCode() );
//			}
//			EmployeeVO employeeVO = byEmpmloyeeCode.getData();

			ZjllEntity zjllEntity =new ZjllEntity();
			zjllEntity.setXmId(bidFileReviewEntity.getPid());//使用查询到的员工信息id作为 在建履历的姓名id
			zjllEntity.setXmName(bidFileReviewEntity.getBuiltConstructor());
			zjllEntity.setGwId(561958846671749219L);
			zjllEntity.setGw("项目经理");
			zjllEntity.setProjectId(bidFileReviewEntity.getEngineeringId());
			zjllEntity.setProjectName(bidFileReviewEntity.getEngineeringName());
			zjllEntity.setKssj(new Date());
			zjllEntity.setZt(0);
			zjllEntity.setYxzt(0); //0:是 1 否
			zjllEntity.setOrgId(bidFileReviewEntity.getOrgId());
			zjllEntity.setOrgName(bidFileReviewEntity.getOrgName());
			zjllEntity.setZsbh(bidFileReviewEntity.getZcbh());
			zjllEntity.setTags("在建履历");
			ZjllVO vo = BeanMapper.map(zjllEntity,ZjllVO.class);
			zjllApi.save(vo);
			logger.info("投标文件评审保存项目经理数据到在建人员履历！");
			if(bidFileReviewEntity.getBidFileType() == 0){//0是纸质标
				//审批通过对项目用印申请新增一条数据
				YysqVO yysqVO = new YysqVO();
				yysqVO.setBidId(billId);  //投标文件评审id
				yysqVO.setOrgId(bidFileReviewEntity.getOrgId());  //组织id
				yysqVO.setOrgName(bidFileReviewEntity.getOrgName());  //组织名称
				yysqVO.setBidCode(bidFileReviewEntity.getBillCode());  //投标文件评审编码
				yysqVO.setYysxId(556485844756602972L);
				yysqVO.setYysxName("投标管理-投标文件评审");
				//yysqVO.setYysxCode("/ejc-bid-frontend/#/bidFileReview/card");
				yysqVO.setYyReason("投标管理-投标文件评审-" + bidFileReviewEntity.getBillCode());  //用印事由
				yysqVO.setDjlj("/ejc-bid-frontend/#/bidFileReview/card");//单据链接
				yysqVO.setSqdwId(bidFileReviewEntity.getOrgId());  //申请单位id
				yysqVO.setSqdwName(bidFileReviewEntity.getOrgName());  //申请单位name
				yysqVO.setSqrId(sessionManager.getUserContext().getUserId());  //负责人id
				yysqVO.setSqrName(sessionManager.getUserContext().getUserName());  //负责人name
				yysqVO.setCreateUserCode(bidFileReviewEntity.getCreateUserCode());  //创建人
				yysqVO.setCreateUserName(sessionManager.getUserContext().getUserName());  //负责人名称
				//yysqVO.setSqxmId(bidFileReviewEntity.getEngineeringId());  // 工程id
				//yysqVO.setSqxmName(bidFileReviewEntity.getEngineeringName());  // 工程名称
				//审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
				//因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
				CommonResponse<YzdjVO> yzdjVOCommonResponse = iInstoreApi.selectYzxxByCode("YZ-001");
				YzdjVO data = yzdjVOCommonResponse.getData();
				//Long yzlbId = 1472851128843505665L;
				yysqVO.setYzbhId(data.getId());
				yysqVO.setYzlbId(data.getYzlbId());
				yysqVO.setYzlbName(data.getYzlbName());
				//Long yzjbId = 1472858324830523394L;
				yysqVO.setYzjbId(data.getYzjbId());
				yysqVO.setYzjbName(data.getYzjbName());
				//Long yylxId = 1472859069613084673L;
				yysqVO.setYylxId(data.getYylxId());
				yysqVO.setYylxName(data.getYylxName());
				yysqVO.setBillState(3);  //推送数据默认为审批通过的
				yysqVO.setMessageFrom(1);// 数据来源：0自建，1原始审批单据
				yysqVO.setZkbmId(1502571153481273346L);//主控部门ID
				yysqVO.setZkbmName("经营部");//主控部门name
				yysqVO.setXgcs(0);//修改次数

				CommonResponse<String> yysqBack = iInstoreApi.addYysq(yysqVO);
				if(!yysqBack.isSuccess()){
					throw new BusinessException("新增项目用印申请表数据失败，原因：xxxx" + yysqBack);
				}
				logger.info("发送投标文件评审数据：{终审审核完回调}");


			}
		}




		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("投标数据撤回回调，开始回写状态,billId:"+billId);
		BidFileReviewEntity bidFileReviewEntity = bidFileReviewService.selectById(billId);
		if(null != bidFileReviewEntity) {
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, bidFileReviewEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
			if(!"不投标".equals(bidFileReviewEntity.getReviewResultName())) {
				updateWrapper.set(EnrollEntity::getIsBidChecked,BidCommonConsts.NO);
			}
			enrollService.update(updateWrapper);
		}
		if(billId != null){
			recordService.saveRecord(BidStageEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN, billId, bidFileReviewEntity.getEngineeringCode());
			LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
			updateWrapper.eq(RecordEntity::getBillId,billId);
			recordService.remove(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
