package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service("enroll")
public class EnrollBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IEnrollService enrollService;

    @Autowired
    private IInfoTrackService infoTrackService;

    @Autowired
    private IRecordService recordService;

    @Autowired
    private IInstoreApi iInstoreApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //审批完后需要 回写
        EnrollEntity entity = enrollService.getById(billId);
        if(entity != null && BidStateEnum.YI_JIE_SHU.getCode().equals(entity.getBidState())){
            return CommonResponse.success("投标停止或结束，不允许重新提交!");
        }
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *  配了审批流，点了提交后走的提交完回调
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("提交完回调");
        //审批通过对项目用印申请新增一条数据
        EnrollEntity enrollEntity =enrollService.getById(billId);
        YysqVO yysqVO = new YysqVO();
        yysqVO.setBidId(billId);  //投标报名id
        yysqVO.setOrgId(enrollEntity.getOrgId());  //组织id
        yysqVO.setOrgName(enrollEntity.getOrgName());  //组织名称
        yysqVO.setBidCode(enrollEntity.getBillCode());  //投标报名编码
        yysqVO.setYysxId(554621914530717737L);
        yysqVO.setYysxName("投标管理-投标报名");
        yysqVO.setYysxCode("/ejc-bid-frontend/#/enroll/card");
        //yysqVO.setYysx("enroll/card");  //用印事项，存投标报名的访问路径
        yysqVO.setYyReason("投标管理-投标报名-" + enrollEntity.getBillCode());  //用印事由
        iInstoreApi.addYysq(yysqVO);
        logger.info("接收到投标报名Task参数：{提交完回调}");

        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *  终审和直审完回调
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核完回调");
        //审批完后需要 回写
        EnrollEntity entity = enrollService.getById(billId);
        Integer sourceType = entity.getSourceType();
        Long sourceId = entity.getSourceId();
        String engineeringName = entity.getEngineeringName();
        //来源是信息跟踪 更新报名状态和历史工程名
        if (BidCommonConsts.NO.equals(sourceType) && sourceId != null) {
            InfoTrackEntity info = infoTrackService.getById(sourceId);
            if (null != info) {
                String _engineeringName = info.getEngineeringName();
                LambdaUpdateWrapper<InfoTrackEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(InfoTrackEntity::getId, info.getId());
                updateWrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.YI_BAO_MING.getCode());
                if (!engineeringName.equals(_engineeringName)) {
                    updateWrapper.set(InfoTrackEntity::getHisEngineeringName, _engineeringName);
                    updateWrapper.set(InfoTrackEntity::getEngineeringName, engineeringName);
                }
                infoTrackService.update(updateWrapper);
            }
        }

        recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, entity.getBillCode());

        //审批通过对项目用印申请新增一条数据
        /*YysqVO yysqVO = new YysqVO();
        yysqVO.setBidId(billId);  //投标报名id
        yysqVO.setOrgId(entity.getOrgId());  //组织id
        yysqVO.setOrgName(entity.getOrgName());  //组织名称
        yysqVO.setBidCode(entity.getBillCode());  //投标报名编码
        yysqVO.setYysxId(554621914530717737L);
        yysqVO.setYysxName("投标管理-投标报名");
       // yysqVO.setYysxCode("/ejc-bid-frontend/#/enroll/card");
       // yysqVO.setYysx("enroll/card");  //用印事项，存投标报名的访问路径
        yysqVO.setYyReason("投标管理-投标报名-" + entity.getBillCode());  //用印事由
        yysqVO.setDjlj("/ejc-bid-frontend/#/enroll/card");//单据链接
        yysqVO.setSqdwId(entity.getOrgId());  //申请单位id
        yysqVO.setSqdwName(entity.getOrgName());  //申请单位name
        yysqVO.setSqrId(sessionManager.getUserContext().getUserId());  //负责人id
        yysqVO.setSqrName(sessionManager.getUserContext().getUserName());  //负责人name
        yysqVO.setCreateUserCode(entity.getCreateUserCode());  //创建人
        yysqVO.setCreateUserName(sessionManager.getUserContext().getUserName());  //负责人名称
        //审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
        //因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
        CommonResponse<YzdjVO> yzdjVOCommonResponse = iInstoreApi.selectYzxxByCode("YZ-001");
        YzdjVO data = yzdjVOCommonResponse.getData();

        yysqVO.setYzbhId(data.getId());
        yysqVO.setYzlbId(data.getYzlbId());
        yysqVO.setYzlbName(data.getYzlbName());
        yysqVO.setYzjbId(data.getYzjbId());
        yysqVO.setYzjbName(data.getYzjbName());
        yysqVO.setYylxId(data.getYylxId());
        yysqVO.setYylxName(data.getYylxName());
        yysqVO.setBillState(3);  //推送数据默认为审批通过的
        yysqVO.setMessageFrom(1);// 数据来源：0自建，1原始审批单据
        yysqVO.setZkbmId(1502571153481273346L);//主控部门ID
        yysqVO.setZkbmName("经营部");//主控部门name
        yysqVO.setXgcs(0);//修改次数

        CommonResponse<String> yysqBack = iInstoreApi.addYysq(yysqVO);
        if(!yysqBack.isSuccess()){
            throw new BusinessException("新增项目用印申请表数据失败，原因：xxxx" + yysqBack);
        }
        logger.info("发送投标报名数据：{终审审核完回调}");
*/
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        //单据未被下游单据引用
        if (res.isSuccess()) {
            //删除记录
            LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
            updateWrapper.eq(RecordEntity::getBillId, billId);
            recordService.remove(updateWrapper);

            EnrollEntity entity = enrollService.getById(billId);
            Integer sourceType = entity.getSourceType();
            Long sourceId = entity.getSourceId();
            //来源是信息跟踪 更新报名状态和历史工程名
            if (BidCommonConsts.NO.equals(sourceType) && sourceId != null) {
                InfoTrackEntity info = infoTrackService.getById(sourceId);
                if (null != info) {
                    LambdaUpdateWrapper<InfoTrackEntity> wrapper = new LambdaUpdateWrapper<>();
                    wrapper.eq(InfoTrackEntity::getId, info.getId());
                    wrapper.eq(InfoTrackEntity::getFollowState, BidStateEnum.YI_BAO_MING.getCode());
                    wrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.GEN_ZONG_ZHONG.getCode());
                    infoTrackService.update(wrapper);
                }
            }
            return CommonResponse.success();
        } else {
            return CommonResponse.error(res.getMsg());
        }


    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }


}

