/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller.external;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statistic"})
public class StatisticController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/getBidState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidState(String timeFlag) {
        ArrayList<ResultVO> resultVOS = new ArrayList<ResultVO>();
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = io.micrometer.core.instrument.util.StringUtils.isNotBlank((String)authOrgIds) ? (List)this.getRespData(this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List orgIdList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper infoTrackWrapper = new QueryWrapper();
        infoTrackWrapper.in((Object)"org_id", orgIdList);
        infoTrackWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(bill_date)", (Object)DateUtil.getYear());
        int infoCount = this.infoTrackService.count((Wrapper)infoTrackWrapper);
        ResultVO InfoTrackResultVO = new ResultVO("\u8ddf\u8e2a\u4fe1\u606f", Integer.valueOf(infoCount));
        QueryWrapper enrollWrapper = new QueryWrapper();
        enrollWrapper.in((Object)"org_id", orgIdList);
        enrollWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(sign_date)", (Object)DateUtil.getYear());
        int entrollCount = this.enrollService.count((Wrapper)enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("\u6295\u6807\u62a5\u540d", Integer.valueOf(entrollCount));
        QueryWrapper prequaliFicationWrapper = new QueryWrapper();
        prequaliFicationWrapper.in((Object)"org_id", orgIdList);
        prequaliFicationWrapper.eq((Object)"estimated_examine_result", (Object)BidCommonConsts.YES);
        prequaliFicationWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(estimated_examine_date)", (Object)DateUtil.getYear());
        int count = this.prequaliFicationService.count((Wrapper)prequaliFicationWrapper);
        ResultVO prequaliFicationResultVO = new ResultVO("\u8d44\u683c\u5165\u56f4", Integer.valueOf(count));
        QueryWrapper bidFileReviewWrapper = new QueryWrapper();
        bidFileReviewWrapper.in((Object)"org_id", orgIdList);
        bidFileReviewWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(review_date)", (Object)DateUtil.getYear());
        int count1 = this.bidFileReviewService.count((Wrapper)bidFileReviewWrapper);
        ResultVO bidFileReviewFicationResultVO = new ResultVO("\u6295\u6807\u8bc4\u5ba1", Integer.valueOf(count1));
        QueryWrapper summaryWrapper = new QueryWrapper();
        summaryWrapper.in((Object)"org_id", orgIdList);
        summaryWrapper.eq((Object)"bid_result", (Object)0);
        summaryWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(win_bidding_date)", (Object)DateUtil.getYear());
        int count2 = this.summaryService.count((Wrapper)summaryWrapper);
        ResultVO summaryResultVO = new ResultVO("\u4e2d\u6807", Integer.valueOf(count2));
        resultVOS.add(InfoTrackResultVO);
        resultVOS.add(enrollResultVO);
        resultVOS.add(prequaliFicationResultVO);
        resultVOS.add(bidFileReviewFicationResultVO);
        resultVOS.add(summaryResultVO);
        return CommonResponse.success(resultVOS);
    }

    @RequestMapping(value={"/getBidSurvey"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidSurvey(String timeFlag) {
        ArrayList<ResultVO> resultVOS = new ArrayList<ResultVO>();
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = io.micrometer.core.instrument.util.StringUtils.isNotBlank((String)authOrgIds) ? (List)this.getRespData(this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List orgIdList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List enrollList = new ArrayList();
        QueryWrapper enrollWrapper = new QueryWrapper();
        enrollWrapper.in((Object)"org_id", orgIdList);
        enrollWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(sign_date)", (Object)DateUtil.getYear());
        enrollList = this.enrollService.list((Wrapper)enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("\u6295\u6807\u603b\u6570", Integer.valueOf(enrollList.size()));
        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6L);
        LocalDate afterOneMonthDay = today.plusDays(29L);
        QueryWrapper monthWrapper = new QueryWrapper();
        monthWrapper.in((Object)"org_id", orgIdList);
        monthWrapper.eq((Object)"bid_state", (Object)BidStateEnum.JIN_XING_ZHONG.getCode());
        monthWrapper.ge((Object)"bidding_date", (Object)today.toString());
        monthWrapper.le((Object)"bidding_date", (Object)afterOneMonthDay.toString());
        int count1 = this.enrollService.count((Wrapper)monthWrapper);
        ResultVO collectResultVO = new ResultVO("\u8fd1\u4e00\u6708\u9884\u8ba1\u5f00\u6807\u6570", Integer.valueOf(count1));
        QueryWrapper weekWrapper = new QueryWrapper();
        weekWrapper.in((Object)"org_id", orgIdList);
        weekWrapper.eq((Object)"bid_state", (Object)BidStateEnum.JIN_XING_ZHONG.getCode());
        weekWrapper.ge((Object)"bidding_date", (Object)today.toString());
        weekWrapper.le((Object)"bidding_date", (Object)afterOneWeekDay.toString());
        int count2 = this.enrollService.count((Wrapper)weekWrapper);
        ResultVO weekResultVO = new ResultVO("\u8fd1\u4e00\u5468\u9884\u8ba1\u5f00\u6807\u6570", Integer.valueOf(count2));
        ArrayList<Long> enrollIds = new ArrayList<Long>();
        Integer bidSumNum = 0;
        for (EnrollEntity enroll : enrollList) {
            enrollIds.add(enroll.getId());
            Integer bidNum = enroll.getBidNum() != null ? enroll.getBidNum() : 0;
            bidSumNum = bidSumNum + bidNum;
        }
        int count = 0;
        if (CollectionUtils.isNotEmpty(enrollIds)) {
            QueryWrapper summaryWrapper = new QueryWrapper();
            summaryWrapper.in((Object)"org_id", orgIdList);
            summaryWrapper.eq((Object)"bid_result", (Object)0);
            summaryWrapper.in((Object)"enroll_id", enrollIds);
            count = this.summaryService.count((Wrapper)summaryWrapper);
        }
        ResultVO summaryResultVO = new ResultVO("\u4e2d\u6807\u6570", Integer.valueOf(count));
        ResultVO bidSumNumVO = new ResultVO("\u6807\u6bb5\u603b\u6570", bidSumNum);
        resultVOS.add(enrollResultVO);
        resultVOS.add(summaryResultVO);
        resultVOS.add(collectResultVO);
        resultVOS.add(weekResultVO);
        resultVOS.add(bidSumNumVO);
        return CommonResponse.success(resultVOS);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6L);
        LocalDate afterOneMonthDay = today.plusDays(29L);
        System.out.println(today);
        System.out.println(afterOneMonthDay);
        System.out.println(afterOneWeekDay);
    }
}

