package com.ejianc.business.bid.controller.external;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Controller
@RequestMapping("statistic")
public class StatisticController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @param timeFlag
     * @Description getBidState 投标状态
     */
    @RequestMapping(value = "/getBidState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidState(String timeFlag) {
        List<ResultVO> resultVOS = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());

        // 跟踪
        QueryWrapper<InfoTrackEntity> infoTrackWrapper = new QueryWrapper<>();
        infoTrackWrapper.in("org_id", orgIdList);
        infoTrackWrapper.eq("thisYear".equals(timeFlag), "YEAR(bill_date)", DateUtil.getYear());
        int infoCount = infoTrackService.count(infoTrackWrapper);
        ResultVO InfoTrackResultVO = new ResultVO("跟踪信息", infoCount);

        // 报名
        QueryWrapper<EnrollEntity> enrollWrapper = new QueryWrapper<>();
        enrollWrapper.in("org_id", orgIdList);
        enrollWrapper.eq("thisYear".equals(timeFlag), "YEAR(sign_date)", DateUtil.getYear());
        int entrollCount = enrollService.count(enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("投标报名", entrollCount);

        // 资审入围
        QueryWrapper<PrequaliFicationEntity> prequaliFicationWrapper = new QueryWrapper<>();
        prequaliFicationWrapper.in("org_id", orgIdList);
        prequaliFicationWrapper.eq("estimated_examine_result", BidCommonConsts.YES);
        prequaliFicationWrapper.eq("thisYear".equals(timeFlag), "YEAR(estimated_examine_date)", DateUtil.getYear());
        int count = prequaliFicationService.count(prequaliFicationWrapper);
        ResultVO prequaliFicationResultVO = new ResultVO("资格入围", count);

        // 投标评审
        QueryWrapper<BidFileReviewEntity> bidFileReviewWrapper = new QueryWrapper<>();
        bidFileReviewWrapper.in("org_id", orgIdList);
        bidFileReviewWrapper.eq("thisYear".equals(timeFlag), "YEAR(review_date)", DateUtil.getYear());
        int count1 = bidFileReviewService.count(bidFileReviewWrapper);
        ResultVO bidFileReviewFicationResultVO = new ResultVO("投标评审", count1);

        // 中标
        QueryWrapper<SummaryEntity> summaryWrapper = new QueryWrapper<>();
        summaryWrapper.in("org_id", orgIdList);
        summaryWrapper.eq("bid_result", 0);
        summaryWrapper.eq("thisYear".equals(timeFlag), "YEAR(win_bidding_date)", DateUtil.getYear());
        int count2 = summaryService.count(summaryWrapper);
        ResultVO summaryResultVO = new ResultVO("中标", count2);

        resultVOS.add(InfoTrackResultVO);
        resultVOS.add(enrollResultVO);
        resultVOS.add(prequaliFicationResultVO);
        resultVOS.add(bidFileReviewFicationResultVO);
        resultVOS.add(summaryResultVO);
        return CommonResponse.success(resultVOS);
    }

    /**
     * @param timeFlag
     * @Description getBidSurvey 投标统计
     */
    @RequestMapping(value = "/getBidSurvey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidSurvey(String timeFlag) {
        List<ResultVO> resultVOS = new ArrayList<>();
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        List<Long> orgIdList = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());

        // 投标总数
        List<EnrollEntity> enrollList = new ArrayList<>();
        QueryWrapper<EnrollEntity> enrollWrapper = new QueryWrapper<>();
        enrollWrapper.in("org_id", orgIdList);
        enrollWrapper.eq("thisYear".equals(timeFlag), "YEAR(sign_date)", DateUtil.getYear());
        enrollList = enrollService.list(enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("投标总数", enrollList.size());

        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6);
        LocalDate afterOneMonthDay = today.plusDays(29);
        // 近一月预计开标数
        QueryWrapper<EnrollEntity> monthWrapper = new QueryWrapper<>();
        monthWrapper.in("org_id", orgIdList);
        monthWrapper.eq("bid_state", BidStateEnum.JIN_XING_ZHONG.getCode());
        monthWrapper.ge("bidding_date", today.toString());
        monthWrapper.le("bidding_date", afterOneMonthDay.toString());
        int count1 = enrollService.count(monthWrapper);
        ResultVO collectResultVO = new ResultVO("近一月预计开标数", count1);

        // 近一周预计开标数
        QueryWrapper<EnrollEntity> weekWrapper = new QueryWrapper<>();
        weekWrapper.in("org_id", orgIdList);
        weekWrapper.eq("bid_state", BidStateEnum.JIN_XING_ZHONG.getCode());
        weekWrapper.ge("bidding_date", today.toString());
        weekWrapper.le("bidding_date", afterOneWeekDay.toString());
        int count2 = enrollService.count(weekWrapper);
        ResultVO weekResultVO = new ResultVO("近一周预计开标数", count2);

        // 中标数
        List<Long> enrollIds = new ArrayList<>();
        Integer bidSumNum = 0;
        for (EnrollEntity enroll : enrollList) {
            enrollIds.add(enroll.getId());
            Integer bidNum = enroll.getBidNum() != null ? enroll.getBidNum() : 0;
            bidSumNum += bidNum;
        }
        int count = 0;
        if (CollectionUtils.isNotEmpty(enrollIds)) {
            QueryWrapper<SummaryEntity> summaryWrapper = new QueryWrapper<>();
            summaryWrapper.in("org_id", orgIdList);
            summaryWrapper.eq("bid_result", 0);
            summaryWrapper.in("enroll_id", enrollIds);
            count = summaryService.count(summaryWrapper);
        }
        ResultVO summaryResultVO = new ResultVO("中标数", count);
        ResultVO bidSumNumVO = new ResultVO("标段总数", bidSumNum);

        resultVOS.add(enrollResultVO);
        resultVOS.add(summaryResultVO);
        resultVOS.add(collectResultVO);
        resultVOS.add(weekResultVO);
        resultVOS.add(bidSumNumVO);
        return CommonResponse.success(resultVOS);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6);
        LocalDate afterOneMonthDay = today.plusDays(29);
        System.out.println(today);
        System.out.println(afterOneMonthDay);
        System.out.println(afterOneWeekDay);
    }

}
