/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="enroll")
public class EnrollBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IInstoreApi iInstoreApi;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        EnrollEntity entity = (EnrollEntity)((Object)this.enrollService.getById(billId));
        if (entity != null && BidStateEnum.YI_JIE_SHU.getCode().equals(entity.getBidState())) {
            return CommonResponse.success((String)"\u6295\u6807\u505c\u6b62\u6216\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u63d0\u4ea4!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InfoTrackEntity info;
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03");
        EnrollEntity entity = (EnrollEntity)((Object)this.enrollService.getById(billId));
        Integer sourceType = entity.getSourceType();
        Long sourceId = entity.getSourceId();
        String engineeringName = entity.getEngineeringName();
        if (BidCommonConsts.NO.equals(sourceType) && sourceId != null && null != (info = (InfoTrackEntity)((Object)this.infoTrackService.getById(sourceId)))) {
            String _engineeringName = info.getEngineeringName();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)info.getId());
            updateWrapper.set(InfoTrackEntity::getFollowState, (Object)BidStateEnum.YI_BAO_MING.getCode());
            if (!engineeringName.equals(_engineeringName)) {
                updateWrapper.set(InfoTrackEntity::getHisEngineeringName, (Object)_engineeringName);
                updateWrapper.set(InfoTrackEntity::getEngineeringName, (Object)engineeringName);
            }
            this.infoTrackService.update((Wrapper)updateWrapper);
        }
        this.recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, entity.getBillCode());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            InfoTrackEntity info;
            LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
            updateWrapper.eq(RecordEntity::getBillId, (Object)billId);
            this.recordService.remove((Wrapper)updateWrapper);
            EnrollEntity entity = (EnrollEntity)((Object)this.enrollService.getById(billId));
            Integer sourceType = entity.getSourceType();
            Long sourceId = entity.getSourceId();
            if (BidCommonConsts.NO.equals(sourceType) && sourceId != null && null != (info = (InfoTrackEntity)((Object)this.infoTrackService.getById(sourceId)))) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)info.getId());
                wrapper.eq(InfoTrackEntity::getFollowState, (Object)BidStateEnum.YI_BAO_MING.getCode());
                wrapper.set(InfoTrackEntity::getFollowState, (Object)BidStateEnum.GEN_ZONG_ZHONG.getCode());
                this.infoTrackService.update((Wrapper)wrapper);
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

