/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.mapper.UndertakeMapper;
import com.ejianc.business.bid.service.IUndertakeService;
import com.ejianc.business.bid.vo.UndertakeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bid/"})
public class UndertakeApi {
    @Autowired
    private IUndertakeService service;
    @Autowired
    private UndertakeMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/getContractValueByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value="orgId", required=true) Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        param.getParams().put("makeOrgId", new Parameter("in", departmentIds));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("ywDate", new Parameter("between", (Object)(LocalDate.now().getYear() + "-1-1," + LocalDate.now().getYear() + "-12-31")));
        BigDecimal bigDecimal = new BigDecimal(0.0);
        List undertakeEntities = this.service.queryList(param);
        for (UndertakeEntity entity : undertakeEntities) {
            bigDecimal = bigDecimal.add(entity.getProjectCost());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u603b\u91d1\u989d\u6210\u529f\uff01", (Object)bigDecimal);
    }

    @RequestMapping(value={"/getUndertakeInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> getUndertakeInfo(@RequestParam(value="orgId", required=true) Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        param.getParams().put("makeOrgId", new Parameter("in", departmentIds));
        param.getParams().put("ywDate", new Parameter("between", (Object)(LocalDate.now().getYear() + "-1-1," + LocalDate.now().getYear() + "-12-31")));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"speciality_id"});
        List<UndertakeVO> undertakeVOS = this.service.queryUndertakeInfoList(wrapper);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (UndertakeVO vo : undertakeVOS) {
            if (vo.getSpecialityCode().equals("3")) {
                map.put("\u88c5\u4fee\u88c5\u9970\u5de5\u7a0b", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("4")) {
                map.put("\u5e55\u5899\u5de5\u7a0b", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("5")) {
                map.put("\u673a\u7535\u8bbe\u5907\u6d88\u9632\u8bbe\u65bd\u5de5\u7a0b", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("6")) {
                map.put("\u5730\u57fa\u4e0e\u57fa\u7840\u5de5\u7a0b", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("7")) {
                map.put("\u4f53\u80b2\u573a\u5730\u8bbe\u65bd\u5de5\u7a0b", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("8")) {
                map.put("\u516c\u8def\u5de5\u7a0b", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("9")) {
                map.put("\u5176\u5b83", vo.getProjectCost());
                continue;
            }
            if (vo.getSpecialityCode().equals("101") || vo.getSpecialityCode().equals("102") || vo.getSpecialityCode().equals("103")) {
                if (map.containsKey("\u623f\u5c4b\u5efa\u7b51")) {
                    map.put("\u623f\u5c4b\u5efa\u7b51", ((BigDecimal)map.get("\u623f\u5c4b\u5efa\u7b51")).add(vo.getProjectCost()));
                    continue;
                }
                map.put("\u623f\u5c4b\u5efa\u7b51", vo.getProjectCost());
                continue;
            }
            if (!vo.getSpecialityCode().equals("201") && !vo.getSpecialityCode().equals("202") && !vo.getSpecialityCode().equals("203") && !vo.getSpecialityCode().equals("204")) continue;
            if (map.containsKey("\u5e02\u653f\u516c\u7528\u5de5\u7a0b")) {
                map.put("\u5e02\u653f\u516c\u7528\u5de5\u7a0b", ((BigDecimal)map.get("\u5e02\u653f\u516c\u7528\u5de5\u7a0b")).add(vo.getProjectCost()));
                continue;
            }
            map.put("\u5e02\u653f\u516c\u7528\u5de5\u7a0b", vo.getProjectCost());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

