/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.bean.TrackProjectEntity;
import com.ejianc.business.bid.bean.TrackProjectZiEntity;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.ITrackProjectService;
import com.ejianc.business.bid.service.ITrackProjectZiService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="infoTrack")
public class InfoTrackBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private ITrackProjectService trackProjectService;
    @Autowired
    private ITrackProjectZiService trackProjectZiService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InfoTrackEntity infoTrack;
        if (billId != null && (infoTrack = (InfoTrackEntity)((Object)this.infoTrackService.selectById(billId))) != null) {
            this.recordService.saveRecord(BidStageEnum.TOU_BIAO_XIN_XIN_GEN_ZONG, billId, infoTrack.getBillCode());
            if (infoTrack.getTrackProjectId() != null) {
                TrackProjectEntity entity = (TrackProjectEntity)((Object)this.trackProjectService.getById(infoTrack.getTrackProjectId()));
                entity.setTrackNum(entity.getTrackNum() + 1);
                TrackProjectZiEntity trackProjectZiEntity = new TrackProjectZiEntity();
                trackProjectZiEntity.setZhuId(infoTrack.getTrackProjectId());
                trackProjectZiEntity.setDepartmentId(infoTrack.getFollowUnit());
                trackProjectZiEntity.setDepartmentName(infoTrack.getFollowUnitName());
                List<TrackProjectZiEntity> trackProjectZiList = entity.getTrackProjectZiList();
                trackProjectZiList.add(trackProjectZiEntity);
                this.trackProjectService.saveOrUpdate((Object)entity);
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)updateWrapper.set(InfoTrackEntity::getTrackNum, (Object)(entity.getTrackNum() + 1))).eq(InfoTrackEntity::getTrackProjectId, (Object)infoTrack.getTrackProjectId());
                this.infoTrackService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
            updateWrapper.eq(RecordEntity::getBillId, (Object)billId);
            this.recordService.remove((Wrapper)updateWrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

