package com.ejianc.business.bid.mapper;

import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.vo.EnrollVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 投标报名
 * 
 * @author generator
 * 
 */
@Mapper
public interface EnrollMapper extends BaseCrudMapper<EnrollEntity> {
    //获取即将的开标(开始标前评审)
    List<EnrollVO> queryBidOpeningSoon();
    @Select("select * from ejc_bid_enroll where is_biddding_checked = 0 and dr = 0 and bill_state in (1,3) and bid_state in (1,2,3)")
    List<EnrollEntity> selectEnrollListIsBidding();

    @Select("select * from ejc_bid_enroll where bid_stage in (5,6) and bid_state in (1,2,3) and dr = 0 and bill_state in (1,3) ")
    List<EnrollEntity> selectEnrollListIsSummary();
}
