package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.bean.RyllEntity;
import com.ejianc.business.constructor.bean.ZjllEntity;
import com.ejianc.business.constructor.service.IRyllService;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("summary")
public class SummaryBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IRecordService recordService;
    @Autowired
    private ISummaryService summaryService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IInfoTrackService trackService;
    @Autowired
    private IRyllService ryllmxService;
    @Autowired
    private IZjllApi zjllApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SummaryEntity summaryEntity = summaryService.selectById(billId);
        if (summaryEntity != null) {
            if (summaryEntity.getBidResult() != null) {
                BidStageEnum bidStageEnum = summaryEntity.getBidResult() == 0 ? BidStageEnum.TOU_BIAO_ZONG_JIE_ZHONG_BIAO : BidStageEnum.TOU_BIAO_ZONG_JIE_WEI_ZHONG_BIAO;
                recordService.saveRecord(bidStageEnum, billId, summaryEntity.getEngineeringCode());

                Long enrollId = summaryEntity.getEnrollId();
                EnrollEntity enrollEntity = enrollService.selectById(enrollId);
                if (enrollEntity.getSourceId() != null) {
                    LambdaUpdateWrapper<InfoTrackEntity> infoTrackEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
                    infoTrackEntityLambdaUpdateWrapper.eq(InfoTrackEntity::getId, enrollEntity.getSourceId());
                    infoTrackEntityLambdaUpdateWrapper.set(InfoTrackEntity::getFollowState, BidStateEnum.YI_JIE_SHU.getCode());
                    trackService.update(infoTrackEntityLambdaUpdateWrapper);
                }
                LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(EnrollEntity::getId, summaryEntity.getEnrollId());
                updateWrapper.set(EnrollEntity::getBidState, BidStateEnum.YI_JIE_SHU.getCode());
                updateWrapper.set(EnrollEntity::getBidStage, bidStageEnum.getCode());
                enrollService.update(updateWrapper);
            }
            /*LambdaUpdateWrapper<RyllmxEntity> updateWrapper =new LambdaUpdateWrapper<>();
            updateWrapper.eq(RyllmxEntity::getProject,summaryEntity.getEngineeringName());
            updateWrapper.eq(RyllmxEntity::getYxzt,0);
            updateWrapper.eq(RyllmxEntity::getZt,0);
            updateWrapper.set(RyllmxEntity::getZt,1);
            ryllmxService.update(updateWrapper);*/


            //结束状态为0的
            ZjllVO zjllVO = new ZjllVO();
            zjllVO.setProjectId(summaryEntity.getEnrollId());
            zjllVO.setXmId(summaryEntity.getBuiltConstructorId());
            zjllVO.setZt(0);
            zjllVO.setYxzt(1);
            zjllVO.setJssj(new Date());
            zjllApi.updateWrapper(zjllVO);
            logger.info("投标总结 结束状态为0到 在建人员履历！");
            /*
             * 写入在建履历
             * */
            if (summaryEntity.getBidResult().equals(0)) {//已中标的新增
                ZjllEntity zjllEntity = new ZjllEntity();
                zjllEntity.setXmId(summaryEntity.getBuiltConstructorId());
                zjllEntity.setXmName(summaryEntity.getArchitect());
                zjllEntity.setGwId(561958846671749219L);
                zjllEntity.setGw("项目经理");
                zjllEntity.setProjectId(summaryEntity.getEnrollId());
                zjllEntity.setProjectName(summaryEntity.getEngineeringName());
                zjllEntity.setKssj(new Date());
                zjllEntity.setZt(1);
                zjllEntity.setYxzt(0); //0:是 1 否
                zjllEntity.setOrgId(summaryEntity.getOrgId());
                zjllEntity.setOrgName(summaryEntity.getOrgName());
                ZjllVO vo = BeanMapper.map(zjllEntity, ZjllVO.class);
                //zjllEntity.setZsbh(summaryEntity.getZcbh());
                zjllEntity.setTags("在建履历");
                zjllApi.save(vo);
                logger.info("投标总结 写入状态为1到 在建人员履历！");
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
        updateWrapper.eq(RecordEntity::getBillId, billId);
        recordService.remove(updateWrapper);
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
