/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.vo.SummaryVO;
import com.ejianc.business.bid.vo.WinningBidVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"summary"})
@Api(value="  \u6295\u6807\u603b\u7ed3 ", tags={"  \u6295\u6807\u603b\u7ed3 "})
public class SummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_SUMMARY_CODE";
    @Autowired
    private ISummaryService service;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SummaryVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SummaryVO saveorUpdateVO) {
        SummaryEntity entity = (SummaryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SummaryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setUseFlag(BidCommonConsts.NO);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (BidCommonConsts.NO.equals(entity.getQuotationForm()) && BidCommonConsts.NO.equals(entity.getBidResult())) {
            entity.setBiddingControlRate(null);
            entity.setBidQuotationRate(null);
            entity.setControlQuoteLowerRate(null);
            entity.setBidQuotationMny(null);
            entity.setBidWinnerLowerRate(null);
            entity.setBidWinningRate(null);
        } else if (BidCommonConsts.NO.equals(entity.getQuotationForm()) && BidCommonConsts.YES.equals(entity.getBidResult())) {
            entity.setBiddingControlRate(null);
            entity.setBidQuotationRate(null);
            entity.setControlQuoteLowerRate(null);
        } else if (BidCommonConsts.YES.equals(entity.getQuotationForm()) && BidCommonConsts.NO.equals(entity.getBidResult())) {
            entity.setBiddingControlMmy(null);
            entity.setQuoteLowerRate(null);
            entity.setBidQuotationMny(null);
            entity.setBidWinnerLowerRate(null);
            entity.setBidWinningRate(null);
        } else if (BidCommonConsts.YES.equals(entity.getQuotationForm()) && BidCommonConsts.YES.equals(entity.getBidResult())) {
            entity.setBiddingControlMmy(null);
            entity.setQuoteLowerRate(null);
            entity.setBidMmy(null);
        }
        this.service.saveOrUpdate((Object)entity, false);
        SummaryVO vo = (SummaryVO)BeanMapper.map((Object)((Object)entity), SummaryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SummaryVO> queryDetail(@RequestParam Long id) {
        SummaryEntity entity = (SummaryEntity)((Object)this.service.selectById(id));
        SummaryVO vo = (SummaryVO)BeanMapper.map((Object)((Object)entity), SummaryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SummaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinnerNews");
        fuzzyFields.add("bidEvaluationMethod");
        fuzzyFields.add("unitLeader");
        fuzzyFields.add("architect");
        fuzzyFields.add("bidUnit");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        fuzzyFields.add("bidEvaluationMethod");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List summaryVoS = BeanMapper.mapList((Iterable)list, SummaryVO.class);
        HashMap<String, List> beans = new HashMap<String, List>(summaryVoS.size());
        for (SummaryVO summaryVO : summaryVoS) {
            summaryVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)summaryVO.getBillState()).getDescription());
            summaryVO.setBidResultName(summaryVO.getBidResult().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) ? "\u5df2\u4e2d\u6807" : "\u672a\u4e2d\u6807");
        }
        beans.put("records", summaryVoS);
        ExcelExport.getInstance().export("Summary-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refsummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SummaryVO>> refsummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("engineeringName", "engineeringCode", "billCode", "bidWinner"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("bidResult", new Parameter("eq", (Object)BidCommonConsts.NO));
        param.getParams().put("quotationForm", new Parameter("eq", (Object)BidCommonConsts.NO));
        param.getParams().put("useFlag", new Parameter("eq", (Object)BidCommonConsts.NO));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u4f18\u60e0\u7387\u5206\u6790")
    @RequestMapping(value={"/preferentialRateAnalysisList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WinningBidVO>> preferentialRateAnalysisList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<WinningBidVO> winningBidVOS = this.service.queryWinningBidPage((Page<WinningBidVO>)page, wrapper);
        page.setTotal(page.getTotal());
        page.setRecords(winningBidVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ApiOperation(value="\u4f18\u60e0\u7387\u56fe\u8868\u6570\u636e")
    @RequestMapping(value={"/queryRateAnalysisDataList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryRateAnalysisDataList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByAsc((Object)"win_bidding_date");
        List<WinningBidVO> winningBidVOS = this.service.queryWinningBidList(wrapper);
        ArrayList tmp_list = new ArrayList();
        winningBidVOS.forEach(item -> {
            if (item.getQuoteLowerRate() != null) {
                item.setQuoteLowerRate(item.getQuoteLowerRate().setScale(2, 4));
                tmp_list.add(item.getQuoteLowerRate());
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", winningBidVOS);
        BigDecimal max = new BigDecimal("0");
        BigDecimal min = new BigDecimal("0");
        if (CollectionUtils.isNotEmpty(tmp_list)) {
            max = (BigDecimal)Collections.max(tmp_list);
            min = (BigDecimal)Collections.min(tmp_list);
        }
        map.put("max", max);
        map.put("min", min);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", map);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2d\u6807\u7387")
    @RequestMapping(value={"/getWinningRateAnalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WinningBidVO> getWinningRateAnalysis(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        Long tenantId = InvocationInfoProxy.getTenantid();
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("orgId", new Parameter("in", orgIds));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<WinningBidVO> winningBidVOS = this.service.queryWinningBidList(wrapper);
        WinningBidVO winningBidVO = this.service.querySumbidNumList(orgIds, tenantId);
        winningBidVO.setSumBidWinningNumber(Integer.valueOf(winningBidVOS.size()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)winningBidVO);
    }

    @ApiOperation(value="\u6821\u9a8c\u603b\u7ed3\u6b21\u6570")
    @RequestMapping(value={"/checkSummaryNumber"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkSummaryNumber(Long enrollId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("enroll_id", new Parameter("eq", (Object)enrollId));
        List summaryEntities = this.service.queryList(queryParam);
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List summaryEntityList = this.service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)summaryEntities)) {
            List collect = summaryEntities.stream().filter(s -> BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(s.getBillState())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect) && collect.size() > 0) {
                return CommonResponse.error((String)"\u53ea\u80fd\u6709\u4e00\u4e2a\u81ea\u7531\u6001,\u8bf7\u53ca\u65f6\u7684\u63d0\u4ea4\u4e4b\u524d\u7684\u5355\u5b50\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)summaryEntityList) && ((SummaryEntity)((Object)summaryEntityList.get(0))).getBidSectionNumber().equals(summaryEntityList.size())) {
                return CommonResponse.error((String)"\u6295\u6807\u603b\u7ed3\u6b21\u6570\u4e0d\u80fd\u8d85\u8fc7\u6807\u6bb5\u6570\u91cf\uff01");
            }
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01");
    }
}

