/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/summaryWarn/"})
public class BidSummaryWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBiddingFileReviewService service;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    static String PC_URL = "/ejc-bid-frontend/#/enroll?id=";

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList warnList = new ArrayList();
        String warnCode = null;
        if (jsonParam.size() > 0) {
            JSONObject o = jsonParam.getJSONObject(0);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray settings = o.getJSONArray("settings");
            JSONObject orgSet = null;
            JSONObject defaultSet = null;
            for (int i1 = 0; i1 < settings.size(); ++i1) {
                JSONObject set = settings.getJSONObject(i1);
                if (!set.getBoolean("default").booleanValue()) continue;
                defaultSet = set;
                break;
            }
            if (orgSet == null) {
                orgSet = defaultSet;
            }
            if (orgSet != null && ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) {
                JSONArray warningSetings = orgSet.getJSONArray("warningSetings");
                JSONObject billParams = warningSetings.getJSONObject(0);
                String parameterValue = billParams.getString("parameterValue");
                Integer day = 15;
                if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                    day = Integer.valueOf(parameterValue);
                }
                ArrayList<EnrollEntity> enrollEntityList = new ArrayList<EnrollEntity>();
                Date now = new Date();
                List<EnrollEntity> enrollEntities = this.enrollService.selectEnrollListIsSummary();
                for (EnrollEntity entity : enrollEntities) {
                    if ((now.getTime() - entity.getBiddingDate().getTime()) / 86400000L < (long)day.intValue()) continue;
                    enrollEntityList.add(entity);
                }
                if (CollectionUtils.isEmpty(enrollEntityList)) {
                    this.logger.error("\u6267\u884c\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u89c4\u5219\u7684\u9879\u76ee\u4fe1\u606f\uff01");
                    return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), warnCode);
                }
                return this.sendWarnToTask(this.transToWarnVO(enrollEntityList, orgSet, billParams, day), warnCode);
            }
            return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff01");
        }
        return CommonResponse.error((String)"\u83b7\u53d6\u53c2\u6570\u5931\u8d25\uff01");
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<EnrollEntity> result, JSONObject orgSet, JSONObject billParams, Integer day) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (EnrollEntity m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != orgSet.get((Object)"moduleName") ? orgSet.get((Object)"moduleName").toString() + " - " : "") + m.getEngineeringName());
            vo.setPcTitle("\u6295\u6807\u62a5\u540d");
            vo.setPcUrl(PC_URL + m.getId());
            vo.setOrgId(m.getOrgId());
            vo.setOrgName(m.getOrgName());
            vo.setSourceId(m.getBillCode());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(billParams.getString("warningLevel"));
            vo.setWarnSetId(orgSet.getLong("warnId"));
            vo.setEarlywarnName(orgSet.getString("warnName"));
            tmpContent = orgSet.getString("warningContentTemplate");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", m.getEngineeringName()).replaceAll("#day#", day.toString()));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }
}

