/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.BidFileReviewEntity;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.bean.ZjllEntity;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bidFileReview")
public class BidFileReviewBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IInstoreApi iInstoreApi;
    @Autowired
    private IZjllApi zjllApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\uff0c\u63d0\u4ea4\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u6570\u636e\u63d0\u4ea4\u56de\u8c03\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001,billId:" + billId);
        BidFileReviewEntity bidFileReviewEntity = (BidFileReviewEntity)((Object)this.bidFileReviewService.selectById(billId));
        if (null != bidFileReviewEntity) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)bidFileReviewEntity.getEnrollId());
            updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
            if (!"\u4e0d\u6295\u6807".equals(bidFileReviewEntity.getReviewResultName())) {
                updateWrapper.set(EnrollEntity::getIsBidChecked, (Object)BidCommonConsts.YES);
            }
            this.enrollService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\uff0c\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03\uff0cbillId\uff1a" + billId);
        BidFileReviewEntity bidFileReviewEntity = (BidFileReviewEntity)((Object)this.bidFileReviewService.selectById(billId));
        if (bidFileReviewEntity != null) {
            this.recordService.saveRecord(BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN, billId, bidFileReviewEntity.getEngineeringCode());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)bidFileReviewEntity.getEnrollId());
            updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
            if (!"\u4e0d\u6295\u6807".equals(bidFileReviewEntity.getReviewResultName())) {
                updateWrapper.set(EnrollEntity::getIsBidChecked, (Object)BidCommonConsts.YES);
            }
            this.enrollService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\uff0c\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03\uff0cbillId\uff1a" + billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5b8c\u6210\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001\uff0cbillId:" + billId);
        BidFileReviewEntity bidFileReviewEntity = (BidFileReviewEntity)((Object)this.bidFileReviewService.selectById(billId));
        if (bidFileReviewEntity != null) {
            this.recordService.saveRecord(BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN, billId, bidFileReviewEntity.getEngineeringCode());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)bidFileReviewEntity.getEnrollId());
            updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
            if (!"\u4e0d\u6295\u6807".equals(bidFileReviewEntity.getReviewResultName())) {
                updateWrapper.set(EnrollEntity::getIsBidChecked, (Object)BidCommonConsts.YES);
            }
            this.enrollService.update((Wrapper)updateWrapper);
            ZjllEntity zjllEntity = new ZjllEntity();
            zjllEntity.setXmId(bidFileReviewEntity.getPid());
            zjllEntity.setXmName(bidFileReviewEntity.getBuiltConstructor());
            zjllEntity.setProjectId(bidFileReviewEntity.getEngineeringId());
            zjllEntity.setRemark("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1");
            zjllEntity.setGwId(Long.valueOf(561958846671749219L));
            ZjllVO vo = (ZjllVO)BeanMapper.map((Object)zjllEntity, ZjllVO.class);
            CommonResponse stringCommonResponse = this.zjllApi.updateZjsZjll(vo);
            if (stringCommonResponse != null && stringCommonResponse.getCode() == 0) {
                this.logger.info("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\u4fee\u6539\u9879\u76ee\u7ecf\u7406\u6570\u636e\u5230\u5728\u5efa\u4eba\u5458\u5c65\u5386\uff01");
            } else {
                this.logger.info("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\u4fee\u6539\u9879\u76ee\u7ecf\u7406\u6570\u636e\u5230\u5728\u5efa\u4eba\u5458\u5c65\u5386\uff01\u5931\u8d25\uff01");
            }
            if (bidFileReviewEntity.getBidFileType() == 0) {
                YysqVO yysqVO = new YysqVO();
                yysqVO.setBidId(billId);
                yysqVO.setOrgId(bidFileReviewEntity.getOrgId());
                yysqVO.setOrgName(bidFileReviewEntity.getOrgName());
                yysqVO.setBidCode(bidFileReviewEntity.getBillCode());
                yysqVO.setYysxId(Long.valueOf(556485844756602972L));
                yysqVO.setYysxName("\u6295\u6807\u7ba1\u7406-\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1");
                yysqVO.setYyReason("\u6295\u6807\u7ba1\u7406-\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1-" + bidFileReviewEntity.getBillCode());
                yysqVO.setDjlj("/ejc-bid-frontend/#/bidFileReview/card");
                yysqVO.setSqdwId(bidFileReviewEntity.getOrgId());
                yysqVO.setSqdwName(bidFileReviewEntity.getOrgName());
                yysqVO.setSqrId(this.sessionManager.getUserContext().getUserId());
                yysqVO.setSqrName(this.sessionManager.getUserContext().getUserName());
                yysqVO.setCreateUserCode(bidFileReviewEntity.getCreateUserCode());
                yysqVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                CommonResponse yzdjVOCommonResponse = this.iInstoreApi.selectYzxxByCode("YZ-001");
                YzdjVO data = (YzdjVO)yzdjVOCommonResponse.getData();
                yysqVO.setYzbhId(data.getId());
                yysqVO.setYzlbId(data.getYzlbId());
                yysqVO.setYzlbName(data.getYzlbName());
                yysqVO.setYzjbId(data.getYzjbId());
                yysqVO.setYzjbName(data.getYzjbName());
                yysqVO.setYylxId(data.getYylxId());
                yysqVO.setYylxName(data.getYylxName());
                yysqVO.setBillState(Integer.valueOf(3));
                yysqVO.setMessageFrom(Integer.valueOf(1));
                yysqVO.setZkbmId(Long.valueOf(1502571153481273346L));
                yysqVO.setZkbmName("\u7ecf\u8425\u90e8");
                yysqVO.setXgcs(Integer.valueOf(0));
                CommonResponse yysqBack = this.iInstoreApi.addYysq(yysqVO);
                if (!yysqBack.isSuccess()) {
                    throw new BusinessException("\u65b0\u589e\u9879\u76ee\u7528\u5370\u7533\u8bf7\u8868\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1axxxx" + yysqBack);
                }
                this.logger.info("\u53d1\u9001\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1\u6570\u636e\uff1a{\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03}");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper;
        this.logger.info("\u6295\u6807\u6570\u636e\u64a4\u56de\u56de\u8c03\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001,billId:" + billId);
        BidFileReviewEntity bidFileReviewEntity = (BidFileReviewEntity)((Object)this.bidFileReviewService.selectById(billId));
        if (null != bidFileReviewEntity) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)bidFileReviewEntity.getEnrollId());
            updateWrapper.set(EnrollEntity::getBidStage, (Object)BidStageEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
            if (!"\u4e0d\u6295\u6807".equals(bidFileReviewEntity.getReviewResultName())) {
                updateWrapper.set(EnrollEntity::getIsBidChecked, (Object)BidCommonConsts.NO);
            }
            this.enrollService.update((Wrapper)updateWrapper);
        }
        if (billId != null) {
            this.recordService.saveRecord(BidStageEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN, billId, bidFileReviewEntity.getEngineeringCode());
            updateWrapper = new LambdaQueryWrapper();
            updateWrapper.eq(RecordEntity::getBillId, (Object)billId);
            this.recordService.remove((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

