package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.ejianc.business.bid.bean.BiddingFileReviewZiEntity;
import com.ejianc.business.bid.bean.ChoosePersonZiEntity;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.vo.PrequaliFicationVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.vo.BiddingFileReviewVO;

/**
 * 招标文件评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("biddingFileReview")
public class BiddingFileReviewController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRecordService recordService;

    private static final String BILL_CODE = "BID_BIDDINGFILEREVIEW";

    @Autowired
    private IBiddingFileReviewService service;

    @Autowired
    private IEmployeeApi employeeApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BiddingFileReviewVO> saveOrUpdate(@RequestBody BiddingFileReviewVO saveorUpdateVO) {
        BiddingFileReviewEntity entity = BeanMapper.map(saveorUpdateVO, BiddingFileReviewEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //通过建造师编号查询员工信息
        CommonResponse<EmployeeVO> byEmpmloyeeCode = employeeApi.getByEmpmloyeeCode(entity.getBuiltConstructorCode());

        if (!byEmpmloyeeCode.isSuccess()){
            throw new BusinessException("通过EmpmloyeeCode获取员工信息数据失败！ 员工编码为： " +entity.getBuiltConstructorCode());
        }
        EmployeeVO employeeVO = byEmpmloyeeCode.getData();
        logger.info("招标文件评审建造师问题排查========employeeVO",employeeVO+"entity",entity+"byEmpmloyeeCode",byEmpmloyeeCode);
        entity.setPid(employeeVO.getId());

        List<BiddingFileReviewZiEntity> biddingFileReviewZiEntities = entity.getBiddingFileReviewZiList();
        for (BiddingFileReviewZiEntity ziEntity:biddingFileReviewZiEntities){
            //通过建造师编号查询员工信息
            CommonResponse<EmployeeVO> byEmpmloyeeCode1 = employeeApi.getByEmpmloyeeCode(ziEntity.getOperatorName());

            if (!byEmpmloyeeCode.isSuccess()){
                throw new BusinessException("通过EmpmloyeeCode获取员工信息数据失败！ 员工编码为： " +ziEntity.getOperatorName() );
            }
            EmployeeVO employeeVO1 = byEmpmloyeeCode1.getData();
            ziEntity.setOperatorId(employeeVO1.getId());
        }

        if (entity.getId() == null || entity.getId() == 0){
            service.saveZjll(entity);//插入一条在建履历信息
        }else {
            service.updateZjll(entity);//修该在建履历信息
        }
        service.saveOrUpdate(entity, false);

        BiddingFileReviewVO vo = BeanMapper.map(entity, BiddingFileReviewVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BiddingFileReviewVO> queryDetail(Long id) {
        BiddingFileReviewEntity entity = service.selectById(id);

        BiddingFileReviewVO vo = BeanMapper.map(entity, BiddingFileReviewVO.class);
        vo.setRecords(recordService.getRecord(vo.getEngineeringCode()));


        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryByEnrollId 根据报名ID查询招标文件评审详情
     * @param enrollId
     * xuannl 20211118
     */
    @RequestMapping(value = "/queryByEnrollId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BiddingFileReviewVO> queryByEnrollId(Long enrollId) {
        BiddingFileReviewEntity entity = service.selectByEnrollId(enrollId);
        BiddingFileReviewEntity biddingFileReviewEntity = service.selectById(entity.getId());
        if(null == biddingFileReviewEntity){
            return CommonResponse.error("未查询到数据");
        }
        BiddingFileReviewVO vo = BeanMapper.map(biddingFileReviewEntity, BiddingFileReviewVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BiddingFileReviewVO> vos) {

        for (BiddingFileReviewVO vo : vos){
            Long id = vo.getId();
            BiddingFileReviewEntity biddingFileReviewEntity = service.selectById(id);
            service.deleteZjll(biddingFileReviewEntity);
        }
        service.removeByIds(vos.stream().map(BiddingFileReviewVO::getId).collect(Collectors.toList()),true);


        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BiddingFileReviewVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        //项目负责人
        fuzzyFields.add("responsiblePersonName");
        //建设单位
        fuzzyFields.add("constructionUnitName");
        //跟踪单位
        fuzzyFields.add("followCompanyName");
        //地区
        fuzzyFields.add("area");
        //建造师
        fuzzyFields.add("builtConstructor");
        //工程类型
        fuzzyFields.add("engineeringTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BiddingFileReviewEntity> page = service.queryPage(param,false);
        IPage<BiddingFileReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BiddingFileReviewVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<BiddingFileReviewEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<BiddingFileReviewVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, BiddingFileReviewVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("BiddingFileReview-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBiddingFileReviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BiddingFileReviewVO>> refBiddingFileReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BiddingFileReviewEntity> page = service.queryPage(param,false);
        IPage<BiddingFileReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BiddingFileReviewVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * @Description queryPersonDetail 查询选择人员详情
     * @param id
     */
    @RequestMapping(value = "/queryPersonDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BiddingFileReviewVO> queryPersonDetail(Long id) {
        CommonResponse<BiddingFileReviewVO> biddingFileReviewVO = queryByEnrollId(id);
        if (biddingFileReviewVO != null && biddingFileReviewVO.getCode() == 0){
            BiddingFileReviewEntity entity = service.selectById(biddingFileReviewVO.getData().getId());

            BiddingFileReviewVO vo = BeanMapper.map(entity, BiddingFileReviewVO.class);
            vo.setRecords(recordService.getRecord(vo.getEngineeringCode()));

            return CommonResponse.success("查询详情数据成功！",vo);
        }

        return CommonResponse.success("查询详情数据失败！");
    }
}
