package com.ejianc.business.bid.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/bid/")
public class BidManageApi {
    @Autowired
    private ISummaryService service;

    @RequestMapping(value = "/changeUseFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeUseFlag(@RequestParam(value = "id", required = true) Long id, @RequestParam(value = "useFlag",required = true) Integer useFlag) {
        LambdaUpdateWrapper<SummaryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SummaryEntity::getId,id);
        updateWrapper.set(SummaryEntity::getUseFlag,useFlag);
        boolean update = service.update(updateWrapper);
        if (update){
            return CommonResponse.success("修改项目立项使用状态成功。");
        }
        return CommonResponse.error("修改项目立项使用状态失败。");
    }
}
