/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.consts.SpecialityIdEnum;
import com.ejianc.business.bid.mapper.UndertakeMapper;
import com.ejianc.business.bid.service.IUndertakeService;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bid/"})
public class UndertakeApi {
    @Autowired
    private IUndertakeService service;
    @Autowired
    private UndertakeMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/getContractValueByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value="orgId", required=true) Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> departmentIds.add(org.getId()));
        param.getParams().put("makeOrgId", new Parameter("in", departmentIds));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("ywDate", new Parameter("between", (Object)(LocalDate.now().getYear() + "-1-1," + LocalDate.now().getYear() + "-12-31")));
        BigDecimal bigDecimal = new BigDecimal(0.0);
        BigDecimal bigDecimal1 = new BigDecimal(10000);
        List undertakeEntities = this.service.queryList(param);
        for (UndertakeEntity entity : undertakeEntities) {
            bigDecimal = bigDecimal.add(entity.getProjectCost());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u603b\u91d1\u989d\u6210\u529f\uff01", (Object)bigDecimal.multiply(bigDecimal1));
    }

    @RequestMapping(value={"/getUndertakeInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UndertakeApiVO>> getUndertakeInfo(@RequestParam(value="orgId", required=true) Long orgId, @RequestParam(value="time", required=true) Integer time) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (3 == org.getOrgType() || 2 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        param.getParams().put("makeOrgId", new Parameter("in", departmentIds));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (time != null) {
            if (time.equals(1)) {
                param.getParams().put("ywDate", new Parameter("between", (Object)(UndertakeApi.getMonthStartTime(dateTimeFormatter) + "," + UndertakeApi.getMonthEndTime(dateTimeFormatter))));
            } else if (time.equals(2)) {
                param.getParams().put("ywDate", new Parameter("between", (Object)(UndertakeApi.getFromThisQuarterStartTime(nowDate, dateTimeFormatter) + "," + UndertakeApi.getFromThisQuarterEndTime(nowDate, dateTimeFormatter))));
            } else {
                param.getParams().put("ywDate", new Parameter("between", (Object)(UndertakeApi.getFromThisYearStartTime(nowDate, dateTimeFormatter) + "," + UndertakeApi.getFromThisYearEndTime(nowDate, dateTimeFormatter))));
            }
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"speciality_id"});
        List<UndertakeApiVO> undertakeVOS = this.service.queryUndertakeInfoList(wrapper);
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
        QueryWrapper wrapper1 = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper1.groupBy(new Object[]{"speciality_id"});
        List<UndertakeApiVO> undertakeVOS1 = this.service.queryUndertakeInfoList(wrapper1);
        ArrayList<UndertakeApiVO> undertakeApiVOS = new ArrayList<UndertakeApiVO>();
        UndertakeApiVO vo1 = new UndertakeApiVO(SpecialityIdEnum.CODE_1.getCode(), SpecialityIdEnum.CODE_1.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo2 = new UndertakeApiVO(SpecialityIdEnum.CODE_2.getCode(), SpecialityIdEnum.CODE_2.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo3 = new UndertakeApiVO(SpecialityIdEnum.CODE_3.getCode(), SpecialityIdEnum.CODE_3.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo4 = new UndertakeApiVO(SpecialityIdEnum.CODE_4.getCode(), SpecialityIdEnum.CODE_4.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo5 = new UndertakeApiVO(SpecialityIdEnum.CODE_5.getCode(), SpecialityIdEnum.CODE_5.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo6 = new UndertakeApiVO(SpecialityIdEnum.CODE_6.getCode(), SpecialityIdEnum.CODE_6.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo7 = new UndertakeApiVO(SpecialityIdEnum.CODE_7.getCode(), SpecialityIdEnum.CODE_7.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo8 = new UndertakeApiVO(SpecialityIdEnum.CODE_8.getCode(), SpecialityIdEnum.CODE_8.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo9 = new UndertakeApiVO(SpecialityIdEnum.CODE_9.getCode(), SpecialityIdEnum.CODE_9.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        for (UndertakeApiVO vo : undertakeVOS) {
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())) {
                vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())) {
                vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())) {
                vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())) {
                vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())) {
                vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())) {
                vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())) {
                vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())) {
                vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));
                continue;
            }
            if (!vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())) continue;
            vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));
        }
        for (UndertakeApiVO vo : undertakeVOS1) {
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())) {
                vo3.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())) {
                vo4.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())) {
                vo5.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())) {
                vo6.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())) {
                vo7.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())) {
                vo8.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())) {
                vo9.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())) {
                vo1.setSum(Integer.valueOf(vo1.getSum() + vo.getSum()));
                continue;
            }
            if (!vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())) continue;
            vo2.setSum(Integer.valueOf(vo2.getSum() + vo.getSum()));
        }
        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        undertakeApiVOS.add(vo4);
        undertakeApiVOS.add(vo5);
        undertakeApiVOS.add(vo6);
        undertakeApiVOS.add(vo7);
        undertakeApiVOS.add(vo8);
        undertakeApiVOS.add(vo9);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", undertakeApiVOS);
    }

    @RequestMapping(value={"/getDeptOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DeptOrderApiVO>> getDeptOrder(@RequestParam(value="type", required=true) Integer type, @RequestParam(value="time", required=true) Integer time) {
        if (time == null || type == null) {
            return CommonResponse.error((String)"\u8f93\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (time != null) {
            String ywDate = UndertakeApi.getFromThisYearStartTime(nowDate, dateTimeFormatter) + "," + UndertakeApi.getFromThisYearEndTime(nowDate, dateTimeFormatter);
            if (time.equals(1)) {
                ywDate = UndertakeApi.getMonthStartTime(dateTimeFormatter) + "," + UndertakeApi.getMonthEndTime(dateTimeFormatter);
            } else if (time.equals(2)) {
                ywDate = UndertakeApi.getFromThisQuarterStartTime(nowDate, dateTimeFormatter) + "," + UndertakeApi.getFromThisQuarterEndTime(nowDate, dateTimeFormatter);
            }
            if (type.equals(2)) {
                param.getParams().put("statDate", new Parameter("between", (Object)ywDate));
            } else {
                param.getParams().put("ywDate", new Parameter("between", (Object)ywDate));
            }
        }
        List<Object> deptOrderApiVOS = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        if (type.equals(2)) {
            wrapper.groupBy(new Object[]{"build_unit_id"});
            deptOrderApiVOS = this.service.queryOutputDeptOrderList(wrapper);
        } else {
            wrapper.groupBy(new Object[]{"make_org_id"});
            deptOrderApiVOS = this.service.queryDeptOrderList(wrapper);
        }
        int i = 0;
        int index = -1;
        for (DeptOrderApiVO deptOrderApiVO : deptOrderApiVOS) {
            OrgVO data;
            if ("G9\u9879\u76ee".equals(deptOrderApiVO.getDeptName())) {
                index = i;
            }
            deptOrderApiVO.setValue(deptOrderApiVO.getValue());
            CommonResponse oneById = this.iOrgApi.getOneById(deptOrderApiVO.getDeptId());
            if (oneById.getCode() == 0 && (data = (OrgVO)oneById.getData()) != null) {
                deptOrderApiVO.setDeptType(data.getOrgType());
            }
            ++i;
        }
        if (index > -1) {
            deptOrderApiVOS.remove(index);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", deptOrderApiVOS);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    public static void main(String[] args) {
        LocalDate nowDate = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        System.out.println(UndertakeApi.getMonthStartTime(dateTimeFormatter));
        System.out.println(UndertakeApi.getMonthEndTime(dateTimeFormatter));
        System.out.println(UndertakeApi.getFromThisQuarterStartTime(nowDate, dateTimeFormatter));
        String fromThisQuarterEndTime = UndertakeApi.getFromThisQuarterEndTime(nowDate, dateTimeFormatter);
        System.out.println(fromThisQuarterEndTime);
        System.out.println(UndertakeApi.getFromThisYearStartTime(nowDate, dateTimeFormatter));
        System.out.println(UndertakeApi.getFromThisYearEndTime(nowDate, dateTimeFormatter));
    }

    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    public static String getFromThisYearStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    public static String getFromThisYearEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }
}

