package com.ejianc.business.bid.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.consts.SpecialityIdEnum;
import com.ejianc.business.bid.mapper.UndertakeMapper;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.service.IUndertakeService;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.bid.vo.UndertakeVO;
import com.ejianc.business.constructor.vo.QyyjmxdjVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.swagger.models.auth.In;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;

@RestController
@RequestMapping("/api/bid/")
public class UndertakeApi {
    @Autowired
    private IUndertakeService service;
    @Autowired
    private UndertakeMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 获取合同总金额（组织本下）
     * year == 0时，取所有年份的
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getContractValueByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value = "orgId", required = true) Long orgId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
                //项目部
                departmentIds.add(org.getId());
        });

        /** makeOrgId */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, departmentIds));

        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        /** ywDate    参数year为0时，取所有的*/

            param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                    LocalDate.now().getYear() + "-1-1," + LocalDate.now().getYear()+ "-12-31"));


        BigDecimal bigDecimal = new BigDecimal(0.0);
        BigDecimal bigDecimal1 = new BigDecimal(10000);

        List<UndertakeEntity> undertakeEntities = service.queryList(param);
        logger.info("-----------获取承揽任务数据共{}条。",undertakeEntities.size());
        logger.info("-----------获取承揽任务数据:{}。",undertakeEntities.size());
        for (UndertakeEntity entity:undertakeEntities){
            bigDecimal = bigDecimal.add(entity.getProjectCost());
        }
        return CommonResponse.success("查询合同总金额成功！",bigDecimal.multiply(bigDecimal1));
    }

    /**
     * 获取饼状图信息（组织本下）
     * @param orgId
     * @param time 1：月度  2：季度  3：年度
     *             type 0数量纬度（不显示补充协议） 1金额维度（显示补充协议）
     * @return
     */
    @RequestMapping(value = "/getUndertakeInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UndertakeApiVO>> getUndertakeInfo(@RequestParam(value = "orgId", required = true) Long orgId,
                                                                    @RequestParam(value = "time", required = true) Integer time
            //, @RequestParam(value = "type", required = true) Integer type
    ) {


        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            if(3 == org.getOrgType()  ||  2 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
        });

        /** makeOrgId */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, departmentIds));

        /** ywDate */
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();

        if (time != null) {
            if (time.equals(1)){//月度
                param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                        getMonthStartTime(dateTimeFormatter) +","+ getMonthEndTime(dateTimeFormatter)));
            }else if (time.equals(2)){//季度
                param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                        getFromThisQuarterStartTime(nowDate,dateTimeFormatter) +","+ getFromThisQuarterEndTime(nowDate,dateTimeFormatter)));
            }else {
                param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                        getFromThisYearStartTime(nowDate,dateTimeFormatter) +","+ getFromThisYearEndTime(nowDate,dateTimeFormatter)));
            }
        }

        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        /**
         * 当取值为数量时，只显示主合同
         */
//        if(type != null && type == 0){
//            param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 0));
//        }

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        wrapper.groupBy("speciality_id");

        List<UndertakeApiVO> undertakeVOS = service.queryUndertakeInfoList(wrapper);
        param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 0));
        QueryWrapper wrapper1 = BaseServiceImpl.changeToQueryWrapper(param);

        wrapper1.groupBy("speciality_id");
        List<UndertakeApiVO> undertakeVOS1 = service.queryUndertakeInfoList(wrapper1);

        ArrayList<UndertakeApiVO> undertakeApiVOS = new ArrayList<>();

        UndertakeApiVO vo1 = new UndertakeApiVO(SpecialityIdEnum.CODE_1.getCode(),SpecialityIdEnum.CODE_1.getName(),new BigDecimal(0.00),0);//房屋建筑

        UndertakeApiVO vo2 = new UndertakeApiVO(SpecialityIdEnum.CODE_2.getCode(),SpecialityIdEnum.CODE_2.getName(),new BigDecimal(0.00),0);//市政工程

        UndertakeApiVO vo3 = new UndertakeApiVO(SpecialityIdEnum.CODE_3.getCode(),SpecialityIdEnum.CODE_3.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo4 = new UndertakeApiVO(SpecialityIdEnum.CODE_4.getCode(),SpecialityIdEnum.CODE_4.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo5 = new UndertakeApiVO(SpecialityIdEnum.CODE_5.getCode(),SpecialityIdEnum.CODE_5.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo6 = new UndertakeApiVO(SpecialityIdEnum.CODE_6.getCode(),SpecialityIdEnum.CODE_6.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo7 = new UndertakeApiVO(SpecialityIdEnum.CODE_7.getCode(),SpecialityIdEnum.CODE_7.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo8 = new UndertakeApiVO(SpecialityIdEnum.CODE_8.getCode(),SpecialityIdEnum.CODE_8.getName(),new BigDecimal(0.00),0);//

        UndertakeApiVO vo9 = new UndertakeApiVO(SpecialityIdEnum.CODE_9.getCode(),SpecialityIdEnum.CODE_9.getName(),new BigDecimal(0.00),0);//


        for (UndertakeApiVO vo : undertakeVOS){
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())){
                //vo3.setSum(vo.getSum());
                vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())){
                //vo4.setSum(vo.getSum());
                vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())){
               // vo5.setSum(vo.getSum());
                vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())){
               // vo6.setSum(vo.getSum());
                vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())){
                //vo7.setSum(vo.getSum());
                vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())){
                //vo8.setSum(vo.getSum());
                vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())){
                //vo9.setSum(vo.getSum());
                vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())){
                //vo1.setSum(vo1.getSum()+vo.getSum());//总数
                vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())){
                //vo2.setSum(vo2.getSum()+vo.getSum());//总数
                vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }
        }

        for (UndertakeApiVO vo : undertakeVOS1){
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())){
                vo3.setSum(vo.getSum());
                //vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())){
                vo4.setSum(vo.getSum());
                //vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())){
                vo5.setSum(vo.getSum());
                //vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())){
                vo6.setSum(vo.getSum());
                //vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())){
                vo7.setSum(vo.getSum());
                //vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())){
                vo8.setSum(vo.getSum());
                //vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())){
                vo9.setSum(vo.getSum());
                //vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())){
                vo1.setSum(vo1.getSum()+vo.getSum());//总数
                //vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())){
                vo2.setSum(vo2.getSum()+vo.getSum());//总数
                //vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }
        }

        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        undertakeApiVOS.add(vo4);
        undertakeApiVOS.add(vo5);
        undertakeApiVOS.add(vo6);
        undertakeApiVOS.add(vo7);
        undertakeApiVOS.add(vo8);
        undertakeApiVOS.add(vo9);

        return CommonResponse.success("查询成功！",undertakeApiVOS);
    }

    /**
     * 子分单位排名
     * @param type 1：承揽金额   2：产值统计
     * @param time 1：月度  2：季度  3：年度
     * @return
     */
    @RequestMapping(value = "/getDeptOrder", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DeptOrderApiVO>> getDeptOrder(@RequestParam(value = "type", required = true) Integer type,
                                                                 @RequestParam(value = "time", required = true) Integer time
    ) {

        if (time == null || type == null) {
            return CommonResponse.error("输入参数不允许为空！");
        }


        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));


        /** ywDate */
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();

        if (time != null) {
            String ywDate = getFromThisYearStartTime(nowDate,dateTimeFormatter) +","+ getFromThisYearEndTime(nowDate,dateTimeFormatter);
            if (time.equals(1)){//月度
                ywDate =  getMonthStartTime(dateTimeFormatter) +","+ getMonthEndTime(dateTimeFormatter);
            }else if (time.equals(2)){//季度
                ywDate = getFromThisQuarterStartTime(nowDate,dateTimeFormatter) +","+ getFromThisQuarterEndTime(nowDate,dateTimeFormatter);
            }
            if (type.equals(2)){
                param.getParams().put("statDate", new Parameter(QueryParam.BETWEEN, ywDate));
            }else {
                 param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN, ywDate));
            }
        }

        List<DeptOrderApiVO> deptOrderApiVOS = new ArrayList<>();

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        if (type.equals(2)){//产值
            wrapper.groupBy("build_unit_id");
            deptOrderApiVOS = service.queryOutputDeptOrderList(wrapper);
        }else {
            wrapper.groupBy("make_org_id");

            deptOrderApiVOS = service.queryDeptOrderList(wrapper);

        }


        //循环获取每个项目、或子分单位的组织类型
        int i = 0;
        int index = -1;
        for (DeptOrderApiVO vo : deptOrderApiVOS) {
            //if (i>=10)break;
            if ("G9项目".equals(vo.getDeptName())){
                index = i;
            }
//            vo.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            //更改为万元
            vo.setValue(vo.getValue());
            CommonResponse<OrgVO> oneById = iOrgApi.getOneById(vo.getDeptId());
            if (oneById.getCode() == 0) {
                OrgVO data = oneById.getData();
                if(data != null) {
                    vo.setDeptType(data.getOrgType());
                }
            }
            i++;
        }

        if (index > -1){
            deptOrderApiVOS.remove(index);
        }
        return CommonResponse.success("查询成功！",deptOrderApiVOS);
    }






    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    public static void main(String[] args) {
        LocalDate nowDate = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        System.out.println(getMonthStartTime(dateTimeFormatter));
        System.out.println(getMonthEndTime(dateTimeFormatter));
        System.out.println(getFromThisQuarterStartTime(nowDate,dateTimeFormatter));
        String fromThisQuarterEndTime = getFromThisQuarterEndTime(nowDate,dateTimeFormatter);
        System.out.println(fromThisQuarterEndTime);
        System.out.println(getFromThisYearStartTime(nowDate,dateTimeFormatter));
        System.out.println(getFromThisYearEndTime(nowDate,dateTimeFormatter));
    }

    /**
     * 本月开始时间
     * @param dateTimeFormatter
     * @return
     */
    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    /**
     * 本月结束时间
     *
     * @return
     */
    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }


    //获取本季度开始时间
    public static String getFromThisQuarterStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);

    }
    //获取本季度结束时间
    public static String getFromThisQuarterEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    /**
     * 今年起开始时间
     *
     * @return
     */
    public static String getFromThisYearStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    /**
     * 今年起结束时间
     *
     * @return
     */
    public static String getFromThisYearEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }
}
