package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.ChoosePersonEntity;
import com.ejianc.business.bid.bean.ChoosePersonZiEntity;
import com.ejianc.business.bid.service.IChoosePersonService;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Service("choosePerson") 
public class ChoosePersonBpmServiceImpl implements ICommonBusinessService {

	 @Autowired
     private IZjllApi zjllApi;
	 @Autowired
	 private IChoosePersonService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		ChoosePersonEntity entity = service.selectById(billId);
		if(null!=entity){
            List<ChoosePersonZiEntity> list = entity.getChoosePersonZiList();
            List<ZjllVO> zill = new ArrayList<>();
		    if (entity.getXmlxId() == null) {//判断项目是否立项


					//项目经理更新公示状态
					ZjllVO zjllVO1 = new ZjllVO();
					zjllVO1.setProjectId(entity.getXmId());
					zjllVO1.setXmId(entity.getXmjlId());
					//zjllVO.setYxzt(0);
					zjllVO1.setSfgs(entity.getSfgs());//是否公示
					zjllApi.updateWrapper(zjllVO1);

                for (ChoosePersonZiEntity ziEntity : list) {
                    //除项目经理外中标登记
                    if (!("项目经理".equals(ziEntity.getGw()))) {
                        ZjllVO zjllVO = new ZjllVO();
                        zjllVO.setYxzt(0);
                        zjllVO.setZt(1);
                        zjllVO.setProjectId(entity.getXmId());
                        zjllVO.setProjectName(entity.getXm());
                        zjllVO.setXmId(ziEntity.getOperatorId());//人员id在此字段缓存
                        zjllVO.setXmName(ziEntity.getRyName());
                        zjllVO.setGwId(ziEntity.getGwId());
                        zjllVO.setGw(ziEntity.getGw());
                        zjllVO.setOrgId(entity.getOrgId());
                        zjllVO.setOrgName(entity.getOrgName());
                        zjllVO.setKssj(new Date());
                        zjllVO.setTags("在建履历");
						zjllVO.setSfgs(ziEntity.getSfgs());//是否公示
                        zill.add(zjllVO);
                    }
                }
            }else {//已立项


					//项目经理立项状态更新
					ZjllVO zjllVO1 = new ZjllVO();
					zjllVO1.setProjectId(entity.getXmId());
					zjllVO1.setXmId(entity.getXmjlId());
					//zjllVO.setYxzt(0);
					zjllVO1.setProPid(entity.getXmlxId());
					zjllVO1.setProPname(entity.getXmlxName());
					zjllVO1.setSfgs(entity.getSfgs());//是否公示
					zjllApi.updateWrapper(zjllVO1);

                for (ChoosePersonZiEntity ziEntity : list) {
                    //除项目经理外，完成中标登记与立项
                    if (!("项目经理".equals(ziEntity.getGw()))) {
                        ZjllVO zjllVO = new ZjllVO();
                        zjllVO.setYxzt(0);
                        zjllVO.setZt(1);
                        zjllVO.setProjectId(entity.getXmId());
                        zjllVO.setProjectName(entity.getXm());
                        zjllVO.setXmId(ziEntity.getOperatorId());
                        zjllVO.setXmName(ziEntity.getRyName());
                        zjllVO.setGwId(ziEntity.getGwId());
                        zjllVO.setGw(ziEntity.getGw());
                        zjllVO.setOrgId(entity.getOrgId());
                        zjllVO.setOrgName(entity.getOrgName());
                        zjllVO.setKssj(new Date());
                        zjllVO.setTags("在建履历");
                        zjllVO.setProPid(entity.getXmlxId());
                        zjllVO.setProPname(entity.getXmlxName());
						zjllVO.setSfgs(ziEntity.getSfgs());//是否公示
                        zill.add(zjllVO);
                    }
                }
            }
			zjllApi.saveorupdateBatch(zill);
			logger.info("选择中标人员保存项目经理数据到在建人员履历！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
