package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.PrequaliFicationEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.business.sealm.vo.YzdjVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("prequaliFication")
public class PrequaliFicationBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IPrequaliFicationService prequaliFicationService;
	@Autowired
	private IRecordService recordService;
	@Autowired
	private IEnrollService enrollService;
	@Autowired
	private IBiddingFileReviewService biddingFileReviewService;
	@Autowired
	private IInstoreApi iInstoreApi;
	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("预审数据提交前回调，开始回写状态,billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (null != prequaliFicationEntity) {
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZI_GE_YU_SHEN.getCode());
			if("通过".equals(prequaliFicationEntity.getEstimatedExamineResultName())){
				updateWrapper.set(EnrollEntity::getIsPreChecked,BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		logger.info("预审数据提交回调，开始回写状态,billId:"+billId);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("资格预审，有审批流的撤回前回调，billId"+billId);

		//是否被投标信息跟踪中止单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		//单据未被下游单据引用
		if (res.isSuccess()) {
			PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_BAO_MING.getCode());
			if(BidCommonConsts.YES.equals(prequaliFicationEntity.getEstimatedExamineResult())){
				updateWrapper.set(EnrollEntity::getIsPreChecked, BidCommonConsts.NO);
			}
			enrollService.update(updateWrapper);

			recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaQueryWrapper<RecordEntity> recordUpdateWrapper = new LambdaQueryWrapper<>();
			recordUpdateWrapper.eq(RecordEntity::getBillId,billId);
			recordService.remove(recordUpdateWrapper);
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("资格预审，有审批流的撤回后回调");
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审完成，开始回写状态，billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (prequaliFicationEntity != null) {
			recordService.saveRecord(BidStageEnum.ZI_GE_YU_SHEN, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZI_GE_YU_SHEN.getCode());
			// 如果结论为通过，才回更是否通过字段
			if(BidCommonConsts.YES.equals(prequaliFicationEntity.getEstimatedExamineResult())){
				updateWrapper.set(EnrollEntity::getIsPreChecked,BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);
		}

		//审批通过对项目用印申请新增一条数据
		/*YysqVO yysqVO = new YysqVO();
		yysqVO.setBidId(billId);  //资格预审id
		yysqVO.setOrgId(prequaliFicationEntity.getOrgId());  //组织id
		yysqVO.setOrgName(prequaliFicationEntity.getOrgName());  //组织名称
		yysqVO.setBidCode(prequaliFicationEntity.getBillCode());  //资格预审编码

		yysqVO.setYysxId(554708794647519300L);
		yysqVO.setYysxName("投标管理-资格预审");
		//yysqVO.setYysxCode("/ejc-bid-frontend/#/prequaliFication/card");

		yysqVO.setYyReason("投标管理-资格预审-" + prequaliFicationEntity.getBillCode());  //用印事由
		yysqVO.setDjlj("/ejc-bid-frontend/#/prequaliFication/card");//单据链接
		//审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
		yysqVO.setSqdwId(prequaliFicationEntity.getOrgId());  //申请单位id
		yysqVO.setSqdwName(prequaliFicationEntity.getOrgName());  //申请单位name
		yysqVO.setSqrId(sessionManager.getUserContext().getUserId());  //负责人id
		yysqVO.setSqrName(sessionManager.getUserContext().getUserName());  //负责人name
		yysqVO.setCreateUserCode(prequaliFicationEntity.getCreateUserCode());  //创建人
		yysqVO.setCreateUserName(sessionManager.getUserContext().getUserName());  //负责人名称
		//因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
		CommonResponse<YzdjVO> yzdjVOCommonResponse = iInstoreApi.selectYzxxByCode("YZ-001");

		YzdjVO data = yzdjVOCommonResponse.getData();
		yysqVO.setYzbhId(data.getId());
		yysqVO.setYzlbId(data.getYzlbId());
		yysqVO.setYzlbName(data.getYzlbName());
		yysqVO.setYzjbId(data.getYzjbId());
		yysqVO.setYzjbName(data.getYzjbName());
		yysqVO.setYylxId(data.getYylxId());
		yysqVO.setYylxName(data.getYylxName());
		yysqVO.setBillState(3);  //推送数据默认为审批通过的
		yysqVO.setMessageFrom(1);// 数据来源：0自建，1原始审批单据
		yysqVO.setZkbmId(1502571153481273346L);//主控部门ID
		yysqVO.setZkbmName("经营部");//主控部门name
		yysqVO.setXgcs(0);//修改次数

		CommonResponse<String> yysqBack = iInstoreApi.addYysq(yysqVO);
		if(!yysqBack.isSuccess()){
			throw new BusinessException("新增项目用印申请表数据失败，原因：xxxx" + yysqBack);
		}
		logger.info("发送资格预审数据：{终审审核完回调}");*/
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("预审数据，弃审前回调，开始回写状态,billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (null != prequaliFicationEntity) {
			BiddingFileReviewEntity biddingFileReviewEntity = biddingFileReviewService.selectByEnrollId(prequaliFicationEntity.getEnrollId());
			if(biddingFileReviewEntity != null){
				return CommonResponse.error("该单据已被下游单据（招标文件评审）引用");
			}
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_BAO_MING.getCode());
			if(BidCommonConsts.YES.equals(prequaliFicationEntity.getEstimatedExamineResult())){
				updateWrapper.set(EnrollEntity::getIsPreChecked, BidCommonConsts.NO);
			}
			enrollService.update(updateWrapper);
		}
		if(billId != null){
			recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
			updateWrapper.eq(RecordEntity::getBillId,billId);
			recordService.remove(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("预审数据，弃审回调，开始回写状态,billId:"+billId);
		return CommonResponse.success();
	}

}
