package com.ejianc.business.lock.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * CA锁登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_lock_register")
public class LockEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="operator_code")
    private String operatorCode; // 经办人联系方式
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="lock_name")
    private String lockName; // 锁名称
    @TableField(value="lock_code")
    private String lockCode; // 锁序列号
    @TableField(value="platform_id")
    private Long platformId; // 交易平台id
    @TableField(value="platform_name")
    private String platformName; // 交易平台名称
    @TableField(value="deadline")
    private Date deadline; // 有效截至时间
    @TableField(value="manage_org_id")
    private Long manageOrgId; // 管理单位id
    @TableField(value="manage_org_name")
    private String manageOrgName; // 管理单位名称
    @TableField(value="inner_code")
    private String innerCode; // 内部编号
    @TableField(value="address")
    private String address; // 地域
    @TableField(value="lock_state")
    private String lockState; // 锁状态
    @TableField(value="register_state")
    private String registerState; // 登记状态
    @TableField(value="lock_property")
    private String lockProperty; // 锁性质
    @TableField(value="lock_model")
    private String lockModel; // 锁型号
    @TableField(value="lock_platform")
    private String lockPlatform; // 锁关联平台
    @TableField(value="lock_password")
    private String lockPassword; // 锁密码


    public String getLockPassword() {
        return lockPassword;
    }

    public void setLockPassword(String lockPassword) {
        this.lockPassword = lockPassword;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="platformLockService", pidName = "lockId")
    private List<PlatformLockEntity> platformLockList = new ArrayList<>(); // 交易平台-锁对照


    public List<PlatformLockEntity> getPlatformLockList() {
        return platformLockList;
    }

    public void setPlatformLockList(List<PlatformLockEntity> platformLockList) {
        this.platformLockList = platformLockList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getLockName() {
        return lockName;
    }

    public void setLockName(String lockName) {
        this.lockName = lockName;
    }
    public String getLockCode() {
        return lockCode;
    }

    public void setLockCode(String lockCode) {
        this.lockCode = lockCode;
    }
    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }
    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
    public Date getDeadline() {
        return deadline;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }
    public Long getManageOrgId() {
        return manageOrgId;
    }

    public void setManageOrgId(Long manageOrgId) {
        this.manageOrgId = manageOrgId;
    }
    public String getManageOrgName() {
        return manageOrgName;
    }

    public void setManageOrgName(String manageOrgName) {
        this.manageOrgName = manageOrgName;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getLockState() {
        return lockState;
    }

    public void setLockState(String lockState) {
        this.lockState = lockState;
    }
    public String getRegisterState() {
        return registerState;
    }

    public void setRegisterState(String registerState) {
        this.registerState = registerState;
    }
    public String getLockProperty() {
        return lockProperty;
    }

    public void setLockProperty(String lockProperty) {
        this.lockProperty = lockProperty;
    }
    public String getLockModel() {
        return lockModel;
    }

    public void setLockModel(String lockModel) {
        this.lockModel = lockModel;
    }
    public String getLockPlatform() {
        return lockPlatform;
    }

    public void setLockPlatform(String lockPlatform) {
        this.lockPlatform = lockPlatform;
    }
    
}
