/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.TrackProjectEntity;
import com.ejianc.business.bid.bean.TrackProjectZiEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.controller.TrackProjectController;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IInfoTrackStopService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.ITrackProjectService;
import com.ejianc.business.bid.service.ITrackProjectZiService;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.business.bid.vo.TrackProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"infoTrack"})
@Api(value="\u6295\u6807\u4fe1\u606f\u8ddf\u8e2a", tags={"\u6295\u6807\u4fe1\u606f\u8ddf\u8e2a"})
public class InfoTrackController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_01";
    @Autowired
    private IInfoTrackService service;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IInfoTrackStopService infoTrackStopService;
    @Autowired
    private ITrackProjectService trackProjectService;
    @Autowired
    private ITrackProjectZiService trackProjectZiService;
    @Autowired
    private TrackProjectController trackProjectController;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InfoTrackVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody InfoTrackVO saveorUpdateVO) {
        InfoTrackEntity entity = (InfoTrackEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InfoTrackEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setIsStop(BidCommonConsts.NO);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getTrackProjectId() != null) {
            TrackProjectEntity trackProjectEntity = (TrackProjectEntity)((Object)this.trackProjectService.getById(entity.getTrackProjectId()));
            trackProjectEntity.setTrackNum(trackProjectEntity.getTrackNum() + 1);
            this.trackProjectService.saveOrUpdate((Object)trackProjectEntity);
            TrackProjectZiEntity trackProjectZiEntity = new TrackProjectZiEntity();
            trackProjectZiEntity.setZhuId(entity.getTrackProjectId());
            trackProjectZiEntity.setDepartmentId(entity.getFollowUnit());
            trackProjectZiEntity.setDepartmentName(entity.getFollowUnitName());
            this.trackProjectZiService.save((Object)trackProjectZiEntity);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(InfoTrackEntity::getTrackNum, (Object)entity.getTrackNum())).eq(InfoTrackEntity::getTrackProjectId, (Object)entity.getTrackProjectId());
            this.service.update((Wrapper)updateWrapper);
        }
        this.service.saveOrUpdate((Object)entity, false);
        InfoTrackVO vo = (InfoTrackVO)BeanMapper.map((Object)((Object)entity), InfoTrackVO.class);
        this.infoTrackStopService.insertInfoTrackStop(vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InfoTrackVO> queryDetail(@RequestParam Long id) {
        InfoTrackEntity entity = (InfoTrackEntity)((Object)this.service.selectById(id));
        InfoTrackVO vo = (InfoTrackVO)BeanMapper.map((Object)((Object)entity), InfoTrackVO.class);
        vo.setRecords(this.recordService.getRecord(vo.getBillCode()));
        if (vo != null) {
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode((Integer)vo.getBiddingForm()));
            vo.setFollowStateName(BidStateEnum.getNameByCode((Integer)vo.getFollowState()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InfoTrackVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("followUnitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectBidManageName");
        fuzzyFields.add("biddingAgency");
        fuzzyFields.add("constructionUnitName");
        fuzzyFields.add("unitDirectorName");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("address");
        fuzzyFields.add("trackProjectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InfoTrackVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("followUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, InfoTrackVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setFollowStateName(BidStateEnum.getNameByCode((Integer)vo.getFollowState()));
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("InfoTrack-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refInfoTrackData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> refInfoTrackData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("unitDirectorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("isStop", new Parameter("eq", (Object)BidCommonConsts.NO));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("followState", new Parameter("eq", (Object)BidCommonConsts.YES));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InfoTrackVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u63a8\u9001\u4e00\u6761\u8ddf\u8e2a\u9879\u76ee")
    @RequestMapping(value={"/pushTrackProject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InfoTrackVO> pushTrackProject(@ApiParam(name="infoTrackVO", required=true) @RequestBody InfoTrackVO infoTrackVO) {
        InfoTrackEntity entity = (InfoTrackEntity)((Object)BeanMapper.map((Object)infoTrackVO, InfoTrackEntity.class));
        TrackProjectVO trackProjectVO = new TrackProjectVO();
        trackProjectVO.setProjectName(entity.getEngineeringName());
        trackProjectVO.setOrgId(InvocationInfoProxy.getOrgId());
        trackProjectVO.setTrackNum(Integer.valueOf(0));
        trackProjectVO.setUseState(Integer.valueOf(1));
        this.trackProjectController.saveOrUpdate(trackProjectVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)infoTrackVO);
    }
}

