/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.mapper.UndertakeMapper;
import com.ejianc.business.bid.service.IUndertakeService;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.bid.vo.UndertakeTargetVO;
import com.ejianc.business.bid.vo.UndertakeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="undertakeService")
public class UndertakeServiceImpl
extends BaseServiceImpl<UndertakeMapper, UndertakeEntity>
implements IUndertakeService {
    @Autowired
    private UndertakeMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<UndertakeApiVO> queryUndertakeInfoList(QueryWrapper wrapper) {
        return this.mapper.queryUndertakeInfoList(wrapper);
    }

    @Override
    public List<DeptOrderApiVO> queryDeptOrderList(QueryWrapper wrapper) {
        return this.mapper.queryDeptOrderList(wrapper);
    }

    @Override
    public List<DeptOrderApiVO> queryOutputDeptOrderList(QueryWrapper wrapper) {
        return this.mapper.queryOutputDeptOrderList(wrapper);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int total = 0;
        int pages = 0;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("areaName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("makeOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
        List undertakeEntities = this.queryList(param);
        List list = undertakeEntities.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List undertakeVOS = BeanMapper.mapList((Iterable)undertakeEntities, UndertakeVO.class);
        List idList = undertakeVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam childrenParam = (QueryParam)Utils.deepCopy((Object)param);
        if (ListUtil.isNotEmpty(idList)) {
            childrenParam.getParams().put("mainId", new Parameter("in", idList));
        }
        childrenParam.getParams().put("supplementFlag", new Parameter("eq", (Object)1));
        List childrenList = this.queryList(childrenParam);
        List childrenVoList = BeanMapper.mapList((Iterable)childrenList, UndertakeVO.class);
        Map<Long, List<UndertakeVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(UndertakeVO::getMainId));
        if (param.getSearchText() != null && ListUtil.isNotEmpty((List)undertakeVOS)) {
            ArrayList<Long> childrenIdList = new ArrayList<Long>(childrenMap.keySet());
            param.getParams().put("mainId", new Parameter("in", (Object)childrenIdList));
            if (ListUtil.isEmpty((List)undertakeEntities)) {
                param.setSearchText(null);
            }
            List newEntityList = this.queryList(param);
            undertakeEntities.addAll(newEntityList);
            undertakeEntities = undertakeEntities.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UndertakeEntity>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
            undertakeEntities = undertakeEntities.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime).reversed()).collect(Collectors.toList());
            list = undertakeEntities.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            undertakeVOS = BeanMapper.mapList(list, UndertakeVO.class);
        }
        if (ListUtil.isNotEmpty((List)undertakeVOS)) {
            for (UndertakeVO vo : undertakeVOS) {
                if (!childrenMap.containsKey(vo.getId())) continue;
                vo.setChildren(childrenMap.get(vo.getId()));
            }
        }
        if ((total = undertakeEntities.size()) % pageSize > 0) {
            pages = total / pageSize + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }
        JSONObject page = new JSONObject();
        page.put("records", (Object)undertakeVOS);
        page.put("total", (Object)total);
        page.put("current", (Object)pageIndex);
        page.put("size", (Object)pageSize);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public List<String> queryUndertakeCostMonth(Integer year, List<Long> orgIds) {
        String year1 = year + "";
        return ((UndertakeMapper)this.baseMapper).queryUndertakeCostMonth(year1, orgIds);
    }

    @Override
    public UndertakeTargetVO queryUndertakeYearTarget(Integer year) {
        String year1 = year + "";
        return ((UndertakeMapper)this.baseMapper).queryUndertakeYearTarget(year1);
    }
}

