/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.consts.ProjectSurveyEnum;
import com.ejianc.business.bid.mapper.EnrollMapper;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.utils.AddressResolutionUtil;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectCountVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectDataVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectVo;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectSurveyTreeVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="enrollService")
public class EnrollServiceImpl
extends BaseServiceImpl<EnrollMapper, EnrollEntity>
implements IEnrollService {
    @Autowired
    private EnrollMapper enrollMapper;

    @Override
    public List<EnrollVO> queryBidOpeningSoon() {
        return this.enrollMapper.queryBidOpeningSoon();
    }

    @Override
    public List<EnrollEntity> selectEnrollListIsBidding() {
        return this.enrollMapper.selectEnrollListIsBidding();
    }

    @Override
    public List<EnrollEntity> selectEnrollListIsSummary() {
        return this.enrollMapper.selectEnrollListIsSummary();
    }

    @Override
    public CommonResponse<JSONObject> enrollArea(String range, String name, String dateIn, Long orgId) {
        Map<String, List<ProjectCountVO>> map;
        String projectStatus = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        ArrayList<ProjectCountVO> list = new ArrayList<ProjectCountVO>();
        List listTree = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)dateIn)) {
            queryWrapper.eq((Object)"DATE_FORMAT(bill_date,\"%Y\")", (Object)dateIn);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List enrollEntities = this.list((Wrapper)queryWrapper);
        ArrayList<ProjectSurveyVO> projectSurveyVOS = new ArrayList<ProjectSurveyVO>();
        if (ListUtil.isNotEmpty((List)enrollEntities)) {
            for (EnrollEntity enrollEntity : enrollEntities) {
                ProjectSurveyVO projectSurveyVO = new ProjectSurveyVO();
                projectSurveyVO.setId(enrollEntity.getId());
                projectSurveyVO.setProjectName(enrollEntity.getEngineeringName());
                projectSurveyVO.setOrgId(enrollEntity.getOrgId());
                projectSurveyVO.setArea(enrollEntity.getArea());
                projectSurveyVO.setProvince(enrollEntity.getProvince());
                projectSurveyVO.setCity(enrollEntity.getCity());
                projectSurveyVO.setCounty(enrollEntity.getRegion());
                projectSurveyVOS.add(projectSurveyVO);
            }
            List dataTree = BeanMapper.mapList(projectSurveyVOS, ProjectSurveyTreeVO.class);
            listTree = TreeNodeBUtil.buildTree((List)dataTree);
            List projectCountVOS = BeanMapper.mapList(listTree, ProjectCountVO.class);
            list.addAll(projectCountVOS);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pName = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMap != null) {
                    String province = areaMap.get("province") == null ? "\u5176\u4ed6" : areaMap.get("province");
                    String string = areaMap.get("city") == null ? "\u5176\u4ed6" : areaMap.get("city");
                    String string2 = areaMap.get("county") == null ? "\u5176\u4ed6" : areaMap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pName = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pName) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, list, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, ProjectDataVO> countyMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    BigDecimal contractTaxMny;
                    String string = projectCountVO.getCounty();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!countyMap.containsKey(string)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        countyMap.put(string, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)countyMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    List<ProjectCountVO> projectCountVOS = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        ProjectVo projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO.setProjectList(projectVos);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, ProjectDataVO> cityMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    BigDecimal contractTaxMny;
                    String string = projectCountVO.getCity();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!cityMap.containsKey(string)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        cityMap.put(string, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)cityMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    List<ProjectCountVO> projectCountVOS = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        ProjectVo projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO.setProjectList(projectVos);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, ProjectDataVO> provinceMap = new HashMap<String, ProjectDataVO>();
            for (ProjectCountVO projectCountVO : list) {
                BigDecimal contractTaxMny;
                String string = projectCountVO.getProvince();
                BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                if (!provinceMap.containsKey(string)) {
                    ProjectDataVO pvo = new ProjectDataVO();
                    pvo.setName(string);
                    pvo.setValue(Integer.valueOf(1));
                    pvo.setContractMoney(contractTaxMny);
                    provinceMap.put(string, pvo);
                    continue;
                }
                ProjectDataVO projectDataVO = (ProjectDataVO)provinceMap.get(string);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                provinceMap.put(string, projectDataVO);
            }
            map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (ProjectDataVO projectDataVO : dataVOS) {
                if (!map.containsKey(projectDataVO.getName())) continue;
                List<ProjectCountVO> projectCountVOS = map.get(projectDataVO.getName());
                ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                for (ProjectCountVO projectCountVO : projectCountVOS) {
                    ProjectVo projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                    projectVos.add(projectVo);
                }
                projectDataVO.setProjectList(projectVos);
            }
        }
        int allProjectNumber = list.size();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", (Object)allProjectNumber);
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>(){

                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        jsonObject.put("data", dataVOS);
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, ProjectDataVO> map = new HashMap<String, ProjectDataVO>();
        for (ProjectCountVO vo : list) {
            BigDecimal contractTaxMny;
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            if (!map.containsKey(childrenName)) {
                ProjectDataVO pvo = new ProjectDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                pvo.setContractMoney(contractTaxMny);
                map.put(childrenName, pvo);
                continue;
            }
            ProjectDataVO projectDataVO = (ProjectDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<ProjectCountVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity)) : list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<ProjectDataVO>(map.values());
        for (ProjectDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<ProjectCountVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
            for (ProjectCountVO projectCountVO : projectCountVOS) {
                ProjectVo projectVo = new ProjectVo();
                projectVo.setId(projectCountVO.getId());
                projectVo.setName(projectCountVO.getProjectName());
                projectVo.setOrgId(projectCountVO.getOrgId());
                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                projectVos.add(projectVo);
            }
            dataVO.setProjectList(projectVos);
        }
        return projectDataVOS;
    }
}

