package com.ejianc.business.bid.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.vo.*;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.bid.bean.UndertakeEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;

/**
 * 承揽任务登记
 * 
 * @author generator
 * 
 */
@Mapper
public interface UndertakeMapper extends BaseCrudMapper<UndertakeEntity> {
    List<UndertakeApiVO> queryUndertakeInfoList(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<DeptOrderApiVO> queryDeptOrderList(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<DeptOrderApiVO> queryOutputDeptOrderList(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    //BI门户：新增承揽金额月度分布
    List<String> queryUndertakeCostMonth(String year, List<Long> orgIds);

    //BI门户：年度承揽目标达成率
    @Select("select sum(u.project_cost) undertake_mny,(select new_contracat_target  from `ejc-companypfm`.t_companypfm_ndqk n\n" +
            "where n.dr = 0\n" +
            "and n.year = #{year}) as target_mny  from ejc_bid_undertake u\n" +
            "where u.year = #{year}\n" +
            "and dr = 0\n" +
            "and bill_state in (1,3)")
    UndertakeTargetVO queryUndertakeYearTarget(String year);

}
