package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.BiddingFileReviewZiEntity;
import com.ejianc.business.bid.bean.ChoosePersonZiEntity;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.bean.ZjllEntity;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.BiddingFileReviewMapper;
import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.service.IBiddingFileReviewService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 招标文件评审
 * 
 * @author generator
 * 
 */
@Service("biddingFileReviewService")
public class BiddingFileReviewServiceImpl extends BaseServiceImpl<BiddingFileReviewMapper, BiddingFileReviewEntity> implements IBiddingFileReviewService{

    @Autowired
    private BiddingFileReviewMapper biddingFileReviewMapper;
    @Autowired
    private IZjllApi zjllApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public BiddingFileReviewEntity selectByEnrollId(Long enrollId) {
        return biddingFileReviewMapper.selectByEnrollId(enrollId);
    }

    @Override
    public void saveZjll(BiddingFileReviewEntity bidFileReviewEntity) {
        /*
         * 投标评审后新增在建人员履历
         * */

        //通过建造师编号查询员工信息
//			CommonResponse<EmployeeVO> byEmpmloyeeCode = employeeApi.getByEmpmloyeeCode(bidFileReviewEntity.getEmployeeCode());
//
//			if (!byEmpmloyeeCode.isSuccess()){
//				throw new BusinessException("通过EmpmloyeeCode获取员工信息数据失败！ 员工编码为： " +bidFileReviewEntity.getEmployeeCode() );
//			}
//			EmployeeVO employeeVO = byEmpmloyeeCode.getData();

        ZjllEntity zjllEntity =new ZjllEntity();
        zjllEntity.setXmId(bidFileReviewEntity.getPid());//使用查询到的员工信息id作为 在建履历的姓名id
        zjllEntity.setXmName(bidFileReviewEntity.getBuiltConstructor());
        zjllEntity.setGwId(561958846671749219L);
        zjllEntity.setGw("项目经理");
        zjllEntity.setProjectId(bidFileReviewEntity.getEngineeringId());
        zjllEntity.setProjectName(bidFileReviewEntity.getEngineeringName());
        zjllEntity.setKssj(new Date());
        zjllEntity.setZt(0);
        zjllEntity.setYxzt(0); //0:是 1 否
        zjllEntity.setOrgId(bidFileReviewEntity.getOrgId());
        zjllEntity.setOrgName(bidFileReviewEntity.getOrgName());
        zjllEntity.setZsbh(bidFileReviewEntity.getZcbh());
        zjllEntity.setKbrq(bidFileReviewEntity.getPlannedTenderDate());
        zjllEntity.setTags("在建履历");
        zjllEntity.setRemark("招标文件评审");
        ZjllVO vo = BeanMapper.map(zjllEntity,ZjllVO.class);
        zjllApi.save(vo);
        logger.info("招标文件评审保存项目经理数据到在建人员履历！");


        List<BiddingFileReviewZiEntity> list = bidFileReviewEntity.getBiddingFileReviewZiList();
        List<ZjllVO> zill = new ArrayList<>();
            for (BiddingFileReviewZiEntity ziEntity : list) {
                //除项目经理外中标登记
                if (!("项目经理".equals(ziEntity.getGw()))) {
                    ZjllVO zjllVO = new ZjllVO();
                    zjllVO.setYxzt(0);
                    zjllVO.setZt(0);
                    zjllVO.setProjectId(bidFileReviewEntity.getEngineeringId());
                    zjllVO.setProjectName(bidFileReviewEntity.getEngineeringName());
                    zjllVO.setXmId(ziEntity.getOperatorId());
                    zjllVO.setXmName(ziEntity.getRyName());
                    zjllVO.setGwId(ziEntity.getGwId());
                    zjllVO.setGw(ziEntity.getGw());
                    zjllVO.setOrgId(bidFileReviewEntity.getOrgId());
                    zjllVO.setOrgName(bidFileReviewEntity.getOrgName());
                    zjllVO.setKssj(new Date());
                    zjllVO.setKbrq(bidFileReviewEntity.getPlannedTenderDate());
                    zjllVO.setTags("在建履历");
                    zjllVO.setSfgs(ziEntity.getSfgs());//是否公示
                    zjllVO.setRemark("招标文件评审");
                    zill.add(zjllVO);
                }
            }
            if (zill.size() > 0) {
                zjllApi.saveorupdateBatch(zill);
                logger.info("招标文件评审保存{}数据到在建人员履历！",zill.size() );
            }
    }

    /*
     * 评审提交后后更新在建人员履历
     * */
    @Override
    public void updateZjll(BiddingFileReviewEntity bidFileReviewEntity) {

        deleteZjll(bidFileReviewEntity);

        saveZjll(bidFileReviewEntity);
        /*
        修改项目经理
         */
//        ZjllEntity zjllEntity =new ZjllEntity();
//        zjllEntity.setXmId(bidFileReviewEntity.getPid());//使用查询到的员工信息id作为 在建履历的姓名id
//        zjllEntity.setXmName(bidFileReviewEntity.getBuiltConstructor());
//        zjllEntity.setProjectId(bidFileReviewEntity.getEngineeringId());
//        zjllEntity.setGwId(561958846671749219L);//项目经理
//        zjllEntity.setRemark("招标文件评审");
//        ZjllVO vo = BeanMapper.map(zjllEntity,ZjllVO.class);
//
//        CommonResponse<String> stringCommonResponse = zjllApi.updateZjsZjll(vo);
//
//        if(stringCommonResponse != null && stringCommonResponse.getCode() == 0) {
//            logger.info("招标文件评审修改项目经理数据到在建人员履历！");
//        }else {
//            logger.info("招标文件评审修改项目经理数据到在建人员履历！失败！");
//        }
        /*
        修改子表人员
         */
//        List<BiddingFileReviewZiEntity> biddingFileReviewZiList = bidFileReviewEntity.getBiddingFileReviewZiList();
//        for (BiddingFileReviewZiEntity ziEntity:biddingFileReviewZiList){
//            ZjllEntity zjllEntity1 =new ZjllEntity();
//            zjllEntity1.setXmId(ziEntity.getOperatorId());//使用查询到的员工信息id作为 在建履历的姓名id
//            zjllEntity1.setXmName(ziEntity.getRyName());
//            zjllEntity1.setProjectId(bidFileReviewEntity.getEngineeringId());
//            zjllEntity1.setGwId(ziEntity.getGwId());//
//            zjllEntity1.setRemark("招标文件评审");
//            ZjllVO vo1 = BeanMapper.map(zjllEntity1,ZjllVO.class);
//
//            CommonResponse<String> stringCommonResponse1 = zjllApi.updateZjsZjll(vo1);
//            if(stringCommonResponse1 != null && stringCommonResponse1.getCode() == 0) {
//                logger.info("招标文件评审修改{}数据到在建人员履历！",ziEntity.getGw());
//            }else {
//                logger.info("招标文件评审修改{}数据到在建人员履历！失败！",ziEntity.getGw());
//            }
//        }


    }
    /*
     * 评审删除后后删除在建人员履历
     * */
    @Override
    public void deleteZjll(BiddingFileReviewEntity bidFileReviewEntity) {
        ZjllEntity zjllEntity =new ZjllEntity();
        zjllEntity.setXmId(bidFileReviewEntity.getPid());//使用查询到的员工信息id作为 在建履历的姓名id
        zjllEntity.setXmName(bidFileReviewEntity.getBuiltConstructor());
        zjllEntity.setProjectId(bidFileReviewEntity.getEngineeringId());
        zjllEntity.setRemark("招标文件评审");
        ZjllVO vo = BeanMapper.map(zjllEntity,ZjllVO.class);

        CommonResponse<String> stringCommonResponse = zjllApi.deleteZjsZjll(vo);
        if(stringCommonResponse != null && stringCommonResponse.getCode() == 0) {
            logger.info("招标文件评审删除项目经理数据到在建人员履历！");
        }else {
            logger.info("招标文件评审删除项目经理数据到在建人员履历！失败！");
        }

        /**
         * 删除子表人员信息
         */
        List<BiddingFileReviewZiEntity> biddingFileReviewZiList = bidFileReviewEntity.getBiddingFileReviewZiList();
        for (BiddingFileReviewZiEntity ziEntity:biddingFileReviewZiList){
            ZjllEntity zjllEntity1 =new ZjllEntity();
            zjllEntity1.setXmId(ziEntity.getOperatorId());//使用查询到的员工信息id作为 在建履历的姓名id
            zjllEntity1.setXmName(ziEntity.getRyName());
            zjllEntity1.setProjectId(bidFileReviewEntity.getEngineeringId());
            zjllEntity1.setRemark("招标文件评审删除");
            ZjllVO vo1 = BeanMapper.map(zjllEntity1,ZjllVO.class);

            CommonResponse<String> stringCommonResponse1 = zjllApi.deleteZjsZjll(vo1);
            if(stringCommonResponse1 != null && stringCommonResponse1.getCode() == 0) {
                logger.info("招标文件评审删除{}数据到在建人员履历！");
            }else {
                logger.info("招标文件评审删除{}数据到在建人员履历！失败！");
            }
        }
    }

}
