package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.service.IUndertakeService;
import com.ejianc.business.bid.vo.UndertakeVO;

/**
 * 承揽任务登记
 *
 * @author generator
 */
@Controller
@RequestMapping("undertake")
public class UndertakeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOutputValueApi outputValueApi;

    private static final String BILL_CODE = "bid_undertake";//此处需要根据实际修改

    @Autowired
    private IUndertakeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi orgApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UndertakeVO> saveOrUpdate(@RequestBody UndertakeVO saveOrUpdateVO) {
        UndertakeEntity entity = BeanMapper.map(saveOrUpdateVO, UndertakeEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        service.saveOrUpdate(entity, false);
        UndertakeVO vo = BeanMapper.map(entity, UndertakeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UndertakeVO> queryDetail(Long id) {
        UndertakeEntity entity = service.selectById(id);
        UndertakeVO vo = BeanMapper.map(entity, UndertakeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UndertakeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UndertakeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UndertakeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UndertakeVO>> queryList(@RequestBody QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int total = 0; // 总条数
        int pages = 0; // 有几页
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("porjectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("jzsName");
        fuzzyFields.add("xmnbcbrName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (!param.getParams().containsKey("makeOrgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                //普通组织
                commonOrgIds.add(org.getId());

            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        }

        if(param.getParams().get("areaName") != null){
            //in 省内 out 省外
            String provinceFlag = param.getParams().get("areaName").getValue().toString();
            param.getParams().remove("areaName");
            if("in".equals(provinceFlag)){
                param.getParams().put("areaName",new Parameter(QueryParam.LIKE,"河南省"));
            } else if("out".equals(provinceFlag)){
                param.getParams().put("areaName",new Parameter(QueryParam.NOT_LIKE,"河南省"));
            }
        }

        if(param.getParams().get("projectCost") != null){
            //1:5千万以下 2:5前往到1亿 3:一亿以上
            String projectCostFlag = param.getParams().get("projectCost").getValue().toString();

            if("1".equals(projectCostFlag)){
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost",new Parameter(QueryParam.LE,FIFTY_MILLION));
            } else if("2".equals(projectCostFlag)){
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost",new Parameter(QueryParam.SQL,"project_cost >= "+FIFTY_MILLION + " and project_cost <=" + ONE_HUNDRED_MILLION));
            } else if("3".equals(projectCostFlag)){
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost",new Parameter(QueryParam.GE,ONE_HUNDRED_MILLION));
            }
        }

        List<UndertakeEntity> undertakeEntities = service.queryList(param);
        total = undertakeEntities.size();
        //List<UndertakeEntity> list = undertakeEntities.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());

        List<UndertakeVO> undertakeVOS = BeanMapper.mapList(undertakeEntities, UndertakeVO.class);

        // IPage<UndertakeEntity> page = service.queryPage(param,false);
        IPage<UndertakeVO> pageData = new Page<>(pageIndex, pageSize, total);
        pageData.setRecords(undertakeVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("porjectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("jzsName");
        fuzzyFields.add("xmnbcbrName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UndertakeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Undertake-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refUndertakeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UndertakeVO>> refUndertakeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UndertakeEntity> page = service.queryPage(param, false);
        IPage<UndertakeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UndertakeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 修改开标日期
     */
    @RequestMapping(value = "/updateProjectCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateProjectCost(@RequestBody UndertakeVO updateVO) {
        if (updateVO.getId() != null) {
            UndertakeEntity entity = service.selectById(updateVO.getId());
            entity.setProjectCost(updateVO.getProjectCost());
            service.updateById(entity);
        }
        return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @param id
     * @Description queryDetail 查询主合同信息详情
     */
    @RequestMapping(value = "/queryMainId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UndertakeVO> queryMainId(Long id) {
        UndertakeEntity entity = service.selectById(id);
        UndertakeEntity entity1 = new UndertakeEntity();
        entity1.setPorjectName(entity.getPorjectName());//工程名称
        entity1.setDays(entity.getDays());
        entity1.setProjectQuality(entity.getProjectQuality());
        entity1.setJzsId(entity.getJzsId());
        entity1.setJzsName(entity.getJzsName());
        entity1.setXmnbcbrId(entity.getXmnbcbrId());
        entity1.setXmnbcbrName(entity.getXmnbcbrName());
        UndertakeVO vo = BeanMapper.map(entity1, UndertakeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description getContractingProvinceContrast 省内外承揽任务对比
     */
    @RequestMapping(value = "/getContractingProvinceContrast", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getContractingProvinceContrast(String timeFlag, Long orgId) {

        List<Map<String, String>> result = new ArrayList<>();

        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = orgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        List<BigDecimal> contractingList = new ArrayList<>();//承揽金额
        List<BigDecimal> contrastList = new ArrayList<>();//同比
        List<String> dateList = new ArrayList<>();//年份
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        if ("firstQuarter".equals(timeFlag)) {
            endMonth = "-3-31";
        } else if ("halfYear".equals(timeFlag)) {
            endMonth = "-6-30";
        } else if ("thirdQuarter".equals(timeFlag)) {
            endMonth = "-9-30";
        } else if ("thisYear".equals(timeFlag)) {
            endMonth = "-12-31";
        } else if("now".equals(timeFlag)){
            endMonth = "-"+ LocalDate.now().getMonth().getValue()+"-"+LocalDate.now().getDayOfMonth();
        }

        QueryWrapper<UndertakeEntity> undertakeWrapper = new QueryWrapper<>();
        undertakeWrapper.in("org_id", orgIdList);
        undertakeWrapper.in("bill_state", Arrays.asList(1, 3));
        undertakeWrapper.between("yw_date", DateUtil.getYear() + startMonth, DateUtil.getYear() + endMonth);

        List<UndertakeEntity> allData = service.list(undertakeWrapper);

        //省内承揽
        List<UndertakeEntity> provinceIn = allData.stream().filter(s -> s.getAreaName() != null && s.getAreaName().contains("河南省")).collect(Collectors.toList());
        //5千万以下
        BigDecimal provinceInUnderFive = getSumProjectCostByRange(provinceIn, null, FIFTY_MILLION);
        //5千万~1亿
        BigDecimal provinceInBetweenFiveToTen = getSumProjectCostByRange(provinceIn, FIFTY_MILLION, ONE_HUNDRED_MILLION);
        //1亿以上
        BigDecimal provinceInAboveTen = getSumProjectCostByRange(provinceIn, ONE_HUNDRED_MILLION, null);


        //省外承揽
        List<UndertakeEntity> provinceOut = allData.stream().filter(s -> s.getAreaName() != null && !s.getAreaName().contains("河南省")).collect(Collectors.toList());
        //5千万以下
        BigDecimal provinceOutUnderFive = getSumProjectCostByRange(provinceOut, null, FIFTY_MILLION);
        //5千万~1亿
        BigDecimal provinceOutBetweenFiveToTen = getSumProjectCostByRange(provinceOut, FIFTY_MILLION, ONE_HUNDRED_MILLION);
        //1亿以上
        BigDecimal provinceOutAboveTen = getSumProjectCostByRange(provinceOut, ONE_HUNDRED_MILLION, null);

        List<BigDecimal> values = new ArrayList<>();
        values.add(provinceInUnderFive);
        values.add(provinceInBetweenFiveToTen);
        values.add(provinceInAboveTen);
        values.add(provinceOutUnderFive);
        values.add(provinceOutBetweenFiveToTen);
        values.add(provinceOutAboveTen);
        List<String> names = new ArrayList<>();
        names.add("省内5000万以下承揽额");
        names.add("省内5千万到1亿承揽额");
        names.add("省内1亿以上承揽额");
        names.add("省外5000万以下承揽额");
        names.add("省外5千万到1亿承揽额");
        names.add("省外1亿以上承揽额");

        for (int i = 0; i < values.size(); i++) {
            HashMap<String, String> map = new HashMap<>();
            map.put("name", names.get(i));
            map.put("value", values.get(i).toString());
            result.add(map);
        }

        return CommonResponse.success("查询详情数据成功！", result);
    }


    /**
     * 根据承揽范围查询承揽金额总和
     *
     * @param list
     * @param start
     * @param end
     * @return
     */

    private static final BigDecimal ONE_HUNDRED_MILLION = new BigDecimal(10000);//一亿
    private static final BigDecimal FIFTY_MILLION = new BigDecimal(5000);//五千万


    private BigDecimal getSumProjectCostByRange(List<UndertakeEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getProjectCost() != null
                    && s.getProjectCost().compareTo(start) > 0
                    && s.getProjectCost().compareTo(end) <= 0)
                    .map(UndertakeEntity::getProjectCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getProjectCost() != null
                    && s.getProjectCost().compareTo(end) <= 0)
                    .map(UndertakeEntity::getProjectCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getProjectCost() != null
                    && s.getProjectCost().compareTo(start) > 0)
                    .map(UndertakeEntity::getProjectCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }


    /**
     * @param
     * @Description 项目名称获取承揽信息
     */
    @RequestMapping(value = "/queryDetailByProjectName", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UndertakeVO> queryDetail(String projectName) {
        QueryWrapper<UndertakeEntity> undertakeWrapper = new QueryWrapper<>();
        undertakeWrapper.eq("porject_name", projectName);
        undertakeWrapper.in("bill_state", Arrays.asList(1, 3));
        undertakeWrapper.eq("supplement_flag", 0);

        List<UndertakeEntity> entity = service.list(undertakeWrapper);
        List<UndertakeVO> undertakeVOS = BeanMapper.mapList(entity, UndertakeVO.class);
        UndertakeVO vo = new UndertakeVO();
        if (undertakeVOS != null && undertakeVOS.size() >0){
            vo = undertakeVOS.get(0);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }
}
