package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.consts.ProjectSurveyEnum;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectCountVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectDataVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectVo;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectSurveyTreeVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.bid.mapper.EnrollMapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.service.IEnrollService;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import static com.ejianc.business.bid.utils.AddressResolutionUtil.*;

/**
 * 投标报名
 * 
 * @author generator
 * 
 */
@Service("enrollService")
public class EnrollServiceImpl extends BaseServiceImpl<EnrollMapper, EnrollEntity> implements IEnrollService{
   @Autowired
   private EnrollMapper enrollMapper;
    @Override
    public List<EnrollVO> queryBidOpeningSoon() {
        return enrollMapper.queryBidOpeningSoon();
    }

    @Override
    public List<EnrollEntity> selectEnrollListIsBidding() {
        return enrollMapper.selectEnrollListIsBidding();
    }

    @Override
    public List<EnrollEntity> selectEnrollListIsSummary() {
        return enrollMapper.selectEnrollListIsSummary();
    }

    @Override
    public CommonResponse<JSONObject> enrollArea(String range, String name, String dateIn, Long orgId) {
        String projectStatus = null;
        //在建
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        //今年
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        }

        List<ProjectCountVO> list = new ArrayList<>();
        List<ProjectSurveyTreeVO> listTree = new ArrayList<>();
        QueryWrapper<EnrollEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(dateIn)) {
            queryWrapper.eq("DATE_FORMAT(bill_date,\"%Y\")", dateIn);
        }
        queryWrapper.in("bill_state", Arrays.asList(1, 3));
        List<EnrollEntity> enrollEntities = this.list(queryWrapper);
        List<ProjectSurveyVO> projectSurveyVOS = new ArrayList<>();
        if(ListUtil.isNotEmpty(enrollEntities)){
            for (EnrollEntity enrollEntity : enrollEntities) {
                ProjectSurveyVO projectSurveyVO = new ProjectSurveyVO();
                projectSurveyVO.setId(enrollEntity.getId());
                projectSurveyVO.setProjectName(enrollEntity.getEngineeringName());
                projectSurveyVO.setOrgId(enrollEntity.getOrgId());
//            projectSurveyVO.setParentProjectId();
                projectSurveyVO.setArea(enrollEntity.getArea());
                projectSurveyVO.setProvince(enrollEntity.getProvince());
                projectSurveyVO.setCity(enrollEntity.getCity());
                projectSurveyVO.setCounty(enrollEntity.getRegion());
//            projectSurveyVO.setProjectDepartmentId(enrollEntity.getProjectManager());
                projectSurveyVOS.add(projectSurveyVO);
            }
            List<ProjectSurveyTreeVO> dataTree = BeanMapper.mapList(projectSurveyVOS, ProjectSurveyTreeVO.class);
            listTree = TreeNodeBUtil.buildTree(dataTree);// 主子项目的返回数据
            List<ProjectCountVO> projectCountVOS = BeanMapper.mapList(listTree, ProjectCountVO.class);
            list.addAll(projectCountVOS);
        }



        List<Long> ids = new ArrayList<>();
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pName = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getArea())) {
                if (vo.getArea().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMap = addressResolution(vo.getArea());
                    if (areaMap != null) {
                        String province = areaMap.get("province") == null ? "其他" : areaMap.get("province");
                        String city = areaMap.get("city") == null ? "其他" : areaMap.get("city");
                        String county = areaMap.get("county") == null ? "其他" : areaMap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pName = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType = null;
        List<ProjectDataVO> dataVOS = new ArrayList<>();

        if (org.apache.commons.lang3.StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = getProvincePinYin(pName) + "-" + getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, list, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, ProjectDataVO> countyMap = new HashMap<>();
                    for (ProjectCountVO vo : list) {
                        String county = vo.getCounty();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                        if (!countyMap.containsKey(county)) {
                            ProjectDataVO pvo = new ProjectDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            countyMap.put(county, pvo);
                        } else {
                            ProjectDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<>(countyMap.values());
                    Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                    for (ProjectDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                            List<ProjectVo> projectVos = new ArrayList<>();
                            for (ProjectCountVO projectCountVO : projectCountVOS) {
                                ProjectVo projectVo = new ProjectVo();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getProjectName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                } else {
                    rangeType = getProvincePinYin(provinceSet.iterator().next());
                    Map<String, ProjectDataVO> cityMap = new HashMap<>();
                    for (ProjectCountVO vo : list) {
                        String city = vo.getCity();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                        if (!cityMap.containsKey(city)) {
                            ProjectDataVO pvo = new ProjectDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            cityMap.put(city, pvo);
                        } else {
                            ProjectDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<ProjectDataVO>(cityMap.values());
                    Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                    for (ProjectDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                            List<ProjectVo> projectVos = new ArrayList<>();
                            for (ProjectCountVO projectCountVO : projectCountVOS) {
                                ProjectVo projectVo = new ProjectVo();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getProjectName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, ProjectDataVO> provinceMap = new HashMap<>();
                for (ProjectCountVO vo : list) {
                    String province = vo.getProvince();
                    BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                    if (!provinceMap.containsKey(province)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        pvo.setContractMoney(contractTaxMny);
                        provinceMap.put(province, pvo);
                    } else {
                        ProjectDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
                dataVOS = new ArrayList<>(provinceMap.values());
                for (ProjectDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                        List<ProjectVo> projectVos = new ArrayList<>();
                        for (ProjectCountVO projectCountVO : projectCountVOS) {
                            ProjectVo projectVo = new ProjectVo();
                            projectVo.setId(projectCountVO.getId());
                            projectVo.setName(projectCountVO.getProjectName());
                            projectVo.setOrgId(projectCountVO.getOrgId());
                            projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                            projectVos.add(projectVo);
                        }
                        dataVO.setProjectList(projectVos);
                    }
                }
            }
        }
        int allProjectNumber = list.size();//总项目数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", allProjectNumber);

        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>() {
                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "其他".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "其他".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        jsonObject.put("data", dataVOS);
        //在这个地方处理四个直辖市
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        jsonObject.put("range", rangeType == null || rangeType.contains("null") ? "China" : rangeType);
        return CommonResponse.success("查询数据成功！", jsonObject);
    }
    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        List<ProjectDataVO> dataVOS = new ArrayList<>();
        Map<String, ProjectDataVO> map = new HashMap<>();
        for (ProjectCountVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (voName.equals(name)) {
                BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                if (!map.containsKey(childrenName)) {
                    ProjectDataVO pvo = new ProjectDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    pvo.setContractMoney(contractTaxMny);
                    map.put(childrenName, pvo);
                } else {
                    ProjectDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    map.put(childrenName, projectDataVO);
                }
            }
        }
        Map<String, List<ProjectCountVO>> projectCountVOMap = null;
        if (type == 0) {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
        } else {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
        }
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<>(map.values());
        for (ProjectDataVO dataVO : projectDataVOS) {
            if (map.containsKey(dataVO.getName())) {
                List<ProjectCountVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
                List<ProjectVo> projectVos = new ArrayList<>();
                for (ProjectCountVO projectCountVO : projectCountVOS) {
                    ProjectVo projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                    projectVos.add(projectVo);
                }
                dataVO.setProjectList(projectVos);
            }
        }
        return projectDataVOS;

    }

}
