package com.ejianc.business.bid.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 投标报名
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_enroll")
public class EnrollEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 招标编号
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="engineering_name")
    private String engineeringName; // 投标项目名称
    @TableField(value="publish_date")
    private Date publishDate; // 经办日期
    @TableField(value="info_source")
    private Long infoSource; // 信息来源
    @TableField(value="info_source_name")
    private String infoSourceName; // 信息来源名称
    @TableField(value="bid_org_id")
    private Long bidOrgId; // 申请单位
    @TableField(value="bid_org_name")
    private String bidOrgName; // 申请单位名称
    @TableField(value="bid_num")
    private Integer bidNum; // 标段数量
    @TableField(value="follow_person")
    private Long followPerson; // 项目联系人
    @TableField(value="follow_person_name")
    private String followPersonName; // 项目联系人名称
    @TableField(value="follow_person_phone")
    private String followPersonPhone; // 项目联系人电话
    @TableField(value="project_manager")
    private Long projectManager; // 申请人员
    @TableField(value="project_manager_name")
    private String projectManagerName; // 申请人员名称
    @TableField(value="project_manager_phone")
    private String projectManagerPhone; // 申请人员电话
    @TableField(value="bid_agent_org")
    private String bidAgentOrg; // 招标代理机构
    @TableField(value="make_org_id")
    private Long makeOrgId; // 编制机构
    @TableField(value="make_org_name")
    private String makeOrgName; // 编制机构名称
    @TableField(value="bid_file_date")
    private Date bidFileDate; // 招标文件下载日期
    @TableField(value="sign_date")
    private Date signDate; // 申请日期
    @TableField(value="is_precheck")
    private Integer isPrecheck; // 是否需要资格预审
    @TableField(value="is_give")
    private Integer isGive; // 是否直接发包
    @TableField(value="bid_state")
    private Integer bidState; // 投标状态
    @TableField(value="area")
    private String area; // 地区
    @TableField(value="address")
    private String address; // 工程地点
    @TableField(value="construction_unit")
    private Long constructionUnit; // 建设单位
    @TableField(value="construction_unit_name")
    private String constructionUnitName; // 建设单位名称
    @TableField(value="construction_unit_type")
    private Long constructionUnitType; // 建设单位性质
    @TableField(value="construction_unit_type_name")
    private String constructionUnitTypeName; // 建设单位性质名称
    @TableField(value="owner_client")
    private String ownerClient; // 业主委托人
    @TableField(value="owner_client_phone")
    private String ownerClientPhone; // 业主委托人联系方式
    @TableField(value="investor")
    private Long investor; // 投资主体
    @TableField(value="investor_name")
    private String investorName; // 投资主体名称
    @TableField(value="funds_source")
    private Long fundsSource; // 资金来源
    @TableField(value="funds_source_name")
    private String fundsSourceName; // 资金来源
    @TableField(value="cost_total")
    private BigDecimal costTotal; // 投资金额
    @TableField(value="bidding_form")
    private Integer biddingForm; // 招标形式
    @TableField(value="bidding_date")
    private Date biddingDate; // 开标日期
    @TableField(value="bid_scope")
    private String bidScope; // 投标范围
    @TableField(value="plan_day")
    private BigDecimal planDay; // 计划工期
    @TableField(value="engineering_type")
    private Long engineeringType; // 工程类别
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类别
    @TableField(value="quality_leave")
    private Long qualityLeave; // 质量要求
    @TableField(value="quality_leave_name")
    private String qualityLeaveName; // 质量要求
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="is_stop")
    private Integer isStop; // 是否中止1是0否
    @TableField(value="bid_stage")
    private Integer bidStage; // 投标阶段
    @TableField(value="source_type")
    private Integer sourceType; // 1新增0信息跟踪
    @TableField(value="source_id")
    private Long sourceId; // 信息跟踪来源id
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="province")
    private String province; // 省份
    @TableField(value="city")
    private String city; // 市
    @TableField(value="region")
    private String region; // 区县
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人
    @TableField(value="bill_date")
    private Date billDate; // 编制日期
    @TableField(value="adcode")
    private String adcode; // 区划编码
    @TableField(value="is_pre_checked")
    private Integer isPreChecked; // 已资格预审
    @TableField(value="is_bid_checked")
    private Integer isBidChecked; // 已投标文件评审
    @TableField(value="is_biddding_checked")
    private Integer isBidddingChecked; // 已招标文件评审
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="flag_tec")
    private Integer flagTec; // 技术评审标识 0没有 1已提交
    @TableField(value="flag_bis")
    private Integer flagBis; // 商务评审标识 0没有 1已提交
    @TableField(value="flag_value")
    private Integer flagValue; // 价格评审标识 0没有 1已提交
    @TableField(value="deposit_bank")
    private String depositBank; // 开户银行
    @TableField(value="account_name")
    private String accountName; // 开户名称
    @TableField(value="account_number")
    private String accountNumber; // 开户账号
    @TableField(value="need_support_project")
    private Integer needSupportProject; // 需支持项目(0：标书费，1:资政文件，2：其他)
    @TableField(value="need_support_project_info")
    private String needSupportProjectInfo; // 需支持项目信息
    @TableField(value="cash_discount")
    private Integer cashDiscount; // 是否现金支付(0：否，1：是)
    @TableField(value="tender_fee")
    private BigDecimal tenderFee; // 标书费用
    @TableField(value="tender_fee_capital")
    private String tenderFeeCapital; // 费用金额(大写）
    @TableField(value="analysis_report")
    private String analysisReport; // 投标项目信息分析报告
    @TableField(value="analysis_report_id")
    private Long analysisReportId; // 投标项目信息分析报告id
    @TableField(value="dept_id")
    private Long deptId; // 经办部门id
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="dept_code")
    private String deptCode; // 经办部门code

    public Integer getFlagTec() {
        return flagTec;
    }

    public void setFlagTec(Integer flagTec) {
        this.flagTec = flagTec;
    }

    public Integer getFlagBis() {
        return flagBis;
    }

    public void setFlagBis(Integer flagBis) {
        this.flagBis = flagBis;
    }

    public Integer getFlagValue() {
        return flagValue;
    }

    public void setFlagValue(Integer flagValue) {
        this.flagValue = flagValue;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getIsPreChecked() {
        return isPreChecked;
    }

    public void setIsPreChecked(Integer isPreChecked) {
        this.isPreChecked = isPreChecked;
    }

    public Integer getIsBidChecked() {
        return isBidChecked;
    }

    public void setIsBidChecked(Integer isBidChecked) {
        this.isBidChecked = isBidChecked;
    }

    public Integer getIsBidddingChecked() {
        return isBidddingChecked;
    }

    public void setIsBidddingChecked(Integer isBidddingChecked) {
        this.isBidddingChecked = isBidddingChecked;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 公告发布日期
     */
    public java.util.Date getPublishDate() {
        return publishDate;
    }

    /**
     * 公告发布日期
     */
    public void setPublishDate(java.util.Date publishDate) {
        this.publishDate = publishDate;
    }
    /**
     * 信息来源
     */
    public Long getInfoSource() {
        return infoSource;
    }

    /**
     * 信息来源
     */
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    /**
     * 信息来源名称
     */
    public String getInfoSourceName() {
        return infoSourceName;
    }

    /**
     * 信息来源名称
     */
    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }
    /**
     * 投标单位
     */
    public Long getBidOrgId() {
        return bidOrgId;
    }

    /**
     * 投标单位
     */
    public void setBidOrgId(Long bidOrgId) {
        this.bidOrgId = bidOrgId;
    }
    /**
     * 投标单位名称
     */
    public String getBidOrgName() {
        return bidOrgName;
    }

    /**
     * 投标单位名称
     */
    public void setBidOrgName(String bidOrgName) {
        this.bidOrgName = bidOrgName;
    }
    /**
     * 标段数量
     */
    public Integer getBidNum() {
        return bidNum;
    }

    /**
     * 标段数量
     */
    public void setBidNum(Integer bidNum) {
        this.bidNum = bidNum;
    }
    /**
     * 单位负责人
     */
    public Long getFollowPerson() {
        return followPerson;
    }

    /**
     * 单位负责人
     */
    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }
    /**
     * 负责人名称
     */
    public String getFollowPersonName() {
        return followPersonName;
    }

    /**
     * 负责人名称
     */
    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }
    /**
     * 负责人电话
     */
    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    /**
     * 负责人电话
     */
    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }
    /**
     * 项目投标主管
     */
    public Long getProjectManager() {
        return projectManager;
    }

    /**
     * 项目投标主管
     */
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    /**
     * 项目投标主管名称
     */
    public String getProjectManagerName() {
        return projectManagerName;
    }

    /**
     * 项目投标主管名称
     */
    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    /**
     * 项目投标主管联系方式
     */
    public String getProjectManagerPhone() {
        return projectManagerPhone;
    }

    /**
     * 项目投标主管联系方式
     */
    public void setProjectManagerPhone(String projectManagerPhone) {
        this.projectManagerPhone = projectManagerPhone;
    }
    /**
     * 招标代理机构
     */
    public String getBidAgentOrg() {
        return bidAgentOrg;
    }

    /**
     * 招标代理机构
     */
    public void setBidAgentOrg(String bidAgentOrg) {
        this.bidAgentOrg = bidAgentOrg;
    }
    /**
     * 编制机构
     */
    public Long getMakeOrgId() {
        return makeOrgId;
    }

    /**
     * 编制机构
     */
    public void setMakeOrgId(Long makeOrgId) {
        this.makeOrgId = makeOrgId;
    }
    /**
     * 编制机构名称
     */
    public String getMakeOrgName() {
        return makeOrgName;
    }

    /**
     * 编制机构名称
     */
    public void setMakeOrgName(String makeOrgName) {
        this.makeOrgName = makeOrgName;
    }
    /**
     * 招标文件下载日期
     */
    public java.util.Date getBidFileDate() {
        return bidFileDate;
    }

    /**
     * 招标文件下载日期
     */
    public void setBidFileDate(java.util.Date bidFileDate) {
        this.bidFileDate = bidFileDate;
    }
    /**
     * 报名日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 报名日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 是否资格预审
     */
    public Integer getIsPrecheck() {
        return isPrecheck;
    }

    /**
     * 是否资格预审
     */
    public void setIsPrecheck(Integer isPrecheck) {
        this.isPrecheck = isPrecheck;
    }
    /**
     * 是否直接发包
     */
    public Integer getIsGive() {
        return isGive;
    }

    /**
     * 是否直接发包
     */
    public void setIsGive(Integer isGive) {
        this.isGive = isGive;
    }
    /**
     * 投标状态
     */
    public Integer getBidState() {
        return bidState;
    }

    /**
     * 投标状态
     */
    public void setBidState(Integer bidState) {
        this.bidState = bidState;
    }
    /**
     * 地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 地区
     */
    public void setArea(String area) {
        this.area = area;
    }
    /**
     * 工程地点
     */
    public String getAddress() {
        return address;
    }

    /**
     * 工程地点
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 建设单位
     */
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    /**
     * 建设单位
     */
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    /**
     * 建设单位名称
     */
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    /**
     * 建设单位名称
     */
    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }
    /**
     * 建设单位性质
     */
    public Long getConstructionUnitType() {
        return constructionUnitType;
    }

    /**
     * 建设单位性质
     */
    public void setConstructionUnitType(Long constructionUnitType) {
        this.constructionUnitType = constructionUnitType;
    }
    /**
     * 建设单位性质名称
     */
    public String getConstructionUnitTypeName() {
        return constructionUnitTypeName;
    }

    /**
     * 建设单位性质名称
     */
    public void setConstructionUnitTypeName(String constructionUnitTypeName) {
        this.constructionUnitTypeName = constructionUnitTypeName;
    }
    /**
     * 业主委托人
     */
    public String getOwnerClient() {
        return ownerClient;
    }

    /**
     * 业主委托人
     */
    public void setOwnerClient(String ownerClient) {
        this.ownerClient = ownerClient;
    }
    /**
     * 业主委托人联系方式
     */
    public String getOwnerClientPhone() {
        return ownerClientPhone;
    }

    /**
     * 业主委托人联系方式
     */
    public void setOwnerClientPhone(String ownerClientPhone) {
        this.ownerClientPhone = ownerClientPhone;
    }
    /**
     * 投资主体
     */
    public Long getInvestor() {
        return investor;
    }

    /**
     * 投资主体
     */
    public void setInvestor(Long investor) {
        this.investor = investor;
    }
    /**
     * 投资主体名称
     */
    public String getInvestorName() {
        return investorName;
    }

    /**
     * 投资主体名称
     */
    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }
    /**
     * 资金来源
     */
    public Long getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源
     */
    public void setFundsSource(Long fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 资金来源
     */
    public String getFundsSourceName() {
        return fundsSourceName;
    }

    /**
     * 资金来源
     */
    public void setFundsSourceName(String fundsSourceName) {
        this.fundsSourceName = fundsSourceName;
    }
    /**
     * 投资金额
     */
    public java.math.BigDecimal getCostTotal() {
        return costTotal;
    }

    /**
     * 投资金额
     */
    public void setCostTotal(java.math.BigDecimal costTotal) {
        this.costTotal = costTotal;
    }
    /**
     * 招标形式
     */
    public Integer getBiddingForm() {
        return biddingForm;
    }

    /**
     * 招标形式
     */
    public void setBiddingForm(Integer biddingForm) {
        this.biddingForm = biddingForm;
    }
    /**
     * 开标日期
     */
    public java.util.Date getBiddingDate() {
        return biddingDate;
    }

    /**
     * 开标日期
     */
    public void setBiddingDate(java.util.Date biddingDate) {
        this.biddingDate = biddingDate;
    }
    /**
     * 投标范围
     */
    public String getBidScope() {
        return bidScope;
    }

    /**
     * 投标范围
     */
    public void setBidScope(String bidScope) {
        this.bidScope = bidScope;
    }
    /**
     * 计划工期
     */
    public java.math.BigDecimal getPlanDay() {
        return planDay;
    }

    /**
     * 计划工期
     */
    public void setPlanDay(java.math.BigDecimal planDay) {
        this.planDay = planDay;
    }
    /**
     * 工程类别
     */
    public Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类别
     */
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    /**
     * 工程类别
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类别
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 质量要求
     */
    public Long getQualityLeave() {
        return qualityLeave;
    }

    /**
     * 质量要求
     */
    public void setQualityLeave(Long qualityLeave) {
        this.qualityLeave = qualityLeave;
    }
    /**
     * 质量要求
     */
    public String getQualityLeaveName() {
        return qualityLeaveName;
    }

    /**
     * 质量要求
     */
    public void setQualityLeaveName(String qualityLeaveName) {
        this.qualityLeaveName = qualityLeaveName;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 是否中止1是0否
     */
    public Integer getIsStop() {
        return isStop;
    }

    /**
     * 是否中止1是0否
     */
    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }
    /**
     * 投标阶段1报名3预审5标前7投标评审9投标总结
     */
    public Integer getBidStage() {
        return bidStage;
    }

    /**
     * 投标阶段1报名3预审5标前7投标评审9投标总结
     */
    public void setBidStage(Integer bidStage) {
        this.bidStage = bidStage;
    }
    /**
     * 1新增0信息跟踪
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 1新增0信息跟踪
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 信息跟踪来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 信息跟踪来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    /**
     * 省份
     */
    public String getProvince() {
        return province;
    }

    /**
     * 省份
     */
    public void setProvince(String province) {
        this.province = province;
    }
    /**
     * 市
     */
    public String getCity() {
        return city;
    }

    /**
     * 市
     */
    public void setCity(String city) {
        this.city = city;
    }
    /**
     * 区县
     */
    public String getRegion() {
        return region;
    }

    /**
     * 区县
     */
    public void setRegion(String region) {
        this.region = region;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public java.util.Date getBillDate() {
        return billDate;
    }

    /**
     * 编制日期
     */
    public void setBillDate(java.util.Date billDate) {
        this.billDate = billDate;
    }

    public String getAdcode() {
        return adcode;
    }

    public void setAdcode(String adcode) {
        this.adcode = adcode;
    }

    /**
     * 开户银行
     */
    public String getDepositBank() {
        return depositBank;
    }
    /**
     * 开户银行
     */
    public void setDepositBank(String depositBank) {
        this.depositBank = depositBank;
    }
    /**
     * 开户名称
     */
    public String getAccountName() {
        return accountName;
    }
    /**
     * 开户名称
     */
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    /**
     * 开户账号
     */
    public String getAccountNumber() {
        return accountNumber;
    }
    /**
     * 开户账号
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }
    /**
     * 需支持项目(0：标书费，1:资政文件，2：其他)
     */
    public Integer getNeedSupportProject() {
        return needSupportProject;
    }
    /**
     * 需支持项目(0：标书费，1:资政文件，2：其他)
     */
    public void setNeedSupportProject(Integer needSupportProject) {
        this.needSupportProject = needSupportProject;
    }
    /**
     * 需支持项目信息
     */
    public String getNeedSupportProjectInfo() {
        return needSupportProjectInfo;
    }
    /**
     * 需支持项目信息
     */
    public void setNeedSupportProjectInfo(String needSupportProjectInfo) {
        this.needSupportProjectInfo = needSupportProjectInfo;
    }
    /**
     * 是否现金支付(0：否，1：是)
     */
    public Integer getCashDiscount() {
        return cashDiscount;
    }
    /**
     * 是否现金支付(0：否，1：是)
     */
    public void setCashDiscount(Integer cashDiscount) {
        this.cashDiscount = cashDiscount;
    }
    /**
     * 标书费用
     */
    public BigDecimal getTenderFee() {
        return tenderFee;
    }
    /**
     * 标书费用
     */
    public void setTenderFee(BigDecimal tenderFee) {
        this.tenderFee = tenderFee;
    }
    /**
     * 费用金额(大写）
     */
    public String getTenderFeeCapital() {
        return tenderFeeCapital;
    }
    /**
     * 费用金额(大写）
     */
    public void setTenderFeeCapital(String tenderFeeCapital) {
        this.tenderFeeCapital = tenderFeeCapital;
    }
    /**
     * 投标项目信息分析报告
     */
    public String getAnalysisReport() {
        return analysisReport;
    }
    /**
     * 投标项目信息分析报告
     */
    public void setAnalysisReport(String analysisReport) {
        this.analysisReport = analysisReport;
    }
    /**
     * 开投标项目信息分析报告id
     */
    public Long getAnalysisReportId() {
        return analysisReportId;
    }
    /**
     * 投标项目信息分析报告id
     */
    public void setAnalysisReportId(Long analysisReportId) {
        this.analysisReportId = analysisReportId;
    }
    /**
     * 经办部门id
     */
    public Long getDeptId() {
        return deptId;
    }
    /**
     * 经办部门id
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }
    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 经办部门code
     */
    public String getDeptCode() {
        return deptCode;
    }
    /**
     * 经办部门code
     */
    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }
}
