package com.ejianc.business.bid.bean;

import java.math.BigDecimal;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 投标信息跟踪
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_info_track")
public class InfoTrackEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="his_engineering_name")
    private String hisEngineeringName; // 历史工程名称
    @TableField(value="info_source")
    private Long infoSource; // 信息来源
    @TableField(value="info_source_name")
    private String infoSourceName; // 信息来源名称
    @TableField(value="follow_unit")
    private Long followUnit; // 跟踪单位
    @TableField(value="follow_unit_name")
    private String followUnitName; // 跟踪单位名称
    @TableField(value="unit_director")
    private Long unitDirector; // 单位负责人
    @TableField(value="unit_director_name")
    private String unitDirectorName; // 单位负责人名称
    @TableField(value="unit_director_phone")
    private String unitDirectorPhone; // 单位负责人联系方式
    @TableField(value="bidding_agency")
    private String biddingAgency; // 招标代理机构
    @TableField(value="project_bid_manage")
    private Long projectBidManage; // 项目投标主管
    @TableField(value="project_bid_manage_name")
    private String projectBidManageName; // 项目投标主管名称
    @TableField(value="project_bid_manage_phone")
    private String projectBidManagePhone; // 项目投标主管联系方式
    @TableField(value="follow_state")
    private Integer followState; // 跟踪状态(1:跟踪中，2：已报名，0：已结束)
    @TableField(value="address")
    private String address; // 工程地点
    @TableField(value = "area")
    private String area;//地区
    @TableField(value="province")
    private String province; // 省份
    @TableField(value="city")
    private String city; // 市
    @TableField(value="region")
    private String region; // 区县
    @TableField(value="construction_unit")
    private Long constructionUnit; // 建设单位
    @TableField(value="construction_unit_name")
    private String constructionUnitName; // 建设单位名称
    @TableField(value="owner_entrust")
    private String ownerEntrust; // 业主委托人
    @TableField(value="owner_entrust_phone")
    private String ownerEntrustPhone; // 业主委托人联系方式
    @TableField(value="funds_source")
    private Long fundsSource; // 资金来源
    @TableField(value="funds_source_name")
    private String fundsSourceName; // 资金来源名称
    @TableField(value="bidding_form")
    private Integer biddingForm; // 招标形式
    @TableField(value="bid_range")
    private String bidRange; // 投标范围
    @TableField(value="engineering_type")
    private Long engineeringType; // 工程类别
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类别名称
    @TableField(value="plan_duration")
    private BigDecimal planDuration; // 计划工期
    @TableField(value="investor_amount")
    private BigDecimal investorAmount; // 投资金额
    @TableField(value="the_investment_amount")
    private BigDecimal theInvestmentAmount; // 本次项目投资金额
    @TableField(value="estimated_bidding_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimatedBiddingDate; // 预计招标日期
    @TableField(value="project_overview")
    private String projectOverview; // 工程概况
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="employee_id")
    private Long employeeId;//编制人
    @TableField(value="employee_name")
    private String employeeName;//编制人名称
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;//编制时间
    @TableField(value="sign_up_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signUpDate; // 报名日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="is_stop")
    private Integer isStop; // 是否中止1是0否

    @TableField(value="org_code")
    private String orgCode; // 所属组织编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 历史工程名称
     */
    public String getHisEngineeringName() {
        return hisEngineeringName;
    }
    /**
     * 历史工程名称
     */
    public void setHisEngineeringName(String hisEngineeringName) {
        this.hisEngineeringName = hisEngineeringName;
    }

    /**
     * 信息来源
     */
    public Long getInfoSource() {
        return infoSource;
    }

    /**
     * 信息来源
     */
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    /**
     * 信息来源名称
     */
    public String getInfoSourceName() {
        return infoSourceName;
    }

    /**
     * 信息来源名称
     */
    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }
    /**
     * 跟踪单位
     */
    public Long getFollowUnit() {
        return followUnit;
    }

    /**
     * 跟踪单位
     */
    public void setFollowUnit(Long followUnit) {
        this.followUnit = followUnit;
    }
    /**
     * 跟踪单位名称
     */
    public String getFollowUnitName() {
        return followUnitName;
    }

    /**
     * 跟踪单位名称
     */
    public void setFollowUnitName(String followUnitName) {
        this.followUnitName = followUnitName;
    }
    /**
     * 单位负责人
     */
    public Long getUnitDirector() {
        return unitDirector;
    }

    /**
     * 单位负责人
     */
    public void setUnitDirector(Long unitDirector) {
        this.unitDirector = unitDirector;
    }
    /**
     * 单位负责人名称
     */
    public String getUnitDirectorName() {
        return unitDirectorName;
    }
    /**
     * 单位负责人名称
     */
    public void setUnitDirectorName(String unitDirectorName) {
        this.unitDirectorName = unitDirectorName;
    }

    /**
     * 单位负责人联系方式
     */
    public String getUnitDirectorPhone() {
        return unitDirectorPhone;
    }

    /**
     * 单位负责人联系方式
     */
    public void setUnitDirectorPhone(String unitDirectorPhone) {
        this.unitDirectorPhone = unitDirectorPhone;
    }
    /**
     * 招标代理机构
     */
    public String getBiddingAgency() {
        return biddingAgency;
    }

    /**
     * 招标代理机构
     */
    public void setBiddingAgency(String biddingAgency) {
        this.biddingAgency = biddingAgency;
    }
    /**
     * 项目投标主管
     */
    public Long getProjectBidManage() {
        return projectBidManage;
    }

    /**
     * 项目投标主管
     */
    public void setProjectBidManage(Long projectBidManage) {
        this.projectBidManage = projectBidManage;
    }

    /**
     * 项目投标主管名称
     */
    public String getProjectBidManageName() {
        return projectBidManageName;
    }
    /**
     * 项目投标主管名称
     */
    public void setProjectBidManageName(String projectBidManageName) {
        this.projectBidManageName = projectBidManageName;
    }

    /**
     * 项目投标主管联系方式
     */
    public String getProjectBidManagePhone() {
        return projectBidManagePhone;
    }

    /**
     * 项目投标主管联系方式
     */
    public void setProjectBidManagePhone(String projectBidManagePhone) {
        this.projectBidManagePhone = projectBidManagePhone;
    }
    /**
     * 跟踪状态(1:跟踪中，2：已报名，0：已结束)
     */
    public Integer getFollowState() {
        return followState;
    }

    /**
     * 跟踪状态(1:跟踪中，2：已报名，0：已结束)
     */
    public void setFollowState(Integer followState) {
        this.followState = followState;
    }
    /**
     * 工程地点
     */
    public String getAddress() {
        return address;
    }

    /**
     * 工程地点
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 地区
     */
    public String getArea() {
        return area;
    }
    /**
     * 地区
     */
    public void setArea(String area) {
        this.area = area;
    }

    /**
     * 省份
     */
    public String getProvince() {
        return province;
    }

    /**
     * 省份
     */
    public void setProvince(String province) {
        this.province = province;
    }
    /**
     * 市
     */
    public String getCity() {
        return city;
    }

    /**
     * 市
     */
    public void setCity(String city) {
        this.city = city;
    }
    /**
     * 区县
     */
    public String getRegion() {
        return region;
    }

    /**
     * 区县
     */
    public void setRegion(String region) {
        this.region = region;
    }
    /**
     * 建设单位
     */
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    /**
     * 建设单位
     */
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    /**
     * 建设单位名称
     */
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    /**
     * 建设单位名称
     */
    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }
    /**
     * 业主委托人
     */
    public String getOwnerEntrust() {
        return ownerEntrust;
    }

    /**
     * 业主委托人
     */
    public void setOwnerEntrust(String ownerEntrust) {
        this.ownerEntrust = ownerEntrust;
    }
    /**
     * 业主委托人联系方式
     */
    public String getOwnerEntrustPhone() {
        return ownerEntrustPhone;
    }

    /**
     * 业主委托人联系方式
     */
    public void setOwnerEntrustPhone(String ownerEntrustPhone) {
        this.ownerEntrustPhone = ownerEntrustPhone;
    }
    /**
     * 资金来源
     */
    public Long getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源
     */
    public void setFundsSource(Long fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 资金来源名称
     */
    public String getFundsSourceName() {
        return fundsSourceName;
    }

    public void setFundsSourceName(String fundsSourceName) {
        this.fundsSourceName = fundsSourceName;
    }

    /**
     * 招标形式
     */
    public Integer getBiddingForm() {
        return biddingForm;
    }

    /**
     * 招标形式
     */
    public void setBiddingForm(Integer biddingForm) {
        this.biddingForm = biddingForm;
    }

    /**
     * 投标范围
     */
    public String getBidRange() {
        return bidRange;
    }

    /**
     * 投标范围
     */
    public void setBidRange(String bidRange) {
        this.bidRange = bidRange;
    }
    /**
     * 工程类别
     */
    public Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类别
     */
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    /**
     * 工程类别名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类别名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 计划工期
     */
    public BigDecimal getPlanDuration() {
        return planDuration;
    }

    /**
     * 计划工期
     */
    public void setPlanDuration(BigDecimal planDuration) {
        this.planDuration = planDuration;
    }
    /**
     * 投资金额
     */
    public BigDecimal getInvestorAmount() {
        return investorAmount;
    }

    /**
     * 投资金额
     */
    public void setInvestorAmount(BigDecimal investorAmount) {
        this.investorAmount = investorAmount;
    }
    /**
     * 本次项目投资金额
     */
    public BigDecimal getTheInvestmentAmount() {
        return theInvestmentAmount;
    }

    /**
     * 本次项目投资金额
     */
    public void setTheInvestmentAmount(BigDecimal theInvestmentAmount) {
        this.theInvestmentAmount = theInvestmentAmount;
    }
    /**
     * 预计招标日期
     */
    public Date getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    /**
     * 预计招标日期
     */
    public void setEstimatedBiddingDate(Date estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }
    /**
     * 工程概况
     */
    public String getProjectOverview() {
        return projectOverview;
    }

    /**
     * 工程概况
     */
    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人姓名
     */
    public String getEmployeeName() {
        return employeeName;
    }
    /**
     * 编制人姓名
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public Date getBillDate() {
        return billDate;
    }
    /**
     * 编制日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 报名日期
     */
    public Date getSignUpDate() {
        return signUpDate;
    }

    /**
     * 报名日期
     */
    public void setSignUpDate(Date signUpDate) {
        this.signUpDate = signUpDate;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 是否中止1是0否
     */
    public Integer getIsStop() {
        return isStop;
    }
    /**
     * 是否中止1是0否
     */
    public void setIsStop(Integer isStop) {
        this.isStop = isStop;
    }
}
