package com.ejianc.business.bid.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 *   投标总结 
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_summary")
public class SummaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="org_code")
    private String orgCode;
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="enroll_id")
    private Long enrollId; // 工程id
    @TableField(value="engineering_code")
    private String engineeringCode; // 工程编码
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="open_tender_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date openTenderDate; // 开标日期(格式：yyyy-mm-dd)
    @TableField(value="bid_evaluation_id")
    private Long bidEvaluationId; // 评标办法id  (自定义档案)
    @TableField(value="bid_evaluation_method")
    private String bidEvaluationMethod; // 评标办法
    @TableField(value="project_leader")
    private String projectLeader; // 项目负责人
    @TableField(value="architect")
    private String architect; // 建造师
    @TableField(value="bid_result")
    private Integer bidResult; // 投标结果 0 已中标 1 未中标
    @TableField(value="bid_winner_id")
    private Long bidWinnerId; // 中标单位id
    @TableField(value="bid_winner")
    private String bidWinner; // 中标单位
    @TableField(value="bid_opening_place")
    private String bidOpeningPlace; // 开标地点
    @TableField(value="win_bidding_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date winBiddingDate; // 中标日期(格式：yyyy-mm-dd)
    @TableField(value="quotation_form")
    private Integer quotationForm; // 报价形式 0:总价 1:费率
    @TableField(value="bid_mmy")
    private BigDecimal bidMmy; // 中标金额  （单位万元）
    @TableField(value="bidding_control_mmy")
    private BigDecimal biddingControlMmy; // 招标控制价（单位万元）
    @TableField(value="quote_lower_rate")
    private BigDecimal quoteLowerRate; // 报价下浮率（控制价）%
    @TableField(value="bid_quotation_rate")
    private BigDecimal bidQuotationRate; // 投标报价费率
    @TableField(value="bidding_control_rate")
    private BigDecimal biddingControlRate; // 招标控制价费率
    @TableField(value="control_quote_lower_rate")
    private BigDecimal controlQuoteLowerRate; // 报价下浮率（控制价）%
    @TableField(value="duration")
    private BigDecimal duration; // 工期
    @TableField(value="bid_unit_id")
    private Long bidUnitId; // 投标单位id
    @TableField(value="bid_unit")
    private String bidUnit; // 投标单位
    @TableField(value="bidding_agent")
    private String biddingAgent; // 投标代理人
    @TableField(value="unit_leader_id")
    private Long unitLeaderId; // 单位负责人id
    @TableField(value="unit_leader")
    private String unitLeader; // 单位负责人
    @TableField(value="quality_target")
    private String qualityTarget; // 质量目标
    @TableField(value="bid_section_number")
    private Integer bidSectionNumber; // 投标标段数量
    @TableField(value="bid_winning_section")
    private String bidWinningSection; // 中标标段
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="notification_status")
    private Integer notificationStatus; // 中标通知书返回状态 0 未选择 1 选择
    @TableField(value="bid_winner_news")
    private String bidWinnerNews; // 中标单位信息
    @TableField(value="is_bid_winning")
    private Integer isBidWinning; // 是否中标
    @TableField(value="use_flag")
    private Integer useFlag; // 项目立项是否使用 1 是 0 否
    @TableField(value="built_constructor_id")
    private Long builtConstructorId; // 建造师id
    @TableField(value="bid_quotation_mny")
    private BigDecimal bidQuotationMny; // 投标报价金额
    @TableField(value="bid_winner_lower_rate")
    private BigDecimal bidWinnerLowerRate; // 中标下浮率
    @TableField(value="bid_winning_rate")
    private BigDecimal bidWinningRate; // 中标率

    //add by ding
    @TableField(value="project_leave")
    private Long projectLeave; // 项目级别(自定义档案)
    @TableField(value="qualification")
    private String qualification; // 中标资质(自定义档案)
    @TableField(value="classification_type")
    private Long classificationType; // 建设单位分类(自定义档案)
    @TableField(value="quyu")
    private Long quyu; // 区域(自定义档案)
    @TableField(value="def1")
    private String def1; // 自定义字段1
    @TableField(value="def2")
    private String def2; // 自定义字段2
    @TableField(value="def3")
    private String def3; // 自定义字段3
    @TableField(value="def4")
    private String def4; // 自定义字段4
    @TableField(value="def5")
    private String def5; // 自定义字段5
    @TableField(value="deposit_bank")

    private String depositBank; // 开户银行
    @TableField(value="account_name")
    private String accountName; // 开户名称
    @TableField(value="account_number")
    private String accountNumber; // 开户账号
    @TableField(value="need_support_project")
    private Integer needSupportProject; // 需支持项目(0：标书费，1:资政文件，2：其他)
    @TableField(value="need_support_project_info")
    private String needSupportProjectInfo; // 需支持项目信息
    @TableField(value="cash_discount")
    private Integer cashDiscount; // 是否现金支付(0：否，1：是)
    @TableField(value="tender_fee")
    private BigDecimal tenderFee; // 标书费用
    @TableField(value="tender_fee_capital")
    private String tenderFeeCapital; // 费用金额(大写）
    @TableField(value="analysis_report")
    private String analysisReport; // 投标项目信息分析报告
    @TableField(value="analysis_report_id")
    private Long analysisReportId; // 投标项目信息分析报告id
    @TableField(value="dept_id")
    private Long deptId; // 经办部门id
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="dept_code")
    private String deptCode; // 经办部门code
    @TableField(value="follow_person")
    private Long followPerson; // 项目联系人
    @TableField(value="follow_person_name")
    private String followPersonName; // 项目联系人名称
    @TableField(value="follow_person_phone")
    private String followPersonPhone; // 项目联系人电话
    @TableField(value="project_manager")
    private Long projectManager; // 申请人员
    @TableField(value="project_manager_name")
    private String projectManagerName; // 申请人员名称
    @TableField(value="project_manager_phone")
    private String projectManagerPhone; // 申请人员电话
    @TableField(value="publish_date")
    private Date publishDate; // 经办日期
    @TableField(value="bid_org_id")
    private Long bidOrgId; // 申请单位
    @TableField(value="bid_org_name")
    private String bidOrgName; // 申请单位名称
    @TableField(value="sign_date")
    private Date signDate; // 申请日期
    @TableField(value="review_date")
    private Date reviewDate; // 评审日期
    @TableField(value="address")
    private String address; // 工程地点
    @TableField(value="construction_unit")
    private Long constructionUnit; // 建设单位
    @TableField(value="construction_unit_name")
    private String constructionUnitName; // 建设单位名称
    @TableField(value="engineering_type")
    private Long engineeringType; // 工程类型
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类型名称
    @TableField(value="bidding_agency")
    private String biddingAgency; // 招标代理机构
    @TableField(value="quotation_way")
    private String quotationWay; // 报价方式
    @TableField(value="area")
    private String area; // 地区
    @TableField(value="quotation_way_id")
    private Long quotationWayId; // 报价方式id


    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }
    /**
     * 所属组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程id
     */
    public Long getEnrollId() {
        return enrollId;
    }

    /**
     * 工程id
     */
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }

    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 开标日期(格式：yyyy-mm-dd)
     */
    public java.util.Date getOpenTenderDate() {
        return openTenderDate;
    }

    /**
     * 开标日期(格式：yyyy-mm-dd)
     */
    public void setOpenTenderDate(java.util.Date openTenderDate) {
        this.openTenderDate = openTenderDate;
    }
    /**
     * 评标办法id  (自定义档案)
     */
    public Long getBidEvaluationId() {
        return bidEvaluationId;
    }

    /**
     * 评标办法id  (自定义档案)
     */
    public void setBidEvaluationId(Long bidEvaluationId) {
        this.bidEvaluationId = bidEvaluationId;
    }
    /**
     * 评标办法  
     */
    public String getBidEvaluationMethod() {
        return bidEvaluationMethod;
    }

    /**
     * 评标办法  
     */
    public void setBidEvaluationMethod(String bidEvaluationMethod) {
        this.bidEvaluationMethod = bidEvaluationMethod;
    }
    /**
     * 项目负责人
     */
    public String getProjectLeader() {
        return projectLeader;
    }

    /**
     * 项目负责人
     */
    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    /**
     * 建造师
     */
    public String getArchitect() {
        return architect;
    }
    /**
     * 建造师
     */
    public void setArchitect(String architect) {
        this.architect = architect;
    }

    /**
     * 投标结果 0 已中标 1 未中标
     */
    public Integer getBidResult() {
        return bidResult;
    }

    /**
     * 投标结果 0 已中标 1 未中标
     */
    public void setBidResult(Integer bidResult) {
        this.bidResult = bidResult;
    }
    /**
     * 中标单位id
     */
    public Long getBidWinnerId() {
        return bidWinnerId;
    }

    /**
     * 中标单位id
     */
    public void setBidWinnerId(Long bidWinnerId) {
        this.bidWinnerId = bidWinnerId;
    }
    /**
     * 中标单位
     */
    public String getBidWinner() {
        return bidWinner;
    }

    /**
     * 中标单位
     */
    public void setBidWinner(String bidWinner) {
        this.bidWinner = bidWinner;
    }
    /**
     * 开标地点
     */
    public String getBidOpeningPlace() {
        return bidOpeningPlace;
    }

    /**
     * 开标地点
     */
    public void setBidOpeningPlace(String bidOpeningPlace) {
        this.bidOpeningPlace = bidOpeningPlace;
    }
    /**
     * 中标日期(格式：yyyy-mm-dd)
     */
    public java.util.Date getWinBiddingDate() {
        return winBiddingDate;
    }

    /**
     * 中标日期(格式：yyyy-mm-dd)
     */
    public void setWinBiddingDate(java.util.Date winBiddingDate) {
        this.winBiddingDate = winBiddingDate;
    }
    /**
     * 报价形式 0:总价 1:费率
     */
    public Integer getQuotationForm() {
        return quotationForm;
    }

    /**
     * 报价形式 0:总价 1:费率
     */
    public void setQuotationForm(Integer quotationForm) {
        this.quotationForm = quotationForm;
    }
    /**
     * 中标金额  （单位万元）
     */
    public BigDecimal getBidMmy() {
        return bidMmy;
    }

    /**
     * 中标金额  （单位万元）
     */
    public void setBidMmy(BigDecimal bidMmy) {
        this.bidMmy = bidMmy;
    }
    /**
     * 招标控制价（单位万元）
     */
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    /**
     * 招标控制价（单位万元）
     */
    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    /**
     * 报价下浮率（控制价）% 
     */
    public BigDecimal getQuoteLowerRate() {
        return quoteLowerRate;
    }

    /**
     * 报价下浮率（控制价）% 
     */
    public void setQuoteLowerRate(BigDecimal quoteLowerRate) {
        this.quoteLowerRate = quoteLowerRate;
    }
    /**
     * 投标报价费率 
     */
    public BigDecimal getBidQuotationRate() {
        return bidQuotationRate;
    }

    /**
     * 投标报价费率 
     */
    public void setBidQuotationRate(BigDecimal bidQuotationRate) {
        this.bidQuotationRate = bidQuotationRate;
    }
    /**
     * 招标控制价费率
     */
    public BigDecimal getBiddingControlRate() {
        return biddingControlRate;
    }

    /**
     * 招标控制价费率
     */
    public void setBiddingControlRate(BigDecimal biddingControlRate) {
        this.biddingControlRate = biddingControlRate;
    }
    /**
     * 报价下浮率（控制价）%
     */
    public BigDecimal getControlQuoteLowerRate() {
        return controlQuoteLowerRate;
    }

    /**
     * 报价下浮率（控制价）%
     */
    public void setControlQuoteLowerRate(BigDecimal controlQuoteLowerRate) {
        this.controlQuoteLowerRate = controlQuoteLowerRate;
    }
    /**
     * 工期
     */

    public BigDecimal getDuration() {
        return duration;
    }

    /**
     * 工期
     */
    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    /**
     * 投标单位id
     */
    public Long getBidUnitId() {
        return bidUnitId;
    }

    /**
     * 投标单位id
     */
    public void setBidUnitId(Long bidUnitId) {
        this.bidUnitId = bidUnitId;
    }
    /**
     * 投标单位
     */
    public String getBidUnit() {
        return bidUnit;
    }

    /**
     * 投标单位
     */
    public void setBidUnit(String bidUnit) {
        this.bidUnit = bidUnit;
    }
    /**
     * 投标代理人
     */
    public String getBiddingAgent() {
        return biddingAgent;
    }
    /**
     * 投标代理人
     */
    public void setBiddingAgent(String biddingAgent) {
        this.biddingAgent = biddingAgent;
    }

    /**
     * 单位负责人id
     */
    public Long getUnitLeaderId() {
        return unitLeaderId;
    }

    /**
     * 单位负责人id
     */
    public void setUnitLeaderId(Long unitLeaderId) {
        this.unitLeaderId = unitLeaderId;
    }
    /**
     * 单位负责人
     */
    public String getUnitLeader() {
        return unitLeader;
    }

    /**
     * 单位负责人
     */
    public void setUnitLeader(String unitLeader) {
        this.unitLeader = unitLeader;
    }
    /**
     * 质量目标
     */
    public String getQualityTarget() {
        return qualityTarget;
    }

    /**
     * 质量目标
     */
    public void setQualityTarget(String qualityTarget) {
        this.qualityTarget = qualityTarget;
    }
    /**
     * 投标标段数量
     */
    public Integer getBidSectionNumber() {
        return bidSectionNumber;
    }

    /**
     * 投标标段数量
     */
    public void setBidSectionNumber(Integer bidSectionNumber) {
        this.bidSectionNumber = bidSectionNumber;
    }
    /**
     * 中标标段
     */

    public String getBidWinningSection() {
        return bidWinningSection;
    }

    /**
     * 中标标段
     */
    public void setBidWinningSection(String bidWinningSection) {
        this.bidWinningSection = bidWinningSection;
    }

    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 中标通知书返回状态 0 未选择 1 选择
     */
    public Integer getNotificationStatus() {
        return notificationStatus;
    }

    /**
     * 中标通知书返回状态 0 未选择 1 选择
     */
    public void setNotificationStatus(Integer notificationStatus) {
        this.notificationStatus = notificationStatus;
    }
    /**
     * 中标单位信息
     */
    public String getBidWinnerNews() {
        return bidWinnerNews;
    }

    /**
     * 中标单位信息
     */
    public void setBidWinnerNews(String bidWinnerNews) {
        this.bidWinnerNews = bidWinnerNews;
    }
    /**
     * 是否中标
     */
    public Integer getIsBidWinning() {
        return isBidWinning;
    }

    /**
     * 是否中标
     */
    public void setIsBidWinning(Integer isBidWinning) {
        this.isBidWinning = isBidWinning;
    }
    /**
     * 是否被项目立项使用
     */
    public Integer getUseFlag() {
        return useFlag;
    }
    /**
     * 是否被项目立项使用
     */
    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
    public Long getBuiltConstructorId() {
        return builtConstructorId;
    }

    public void setBuiltConstructorId(Long builtConstructorId) {
        this.builtConstructorId = builtConstructorId;
    }

    public BigDecimal getBidQuotationMny() {
        return bidQuotationMny;
    }

    public void setBidQuotationMny(BigDecimal bidQuotationMny) {
        this.bidQuotationMny = bidQuotationMny;
    }

    public BigDecimal getBidWinnerLowerRate() {
        return bidWinnerLowerRate;
    }

    public void setBidWinnerLowerRate(BigDecimal bidWinnerLowerRate) {
        this.bidWinnerLowerRate = bidWinnerLowerRate;
    }

    public BigDecimal getBidWinningRate() {
        return bidWinningRate;
    }

    public void setBidWinningRate(BigDecimal bidWinningRate) {
        this.bidWinningRate = bidWinningRate;
    }

    public Long getProjectLeave() {
        return projectLeave;
    }

    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }

    public String getQualification() {
        return qualification;
    }

    public void setQualification(String qualification) {
        this.qualification = qualification;
    }

    public Long getClassificationType() {
        return classificationType;
    }

    public void setClassificationType(Long classificationType) {
        this.classificationType = classificationType;
    }

    public Long getQuyu() {
        return quyu;
    }

    public void setQuyu(Long quyu) {
        this.quyu = quyu;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getDepositBank() {
        return depositBank;
    }

    public void setDepositBank(String depositBank) {
        this.depositBank = depositBank;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Integer getNeedSupportProject() {
        return needSupportProject;
    }

    public void setNeedSupportProject(Integer needSupportProject) {
        this.needSupportProject = needSupportProject;
    }

    public String getNeedSupportProjectInfo() {
        return needSupportProjectInfo;
    }

    public void setNeedSupportProjectInfo(String needSupportProjectInfo) {
        this.needSupportProjectInfo = needSupportProjectInfo;
    }

    public Integer getCashDiscount() {
        return cashDiscount;
    }

    public void setCashDiscount(Integer cashDiscount) {
        this.cashDiscount = cashDiscount;
    }

    public BigDecimal getTenderFee() {
        return tenderFee;
    }

    public void setTenderFee(BigDecimal tenderFee) {
        this.tenderFee = tenderFee;
    }

    public String getTenderFeeCapital() {
        return tenderFeeCapital;
    }

    public void setTenderFeeCapital(String tenderFeeCapital) {
        this.tenderFeeCapital = tenderFeeCapital;
    }

    public String getAnalysisReport() {
        return analysisReport;
    }

    public void setAnalysisReport(String analysisReport) {
        this.analysisReport = analysisReport;
    }

    public Long getAnalysisReportId() {
        return analysisReportId;
    }

    public void setAnalysisReportId(Long analysisReportId) {
        this.analysisReportId = analysisReportId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getDeptCode() {
        return deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public Long getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(Long followPerson) {
        this.followPerson = followPerson;
    }

    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProjectManagerPhone() {
        return projectManagerPhone;
    }

    public void setProjectManagerPhone(String projectManagerPhone) {
        this.projectManagerPhone = projectManagerPhone;
    }

    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Long getBidOrgId() {
        return bidOrgId;
    }

    public void setBidOrgId(Long bidOrgId) {
        this.bidOrgId = bidOrgId;
    }

    public String getBidOrgName() {
        return bidOrgName;
    }

    public void setBidOrgName(String bidOrgName) {
        this.bidOrgName = bidOrgName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getBiddingAgency() {
        return biddingAgency;
    }

    public void setBiddingAgency(String biddingAgency) {
        this.biddingAgency = biddingAgency;
    }

    public String getQuotationWay() {
        return quotationWay;
    }

    public void setQuotationWay(String quotationWay) {
        this.quotationWay = quotationWay;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public Long getQuotationWayId() {
        return quotationWayId;
    }

    public void setQuotationWayId(Long quotationWayId) {
        this.quotationWayId = quotationWayId;
    }
}
