package com.ejianc.business.bid.controller.external;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Controller
@RequestMapping("statistic")
public class StatisticController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBidFileReviewBisService bidFileReviewBisService;
    @Autowired
    private IBidFileReviewTecService bidFileReviewTecService;
    @Autowired
    private IBidFileReviewValueService bidFileReviewValueService;

    /**
     * @param timeFlag
     * @Description getBidState 投标状态
     */
    @RequestMapping(value = "/getBidState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidState(String timeFlag, Long orgId) {
        List<ResultVO> resultVOS = new ArrayList<>();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = orgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        // 项目投标信息-数量
        QueryWrapper<EnrollEntity> enrollWrapper = new QueryWrapper<>();
        enrollWrapper.in("org_id", orgIdList);
        enrollWrapper.eq("dr", 0);
        if ("thisYear".equals(timeFlag)) {
            enrollWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            enrollWrapper.eq("YEAR(create_time)", DateUtil.getYear());
        } else {
            //查询全部，
            enrollWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int entrollCount = enrollService.count(enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("项目投标信息", entrollCount);

        // 招标文件评审-数量
        QueryWrapper<BiddingFileReviewEntity> biddingFileReviewWrapper = new QueryWrapper<>();
        biddingFileReviewWrapper.in("org_id", orgIdList);
        biddingFileReviewWrapper.eq("dr", 0);
        if ("thisYear".equals(timeFlag)) {
            biddingFileReviewWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            biddingFileReviewWrapper.eq("YEAR(create_time)", DateUtil.getYear());
        } else {
            //查询全部，
            biddingFileReviewWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int biddingFileReviewCount = biddingFileReviewService.count(biddingFileReviewWrapper);
        ResultVO biddingFileReviewResultVO = new ResultVO("招标文件评审", biddingFileReviewCount);

        // 投标文件评审(商务标)-数量
        QueryWrapper<BidFileReviewBisEntity> bidFileReviewWrapper = new QueryWrapper<>();
        bidFileReviewWrapper.in("org_id", orgIdList);
        bidFileReviewWrapper.eq("dr", 0);
        if ("thisYear".equals(timeFlag)) {
            bidFileReviewWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            bidFileReviewWrapper.eq("YEAR(create_time)", DateUtil.getYear());
        } else {
            //查询全部，
            bidFileReviewWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int bidFileReviewCount = bidFileReviewBisService.count(bidFileReviewWrapper);
        // 投标文件评审(技术标)-数量
        QueryWrapper<BidFileReviewTecEntity> bidFileReviewTecWrapper = new QueryWrapper<>();
        bidFileReviewTecWrapper.in("org_id", orgIdList);
        bidFileReviewTecWrapper.eq("dr", 0);
        if ("thisYear".equals(timeFlag)) {
            bidFileReviewTecWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            bidFileReviewTecWrapper.eq("YEAR(create_time)", DateUtil.getYear());
        } else {
            //查询全部，
            bidFileReviewTecWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int bidFileReviewTecCount = bidFileReviewTecService.count(bidFileReviewTecWrapper);
        // 投标文件评审（价格标）-数量
        QueryWrapper<BidFileReviewValueEntity> bidFileReviewValueWrapper = new QueryWrapper<>();
        bidFileReviewValueWrapper.in("org_id", orgIdList);
        bidFileReviewValueWrapper.eq("dr", 0);
        if ("thisYear".equals(timeFlag)) {
            bidFileReviewValueWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            bidFileReviewValueWrapper.eq("YEAR(create_time)", DateUtil.getYear());
        } else {
            //查询全部，
            bidFileReviewValueWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int bidFileReviewValueCount = bidFileReviewValueService.count(bidFileReviewValueWrapper);
        ResultVO zbResultVO = new ResultVO("投标文件评审", bidFileReviewCount + bidFileReviewTecCount + bidFileReviewValueCount);


        // 投标总结-数量
        QueryWrapper<SummaryEntity> summaryWrapper = new QueryWrapper<>();
        summaryWrapper.in("org_id", orgIdList);
        summaryWrapper.eq("dr", 0);
        if ("thisYear".equals(timeFlag)) {
            summaryWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            summaryWrapper.eq("YEAR(create_time)", DateUtil.getYear());
            summaryWrapper.eq("bid_result", 0);
        } else {
            //查询全部，
            summaryWrapper.eq("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode());
            summaryWrapper.eq("bid_result", 0);
        }
        int summaryCount = summaryService.count(summaryWrapper);
        ResultVO summaryResultVO = new ResultVO("中标", summaryCount);


        resultVOS.add(enrollResultVO);
        resultVOS.add(biddingFileReviewResultVO);
        resultVOS.add(zbResultVO);
        resultVOS.add(summaryResultVO);
        return CommonResponse.success(resultVOS);
    }

    /**
     * @param timeFlag
     * @Description getBidSurvey 投标统计
     */
    @RequestMapping(value = "/getBidSurvey", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidSurvey(String timeFlag, Long orgId) {
        List<ResultVO> resultVOS = new ArrayList<>();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = orgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        // 投标总数
        List<EnrollEntity> enrollList = new ArrayList<>();
        QueryWrapper<EnrollEntity> enrollWrapper = new QueryWrapper<>();
        enrollWrapper.in("org_id", orgIdList);
        enrollWrapper.eq("thisYear".equals(timeFlag), "YEAR(sign_date)", DateUtil.getYear());
        enrollList = enrollService.list(enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("投标总数", enrollList.size());

        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6);
        LocalDate afterOneMonthDay = today.plusDays(29);
        // 近一月预计开标数
        QueryWrapper<EnrollEntity> monthWrapper = new QueryWrapper<>();
        monthWrapper.in("org_id", orgIdList);
        monthWrapper.eq("bid_state", BidStateEnum.JIN_XING_ZHONG.getCode());
        monthWrapper.ge("bidding_date", today.toString());
        monthWrapper.le("bidding_date", afterOneMonthDay.toString());
        int count1 = enrollService.count(monthWrapper);
        ResultVO collectResultVO = new ResultVO("近一月预计开标数", count1);

        // 近一周预计开标数
        QueryWrapper<EnrollEntity> weekWrapper = new QueryWrapper<>();
        weekWrapper.in("org_id", orgIdList);
        weekWrapper.eq("bid_state", BidStateEnum.JIN_XING_ZHONG.getCode());
        weekWrapper.ge("bidding_date", today.toString());
        weekWrapper.le("bidding_date", afterOneWeekDay.toString());
        int count2 = enrollService.count(weekWrapper);
        ResultVO weekResultVO = new ResultVO("近一周预计开标数", count2);

        // 中标数
        List<Long> enrollIds = new ArrayList<>();
        Integer bidSumNum = 0;
        for (EnrollEntity enroll : enrollList) {
            enrollIds.add(enroll.getId());
            Integer bidNum = enroll.getBidNum() != null ? enroll.getBidNum() : 0;
            bidSumNum += bidNum;
        }
        int count = 0;
        if (CollectionUtils.isNotEmpty(enrollIds)) {
            QueryWrapper<SummaryEntity> summaryWrapper = new QueryWrapper<>();
            summaryWrapper.in("org_id", orgIdList);
            summaryWrapper.eq("bid_result", 0);
            summaryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            summaryWrapper.in("enroll_id", enrollIds);
            count = summaryService.count(summaryWrapper);
        }
        ResultVO summaryResultVO = new ResultVO("中标数", count);
        ResultVO bidSumNumVO = new ResultVO("投标总标段数", bidSumNum);

        resultVOS.add(bidSumNumVO);
        resultVOS.add(summaryResultVO);
        resultVOS.add(collectResultVO);
        resultVOS.add(weekResultVO);
        resultVOS.add(enrollResultVO);
        return CommonResponse.success(resultVOS);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6);
        LocalDate afterOneMonthDay = today.plusDays(29);
        System.out.println(today);
        System.out.println(afterOneMonthDay);
        System.out.println(afterOneWeekDay);
    }

}
