package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.vo.CalockUseDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.CalockUseDetailMapper;
import com.ejianc.business.bid.bean.CalockUseDetailEntity;
import com.ejianc.business.bid.service.ICalockUseDetailService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * CA锁使用登记明细
 * 
 * @author generator
 * 
 */
@Service("calockUseDetailService")
public class CalockUseDetailServiceImpl extends BaseServiceImpl<CalockUseDetailMapper, CalockUseDetailEntity> implements ICalockUseDetailService{

    @Autowired
    CalockUseDetailMapper calockUseDetailMapper;
    /**
     * 根据主表单编码删除子表明细
     *
     * @param billCode
     * @return
     * @throws Exception
     */
    @Override
    public void deleteCalockUseDetailListByBillCode(String billCode) throws Exception {
        if(StringUtils.isNotEmpty(billCode)){
            HashMap param = new HashMap<String,String>();
            param.put("billCode",billCode);
            calockUseDetailMapper.deleteCalockUseDetailListByBillCode(param);
        }
    }

    /**
     * 根据主表单编码查询子表明细
     *
     * @param param
     * @return
     * @throws Exception
     */
    @Override
    public List<CalockUseDetailEntity> getCalockUseDetailListByBillCode(CalockUseDetailEntity param) throws Exception {
        if(param == null || StringUtils.isNotEmpty(param.getBillCode())){
            return calockUseDetailMapper.getCalockUseDetailListByBillCode(param);
        }
        return new ArrayList<>();
    }
}
