package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.InfoTrackStopMapper;
import com.ejianc.business.bid.bean.InfoTrackStopEntity;
import com.ejianc.business.bid.service.IInfoTrackStopService;

import java.util.Date;
import java.util.List;

/**
 * 投标信息跟踪中止
 * 
 * @author generator
 * 
 */
@Service("infoTrackStopService")
public class InfoTrackStopServiceImpl extends BaseServiceImpl<InfoTrackStopMapper, InfoTrackStopEntity> implements IInfoTrackStopService{

    /**此处需要根据实际修改 */
    private static final String BILL_CODE = "BID_INFO_TRACK_STOP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 投标信息跟踪为已结束时，插入一条信息跟踪中止数据
     */
    @Override
    public void insertInfoTrackStop(InfoTrackVO vo) {
        UserContext userContext = sessionManager.getUserContext();
        if(vo != null){
            if(BidStateEnum.YI_JIE_SHU.getCode().equals(vo.getFollowState())){
                LambdaQueryWrapper<InfoTrackStopEntity> wrapper = new LambdaQueryWrapper();
                wrapper.eq(InfoTrackStopEntity::getInfoTrackId,vo.getId());
                Long tenantId = InvocationInfoProxy.getTenantid();
                wrapper.eq(InfoTrackStopEntity::getTenantId,tenantId);
                wrapper.eq(InfoTrackStopEntity::getDr, BidCommonConsts.NO);
                List<InfoTrackStopEntity> list = baseMapper.selectList(wrapper);
                if(ListUtil.isEmpty(list)){
                    InfoTrackStopEntity entity = new InfoTrackStopEntity();
                    entity.setInfoTrackId(vo.getId());
                    entity.setEngineeringCode(vo.getBillCode());
                    entity.setEngineeringName(vo.getEngineeringName());
                    entity.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
                    entity.setApplyDate(new Date());
                    entity.setStopReason("投标信息跟踪已中止");
                    entity.setEmployeeId(userContext.getUserId());
                    entity.setEmployeeName(userContext.getUserName());
                    entity.setBillDate(new Date());
                    entity.setOrgId(vo.getOrgId());
                    entity.setOrgName(vo.getOrgName());
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                    if(billCode.isSuccess()) {
                        //此处需要根据实际修改 删除本行或者上一行
                        entity.setBillCode(billCode.getData());
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    this.saveOrUpdate(entity,false);
                }
            }
        }
    }
}
