package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.service.IEnrollService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.PrequaliFicationMapper;
import com.ejianc.business.bid.bean.PrequaliFicationEntity;
import com.ejianc.business.bid.service.IPrequaliFicationService;

/**
 * 资格预审
 * 
 * @author generator
 * 
 */
@Service("prequaliFicationService")
public class PrequaliFicationServiceImpl extends BaseServiceImpl<PrequaliFicationMapper, PrequaliFicationEntity> implements IPrequaliFicationService{

    @Autowired
    private PrequaliFicationMapper prequaliFicationMapper;

    @Autowired
    private IEnrollService iEnrollService;

    @Override
    public PrequaliFicationEntity selectByEnrollId(Long enrollId) {
        return prequaliFicationMapper.selectByEnrollId(enrollId);
    }

    @Override
    public boolean checkSave(Long enrollId) {
        EnrollEntity enrollEntity = iEnrollService.selectById(enrollId);
        if(null != enrollEntity){
            if(enrollEntity.getIsPrecheck() != 1){
                return true;
            }else{
                PrequaliFicationEntity prequaliFicationEntity = prequaliFicationMapper.selectByEnrollId(enrollId);
                if(null != prequaliFicationEntity){
                    return true;
                }
            }
        }
        return false;
    }
}
