package com.ejianc.business.bid.utils;

import com.ejianc.framework.core.exception.BusinessException;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class MonthUtil {


    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String dateFormatStr(Date date, String formatStr) throws Exception{
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(date);
    }


    public static String dateFormatStrTMDHMS(Date date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            return sdf.format(date);
        } catch (Exception e) {
            throw new BusinessException("程序运行错误，清廉管理员或者开发人员！");
        }

    }

    /**
     * 加月份
     *
     * @param sdf
     * @param m
     * @param len
     * @return
     */
    public static String monthAdd(SimpleDateFormat sdf, String m, Integer len) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(m));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.add(Calendar.MONTH, len);
        return sdf.format(cal.getTime());
    }

    /**
     * 加月份
     *
     * @param m
     * @param len
     * @return
     */
    public static Date monthAdd(Date m, Integer len) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(m);
        cal.add(Calendar.MONTH, len);
        return cal.getTime();
    }

    /**
     * 加月份并且获取月初
     *
     * @param m
     * @param len
     * @return
     */
    public static Date monthFAdd(Date m, int len) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(m);
        cal.add(Calendar.MONTH, len);
        Date time = cal.getTime();
        cal.set(time.getYear()+1900,time.getMonth(),1,0,0,0);
        return cal.getTime();
    }

    /**
     * 比较日期大小,如2020-10-23格式
     *
     * @param t1
     * @param t2
     * @return
     */
    public static int compareTime(String t1, String t2) {
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
        if (trr1 > trr2) {
            return 1;
        } else if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    /**
     * 获取两个月份之间的月份集合，包含首尾
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static List<String> getMonthList(String startDate, String endDate) {
        List<String> list = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(sdf.parse(startDate));
            c2.setTime(sdf.parse(endDate));
            int year = c2.get(Calendar.YEAR) - c1.get(Calendar.YEAR);
            int month = c2.get(Calendar.MONTH) + year * 12 - c1.get(Calendar.MONTH);
            for (int i = 0; i <= month; i++) {
                c1.setTime(sdf.parse(startDate));
                c1.add(c1.MONTH, i);
                list.add(sdf.format(c1.getTime()));
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }

    /**
     * 计算前几个月/后几个月
     * @param date
     * @param flag
     * @param num
     * @return
     * @throws ParseException
     */
    public static List getMonth(String date, boolean flag, int num) throws ParseException {
        List list = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c = Calendar.getInstance();
        c.setTime(sdf.parse(date));
        for (int i = 0; i < num; i++) {
            c.setTime(sdf.parse(date));
            if (flag) {
                c.add(c.MONTH, i);
            } else {
                c.add(c.MONTH, i + 1 - num);
            }
            list.add(sdf.format(c.getTime()));
        }
        return list;
    }

    /**
     * 两个日期差值
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getSubMonth(String startDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        Integer month = 0;
        try {
            c1.setTime(sdf.parse(startDate));
            c2.setTime(sdf.parse(endDate));
            int year = c2.get(Calendar.YEAR) - c1.get(Calendar.YEAR);
            month = c2.get(Calendar.MONTH) + year * 12 - c1.get(Calendar.MONTH);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return month;
    }
    /**
     * 查询日期集合中最大日期或最小日期
     * @param list
     * @param type,0-最小值，1-最大值
     * @return
     */
    public static String mostDate(List<String> list, int type) {
        String t = null;
        if (list.size() <= 0) {
            return t;
        } else {
            t = list.get(0);
            for (String d : list) {
                if (type == 0) {
                    if (compareTime(t, d) > 0) {
                        t = d;
                    }
                }
                if (type == 1) {
                    if (compareTime(t, d) < 0) {
                        t = d;
                    }
                }
            }
            return t;
        }
    }
}
