package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import java.util.Map;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * CA锁登记
 * 
 * @author generator
 * 
 */
public class CalockVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String remark; // 备注
    private String lockName; // 锁名称
    private String lockCode; // 锁序列号
    private Long platformId; // 交易平台id
    private String platformName; // 交易平台名称

    @JsonFormat(pattern="yyyy-MM-dd",timezone ="GMT+8")
    private Date deadline; // 有效截至时间
    private Long manageOrgId; // 管理单位id
    private String manageOrgName; // 管理单位名称
    private String innerCode; // 内部编号
    private String address; // 地域
    private String lockState; // 锁状态
    private String registerState; // 登记状态
    private String lockProperty; // 锁性质
    private String lockModel; // 锁型号
    private String lockPlatform; // 锁关联平台
    private String lockPassword; // 锁密码
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getLockName() {
        return lockName;
    }

    public void setLockName(String lockName) {
        this.lockName = lockName;
    }
    public String getLockCode() {
        return lockCode;
    }

    public void setLockCode(String lockCode) {
        this.lockCode = lockCode;
    }

    @ReferSerialTransfer(referCode="bid_platform")
    public Long getPlatformId() {
        return platformId;
    }

    @ReferDeserialTransfer
    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }
    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
    public Date getDeadline() {
        return deadline;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getManageOrgId() {
        return manageOrgId;
    }

    @ReferDeserialTransfer
    public void setManageOrgId(Long manageOrgId) {
        this.manageOrgId = manageOrgId;
    }
    public String getManageOrgName() {
        return manageOrgName;
    }

    public void setManageOrgName(String manageOrgName) {
        this.manageOrgName = manageOrgName;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getLockState() {
        return lockState;
    }

    public void setLockState(String lockState) {
        this.lockState = lockState;
    }
    public String getRegisterState() {
        return registerState;
    }

    public void setRegisterState(String registerState) {
        this.registerState = registerState;
    }
    public String getLockProperty() {
        return lockProperty;
    }

    public void setLockProperty(String lockProperty) {
        this.lockProperty = lockProperty;
    }
    public String getLockModel() {
        return lockModel;
    }

    public void setLockModel(String lockModel) {
        this.lockModel = lockModel;
    }
    public String getLockPlatform() {
        return lockPlatform;
    }

    public void setLockPlatform(String lockPlatform) {
        this.lockPlatform = lockPlatform;
    }
    public String getLockPassword() {
        return lockPassword;
    }

    public void setLockPassword(String lockPassword) {
        this.lockPassword = lockPassword;
    }
    
}
