package com.ejianc.business.bid.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bid.bean.EnrollEntity;

import java.util.List;

/**
 * 投标报名
 * 
 * @author generator
 * 
 */
public interface IEnrollService extends IBaseService<EnrollEntity> {
    //获取即将的开标(开始标前评审)
    List<EnrollVO> queryBidOpeningSoon();
    //获取还未进行投标评审的单据
    List<EnrollEntity> selectEnrollListIsBidding();
    //获取已经招标文件评审但尚未进行投标总结的单据
    List<EnrollEntity> selectEnrollListIsSummary();

    //获取投标地图数据
    CommonResponse<JSONObject> enrollArea(String range, String name, String dateIn, Long orgId);

}
