package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.bid.vo.UndertakeTargetVO;
import com.ejianc.business.bid.vo.UndertakeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.UndertakeMapper;
import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.service.IUndertakeService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 承揽任务登记
 * 
 * @author generator
 * 
 */
@Service("undertakeService")
public class UndertakeServiceImpl extends BaseServiceImpl<UndertakeMapper, UndertakeEntity> implements IUndertakeService{
    @Autowired
    private UndertakeMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<UndertakeApiVO> queryUndertakeInfoList(QueryWrapper wrapper) {
        return mapper.queryUndertakeInfoList(wrapper);
    }

    @Override
    public List<DeptOrderApiVO> queryDeptOrderList(QueryWrapper wrapper) {
        return mapper.queryDeptOrderList(wrapper);
    }

    @Override
    public List<DeptOrderApiVO> queryOutputDeptOrderList(QueryWrapper wrapper) {
        return mapper.queryOutputDeptOrderList(wrapper);
    }

    @Override
    public JSONObject pageList(QueryParam param) {

        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int total = 0; // 总条数
        int pages = 0; // 有几页

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("areaName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 组织隔离 */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        param.getParams().put("supplementFlag",new Parameter(QueryParam.EQ, 0));

        // 查出来补充协议的合同
        List<UndertakeEntity> undertakeEntities = this.queryList(param);
        //
        List<UndertakeEntity> list = undertakeEntities.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());

        List<UndertakeVO> undertakeVOS = BeanMapper.mapList(undertakeEntities, UndertakeVO.class);
        List<Long> idList = undertakeVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        // 根据合同查出来补充协议
        QueryParam childrenParam = Utils.deepCopy(param);
        if (ListUtil.isNotEmpty(idList)) {
            childrenParam.getParams().put("mainId", new Parameter(QueryParam.IN, idList));
        }
//        childrenParam.getParams().remove("supplementFlag");
        childrenParam.getParams().put("supplementFlag",new Parameter(QueryParam.EQ, 1));
        List<UndertakeEntity> childrenList = this.queryList(childrenParam);
        List<UndertakeVO> childrenVoList = BeanMapper.mapList(childrenList, UndertakeVO.class);

        Map<Long, List<UndertakeVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(UndertakeVO::getMainId));

        if (param.getSearchText() != null && ListUtil.isNotEmpty(undertakeVOS)) {
            List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
            param.getParams().put("mainId", new Parameter(QueryParam.IN, childrenIdList));
            // 搜索补充协议编码，主合同为空。清空搜索条件
            if (ListUtil.isEmpty(undertakeEntities)) {
                param.setSearchText(null);
            }
            List<UndertakeEntity> newEntityList = this.queryList(param);
            // 搜索非补充协议编码，两个结果合并
            undertakeEntities.addAll(newEntityList);
            undertakeEntities = undertakeEntities.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                    new TreeSet<>(Comparator.comparing(UndertakeEntity::getId))), ArrayList::new));
            undertakeEntities = undertakeEntities.stream().sorted(Comparator.comparing(UndertakeEntity::getCreateTime).reversed()).collect(Collectors.toList());
            list = undertakeEntities.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
            undertakeVOS = BeanMapper.mapList(list, UndertakeVO.class);
        }

        if (ListUtil.isNotEmpty(undertakeVOS)) {
            // 拼装数据
            for (UndertakeVO vo : undertakeVOS) {
                if (childrenMap.containsKey(vo.getId())) {
                    vo.setChildren(childrenMap.get(vo.getId()));
                }
            }
        }

        total = undertakeEntities.size();
        if (total % pageSize > 0) {
            pages = (total / pageSize) + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }

        JSONObject page = new JSONObject();
        page.put("records", undertakeVOS);
        page.put("total", total);
        page.put("current", pageIndex);
        page.put("size", pageSize);
        page.put("pages", pages);

        return page;
    }

    @Override
    public List<String> queryUndertakeCostMonth(Integer year, List<Long> orgIds) {
        String year1 = year+"";
        return baseMapper.queryUndertakeCostMonth(year1,orgIds);
    }

    @Override
    public UndertakeTargetVO queryUndertakeYearTarget(Integer year) {
        String year1 = year+"";
        return baseMapper.queryUndertakeYearTarget(year1);
    }
}
