package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.business.bid.vo.bidAreaVO.ContractingContrastVO;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 投标报名
 *
 * @author generator
 */
@Controller
@RequestMapping("enroll")
@Api(value = "投标报名", tags = {"投标报名"})
public class EnrollController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_ENGINEERING_CODE";

    @Autowired
    private IEnrollService service;

    @Autowired
    private IInfoTrackService infoTrackService;

    @Autowired
    private IRecordService recordService;

    @Autowired
    private IInstoreApi iInstoreApi;

    @Autowired
    private IStopApplyService stopApplyService;

    @Autowired
    private IZjllApi zjllApi;

    @Autowired
    private IBidFileReviewService bidFileReviewService;

    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;

    @Autowired
    private IUndertakeService undertakeService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EnrollVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody EnrollVO saveorUpdateVO) {
        EnrollEntity entity = BeanMapper.map(saveorUpdateVO, EnrollEntity.class);
        if ((entity.getId() == null || entity.getId() == 0) && StringUtils.isEmpty(entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        EnrollVO vo = BeanMapper.map(entity, EnrollVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("参照信息跟踪新增")
    @RequestMapping(value = "/addByInfotrack", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EnrollVO> addByInfotrack(@RequestParam Long id) {
        InfoTrackEntity infoTrack = infoTrackService.selectById(id);
        EnrollEntity vo = new EnrollEntity();
        if (infoTrack != null) {
            vo.setBillCode(infoTrack.getBillCode());
            vo.setEngineeringName(infoTrack.getEngineeringName());
            vo.setInfoSource(infoTrack.getInfoSource());
            vo.setInfoSourceName(infoTrack.getInfoSourceName());
            vo.setFollowPerson(infoTrack.getUnitDirector());
            vo.setFollowPersonName(infoTrack.getUnitDirectorName());
            vo.setFollowPersonPhone(infoTrack.getUnitDirectorPhone());
            vo.setBidState(BidStateEnum.JIN_XING_ZHONG.getCode());
            vo.setProjectManager(infoTrack.getProjectBidManage());
            vo.setProjectManagerName(infoTrack.getProjectBidManageName());
            vo.setProjectManagerPhone(infoTrack.getProjectBidManagePhone());
            vo.setIsPrecheck(BidCommonConsts.NO);
            vo.setAddress(infoTrack.getAddress());
            vo.setArea(infoTrack.getArea());
            vo.setProvince(infoTrack.getProvince());
            vo.setCity(infoTrack.getCity());
            vo.setRegion(infoTrack.getRegion());
            vo.setIsGive(BidCommonConsts.NO);

            vo.setConstructionUnit(infoTrack.getConstructionUnit());
            vo.setConstructionUnitName(infoTrack.getConstructionUnitName());
            vo.setOwnerClient(infoTrack.getOwnerEntrust());
            vo.setOwnerClientPhone(infoTrack.getOwnerEntrustPhone());

            vo.setFundsSource(infoTrack.getFundsSource());
            vo.setFundsSourceName(infoTrack.getFundsSourceName());
            vo.setBiddingForm(infoTrack.getBiddingForm());
            vo.setBidScope(infoTrack.getBidRange());
            vo.setEngineeringType(infoTrack.getEngineeringType());
            vo.setEngineeringTypeName(infoTrack.getEngineeringTypeName());
            vo.setPlanDay(infoTrack.getPlanDuration());
            vo.setCostTotal(infoTrack.getTheInvestmentAmount());
            vo.setRemark(infoTrack.getRemark());
            vo.setBidStage(BidStageEnum.TOU_BIAO_BAO_MING.getCode());

            vo.setBidAgentOrg(infoTrack.getBiddingAgency());
            vo.setIsGive(BidCommonConsts.NO);
            vo.setIsStop(BidCommonConsts.NO);
            //0来源信息跟踪
            vo.setSourceType(BidCommonConsts.NO);
            vo.setSourceId(id);

        }

        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(vo, EnrollVO.class));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EnrollVO> queryDetail(@RequestParam Long id) {
        EnrollEntity entity = service.selectById(id);
        EnrollVO vo = BeanMapper.map(entity, EnrollVO.class);
        vo.setRecords(recordService.getRecord(vo.getBillCode()));
        if(null != vo){
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode(vo.getBiddingForm()));
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setBidStageName(BidStageEnum.getNameByCode(vo.getBidStage()));
            vo.setBidStateName(BidStateEnum.getNameByCode(vo.getBidState()));
        }
        logger.info("审批流问题排查测试");
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EnrollVO> vos) {
        service.removeByIds(vos.stream().map(EnrollVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EnrollVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例
         * 单据编号、项目名称，投标单位，经办人
         * 负责人，建设单位，招标代理机构
         * 工程类型，投标负责人
         * */
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName",
                "followPersonName","constructionUnitName","bidAgentOrg","engineeringTypeName","projectManagerName"));

        /**
         * 供首页跳转使用
         */
        if (param.getParams().containsKey("myOrder") && param.getOrderMap().containsKey("biddingDate")){
            param.getParams().remove("myOrder");
            String biddingDate = param.getOrderMap().get("biddingDate");
            param.getOrderMap().clear();
            if (biddingDate.equals("desc")) {
                param.getOrderMap().put("biddingDate", QueryParam.ASC);
            }else {
                param.getOrderMap().put("biddingDate", QueryParam.DESC);
            }
        }


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EnrollEntity> page = service.queryPage(param, false);
        IPage<EnrollVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EnrollVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EnrollEntity> list = service.queryList(param);
        List<EnrollVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, EnrollVO.class);
            voList.forEach(vo -> {
                vo.setBiddingFormName(BiddingFormEnum.getNameByCode(vo.getBiddingForm()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setBidStageName(BidStageEnum.getNameByCode(vo.getBidStage()));
                vo.setBidStateName(BidStateEnum.getNameByCode(vo.getBidState()));
            });
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Enroll-export.xlsx", beans, response);
    }


    /***
     * @description:
     * 1. 资格预审:     是否资格预审:是
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.bid.vo.EnrollVO>>
     * @author songlx
     * @date: 2021/11/17
     */
    @ApiOperation("参照")
    @RequestMapping(value = "/refEnrollData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EnrollVO>> refEnrollData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("billCode", "engineeringName", "bidOrgName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("isStop", new Parameter(QueryParam.EQ, BidCommonConsts.NO));
        //param.getParams().put("bidState", new Parameter(QueryParam.NE, BidStateEnum.YI_JIE_SHU));
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("isPrecheck") != null){
                param.getParams().put("isPrecheck", new Parameter(QueryParam.EQ, _con.get("isPrecheck")));
            }
            if(_con.get("bidState") != null){
                param.getParams().put("bidState", new Parameter(QueryParam.IN, _con.get("bidState")));
            }else {
                param.getParams().put("bidState", new Parameter(QueryParam.NE, BidStateEnum.YI_JIE_SHU));
            }
            if(_con.get("isPreChecked") != null){
                param.getParams().put("isPreChecked", new Parameter(QueryParam.EQ, _con.get("isPreChecked")));
            }
            if(_con.get("isBidChecked") != null){
                param.getParams().put("isBidChecked", new Parameter(QueryParam.EQ, _con.get("isBidChecked")));
            }
            if(_con.get("isBidddingChecked") != null){
                param.getParams().put("isBidddingChecked", new Parameter(QueryParam.EQ, _con.get("isBidddingChecked")));
            }
            if(_con.get("isSummary") != null){
                Page<EnrollEntity> page = new Page<>();
                page.setSize(pageSize);
                page.setCurrent(pageNumber);
                QueryWrapper wrapper = changeToQueryWrapper(param);
                wrapper.apply("((bid_state = 3 and is_bid_checked = 1)  or bidding_form = 3)");
                IPage summarypage = service.page(page, wrapper);
                IPage<EnrollVO> pageData = new Page<>(summarypage.getCurrent(), summarypage.getSize(), summarypage.getTotal());
                List<EnrollVO> enrollVOS = BeanMapper.mapList(page.getRecords(), EnrollVO.class);
                for (EnrollVO enrollVO : enrollVOS) {
                    enrollVO.setBidStateName(BidStateEnum.getNameByCode(enrollVO.getBidState()));
                    enrollVO.setBiddingFormName(BiddingFormEnum.getNameByCode(enrollVO.getBiddingForm()));
                }
                pageData.setRecords(enrollVOS);
                return CommonResponse.success("查询参照数据成功！", pageData);
            }

        }else {
            param.getParams().put("bidState", new Parameter(QueryParam.NE, BidStateEnum.YI_JIE_SHU));
        }

        IPage<EnrollEntity> page = service.queryPage(param, false);
        IPage<EnrollVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<EnrollVO> enrollVOS = BeanMapper.mapList(page.getRecords(), EnrollVO.class);
        for (EnrollVO enrollVO : enrollVOS) {
            enrollVO.setBidStateName(BidStateEnum.getNameByCode(enrollVO.getBidState()));
            enrollVO.setBiddingFormName(BiddingFormEnum.getNameByCode(enrollVO.getBiddingForm()));
        }
        pageData.setRecords(enrollVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 修改开标日期
     */
    @RequestMapping(value = "/updateBiddingDate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateBiddingDate(@RequestBody EnrollVO updateVO) {
        if (updateVO.getId() != null) {
            EnrollEntity enrollEntity = service.selectById(updateVO.getId());
            enrollEntity.setBiddingDate(updateVO.getBiddingDate());
            service.updateById(enrollEntity);

            //修改招标文件评审中的开标日期
            LambdaUpdateWrapper<BiddingFileReviewEntity> biddingFileReviewWrapper = new LambdaUpdateWrapper<>();
            biddingFileReviewWrapper
                    .set(BiddingFileReviewEntity::getPlannedTenderDate,updateVO.getBiddingDate())
                    .eq(BiddingFileReviewEntity::getEnrollId,updateVO.getId());
            biddingFileReviewService.update(biddingFileReviewWrapper);

            //修改投标文件评审中的开标日期
            LambdaUpdateWrapper<BidFileReviewEntity> bidFileReviewWrapper = new LambdaUpdateWrapper<>();
            bidFileReviewWrapper
                    .set(BidFileReviewEntity::getBiddingDate,updateVO.getBiddingDate())
                    .eq(BidFileReviewEntity::getEnrollId,updateVO.getId());
            bidFileReviewService.update(bidFileReviewWrapper);

        }
        return CommonResponse.success("保存或修改单据成功！");
    }


    /**
     * 经营部门户-投标地图数据
     *
     * @param range
     * @param name
     * @param dateIn
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/enrollArea", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> enrollArea(@RequestParam(value = "range", required = false) String range,
                                                 @RequestParam(value = "name", required = false) String name,
                                                 @RequestParam(value = "dateIn", required = false) String dateIn,
                                                 @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.enrollArea(range, name, dateIn, orgId);
    }

    /**
     * 经营部门户-近3年承揽期间对比
     *
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/contractingContrast", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractingContrastVO> getContractValueByOrgId(@RequestParam(value = "orgId", required = true) Long orgId,
                                                                         @RequestParam(value = "timeFlag", required = true) String timeFlag) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            //项目部
            departmentIds.add(org.getId());
        });

        /** makeOrgId */
        param.getParams().put("makeOrgId", new Parameter(QueryParam.IN, departmentIds));

        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));


        /**
         * 获取近三年的承揽金额、同比
         */
        List<BigDecimal> contractingList = new ArrayList<>();//承揽金额
        List<BigDecimal> contrastList = new ArrayList<>();//同比
        List<String> dateList = new ArrayList<>();//年份
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        if("firstQuarter".equals(timeFlag)){
            endMonth = "-3-31";
        } else if("halfYear".equals(timeFlag)){
            endMonth = "-6-30";
        } else if("thirdQuarter".equals(timeFlag)){
            endMonth = "-9-30";
        } else if("thisYear".equals(timeFlag)){
            endMonth = "-12-31";
        } else if("now".equals(timeFlag)){
            endMonth = "-"+LocalDate.now().getMonth().getValue()+"-"+LocalDate.now().getDayOfMonth();
        }

        for (int i = 3; i >= 0; i--) {
            BigDecimal totalMny = new BigDecimal(0.0);
            /** ywDate    参数year为0时，取所有的*/
            param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                    (LocalDate.now().getYear() - i) + startMonth + (LocalDate.now().getYear() - i) + endMonth));
            List<UndertakeEntity> undertakeEntities = undertakeService.queryList(param);
            logger.info("-----------{}年获取承揽任务数据共{}条。", LocalDate.now().getYear() - i,undertakeEntities.size());
            param.getParams().remove("ywDate");
            for (UndertakeEntity entity : undertakeEntities) {
                totalMny = totalMny.add(entity.getProjectCost());
            }
            if (i != 3) {
                dateList.add(LocalDate.now().getYear() - i + "");
            }
            logger.info("-----------{}年获取承揽金额:{}。", LocalDate.now().getYear() - i,totalMny);
            contractingList.add(totalMny);
        }
        //计算同比
        for (int i = 0; i < contractingList.size() - 1; i++) {
            BigDecimal lastYear = contractingList.get(i);
            BigDecimal thisYear = contractingList.get(i + 1);
            if (BigDecimal.ZERO.compareTo(lastYear) == 0) {
                contrastList.add(BigDecimal.ZERO);
            } else {
                BigDecimal yearOnYear = thisYear.subtract(lastYear).divide(lastYear, 8, BigDecimal.ROUND_HALF_UP);
                contrastList.add(yearOnYear);
            }
        }
        contractingList.remove(0);
        ContractingContrastVO contractingContrastVO = new ContractingContrastVO();
        contractingContrastVO.setDateList(dateList);
        contractingContrastVO.setContrastList(contrastList);
        contractingContrastVO.setContractingList(contractingList);


        return CommonResponse.success("查询合同总金额成功！", contractingContrastVO);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
