package com.ejianc.business.bid.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.bid.vo.UndertakeTargetVO;
import com.ejianc.business.bid.vo.UndertakeVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bid.bean.UndertakeEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 承揽任务登记
 * 
 * @author generator
 * 
 */
public interface IUndertakeService extends IBaseService<UndertakeEntity> {
    List<UndertakeApiVO> queryUndertakeInfoList(QueryWrapper wrapper);


    List<DeptOrderApiVO> queryDeptOrderList(QueryWrapper wrapper);

    List<DeptOrderApiVO> queryOutputDeptOrderList(QueryWrapper wrapper);


    JSONObject pageList(QueryParam param);

    //BI门户：新增承揽金额月度分布
    List<String> queryUndertakeCostMonth(Integer year, List<Long> orgIds);
    //BI门户：年度承揽目标达成率
    UndertakeTargetVO queryUndertakeYearTarget(Integer year);
}
