/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BidFileReviewEntity;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.impl.BidFileReviewBpmServiceImpl;
import com.ejianc.business.bid.vo.BidFileReviewVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bidFileReview"})
public class BidFileReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private BidFileReviewBpmServiceImpl bpmService;
    private static final String BILL_CODE = "BID_BIDDINGFILEREVIEW";
    @Autowired
    private IBidFileReviewService service;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private BidFileReviewBpmServiceImpl tbpmService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BidFileReviewVO> saveOrUpdate(@RequestBody BidFileReviewVO saveorUpdateVO) {
        BidFileReviewEntity entity = (BidFileReviewEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BidFileReviewEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        }
        CommonResponse byEmpmloyeeCode = this.employeeApi.getByEmpmloyeeCode(entity.getEmployeeCode());
        EmployeeVO employeeVO = null;
        if (!byEmpmloyeeCode.isSuccess()) {
            CommonResponse byCodeOrIdcard = this.employeeApi.getByCodeOrIdcard(Arrays.asList(entity.getConstructorIdCard()));
            if (byCodeOrIdcard.isSuccess()) throw new BusinessException("\u901a\u8fc7EmpmloyeeCode\u83b7\u53d6\u5458\u5de5\u4fe1\u606f\u6570\u636e\u5931\u8d252\uff01 \u5458\u5de5\u7f16\u7801\u4e3a\uff1a " + entity.getEmployeeCode() + "\uff0c\u8eab\u4efd\u8bc1\u53f7\uff1a" + entity.getConstructorIdCard());
            List data = (List)byCodeOrIdcard.getData();
            if (data == null || data.size() != 1) throw new BusinessException("\u901a\u8fc7EmpmloyeeCode\u83b7\u53d6\u5458\u5de5\u4fe1\u606f\u6570\u636e\u5931\u8d251\uff01 \u5458\u5de5\u7f16\u7801\u4e3a\uff1a " + entity.getEmployeeCode() + "\uff0c\u8eab\u4efd\u8bc1\u53f7\uff1a" + entity.getConstructorIdCard());
            employeeVO = (EmployeeVO)data.get(0);
        } else {
            employeeVO = (EmployeeVO)byEmpmloyeeCode.getData();
        }
        entity.setPid(employeeVO.getId());
        this.service.saveOrUpdate((Object)entity, false);
        BidFileReviewVO vo = (BidFileReviewVO)BeanMapper.map((Object)((Object)entity), BidFileReviewVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BidFileReviewVO> queryDetail(Long id) {
        BidFileReviewEntity entity = (BidFileReviewEntity)((Object)this.service.selectById(id));
        BidFileReviewVO vo = (BidFileReviewVO)BeanMapper.map((Object)((Object)entity), BidFileReviewVO.class);
        vo.setRecords(this.recordService.getRecord(vo.getEngineeringCode()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryByEnrollId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BidFileReviewVO> queryByEnrollId(Long enrollId) {
        BidFileReviewEntity entity = this.service.selectByEnrollId(enrollId);
        if (null == entity) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        BidFileReviewVO vo = (BidFileReviewVO)BeanMapper.map((Object)((Object)entity), BidFileReviewVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidFileReviewVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BidFileReviewVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("builtConstructor");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidFileReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, BidFileReviewVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("BidFileReview-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBidFileReviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BidFileReviewVO>> refBidFileReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BidFileReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test() {
        this.tbpmService.afterApprovalProcessor(562622599805288457L, 0, "");
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }
}

