/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.UndertakeEntity;
import com.ejianc.business.bid.service.IUndertakeService;
import com.ejianc.business.bid.vo.UndertakeVO;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"undertake"})
public class UndertakeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutputValueApi outputValueApi;
    private static final String BILL_CODE = "bid_undertake";
    @Autowired
    private IUndertakeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    private static final BigDecimal ONE_HUNDRED_MILLION = new BigDecimal(10000);
    private static final BigDecimal FIFTY_MILLION = new BigDecimal(5000);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UndertakeVO> saveOrUpdate(@RequestBody UndertakeVO saveOrUpdateVO) {
        UndertakeEntity entity = (UndertakeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, UndertakeEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        UndertakeVO vo = (UndertakeVO)BeanMapper.map((Object)((Object)entity), UndertakeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UndertakeVO> queryDetail(Long id) {
        UndertakeEntity entity = (UndertakeEntity)((Object)this.service.selectById(id));
        UndertakeVO vo = (UndertakeVO)BeanMapper.map((Object)((Object)entity), UndertakeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UndertakeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UndertakeVO undertakeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UndertakeVO>> queryList(@RequestBody QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        boolean total = false;
        boolean pages = false;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("porjectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("jzsName");
        fuzzyFields.add("xmnbcbrName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("makeOrgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("makeOrgId", new Parameter("in", commonOrgIds));
            }
        }
        if (param.getParams().get("areaName") != null) {
            String provinceFlag = ((Parameter)param.getParams().get("areaName")).getValue().toString();
            param.getParams().remove("areaName");
            if ("in".equals(provinceFlag)) {
                param.getParams().put("areaName", new Parameter("like", (Object)"\u6cb3\u5357\u7701"));
            } else if ("out".equals(provinceFlag)) {
                param.getParams().put("areaName", new Parameter("not_like", (Object)"\u6cb3\u5357\u7701"));
            }
        }
        if (param.getParams().get("projectCost") != null) {
            String projectCostFlag = ((Parameter)param.getParams().get("projectCost")).getValue().toString();
            if ("1".equals(projectCostFlag)) {
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost", new Parameter("le", (Object)FIFTY_MILLION));
            } else if ("2".equals(projectCostFlag)) {
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost", new Parameter("sql", (Object)("project_cost >= " + FIFTY_MILLION + " and project_cost <=" + ONE_HUNDRED_MILLION)));
            } else if ("3".equals(projectCostFlag)) {
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost", new Parameter("ge", (Object)ONE_HUNDRED_MILLION));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UndertakeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTotalMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalMny(@RequestBody QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        boolean total = false;
        boolean pages = false;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("porjectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("jzsName");
        fuzzyFields.add("xmnbcbrName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("makeOrgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("makeOrgId", new Parameter("in", commonOrgIds));
            }
        }
        if (param.getParams().get("areaName") != null) {
            String provinceFlag = ((Parameter)param.getParams().get("areaName")).getValue().toString();
            param.getParams().remove("areaName");
            if ("in".equals(provinceFlag)) {
                param.getParams().put("areaName", new Parameter("like", (Object)"\u6cb3\u5357\u7701"));
            } else if ("out".equals(provinceFlag)) {
                param.getParams().put("areaName", new Parameter("not_like", (Object)"\u6cb3\u5357\u7701"));
            }
        }
        if (param.getParams().get("projectCost") != null) {
            String projectCostFlag = ((Parameter)param.getParams().get("projectCost")).getValue().toString();
            if ("1".equals(projectCostFlag)) {
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost", new Parameter("le", (Object)FIFTY_MILLION));
            } else if ("2".equals(projectCostFlag)) {
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost", new Parameter("sql", (Object)("project_cost >= " + FIFTY_MILLION + " and project_cost <=" + ONE_HUNDRED_MILLION)));
            } else if ("3".equals(projectCostFlag)) {
                param.getParams().remove("projectCost");
                param.getParams().put("projectCost", new Parameter("ge", (Object)ONE_HUNDRED_MILLION));
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"ifnull(sum(project_cost), 0) as sumProjectCost"});
        Map resultMap = this.service.getMap((Wrapper)wrapper);
        BigDecimal sumProjectCost = BigDecimal.ZERO;
        if (resultMap.containsKey("sumProjectCost")) {
            sumProjectCost = null != resultMap.get("sumProjectCost") && !new BigDecimal("0E-8").equals(resultMap.get("sumProjectCost")) ? new BigDecimal(resultMap.get("sumProjectCost").toString()) : BigDecimal.ZERO;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)sumProjectCost);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("makeOrgName");
        fuzzyFields.add("porjectName");
        fuzzyFields.add("areaName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("jzsName");
        fuzzyFields.add("xmnbcbrName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("makeOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Undertake-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refUndertakeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UndertakeVO>> refUndertakeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UndertakeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateProjectCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateProjectCost(@RequestBody UndertakeVO updateVO) {
        if (updateVO.getId() != null) {
            UndertakeEntity entity = (UndertakeEntity)((Object)this.service.selectById(updateVO.getId()));
            entity.setProjectCost(updateVO.getProjectCost());
            this.service.updateById((Object)entity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryMainId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UndertakeVO> queryMainId(Long id) {
        UndertakeEntity entity = (UndertakeEntity)((Object)this.service.selectById(id));
        UndertakeEntity entity1 = new UndertakeEntity();
        entity1.setPorjectName(entity.getPorjectName());
        entity1.setDays(entity.getDays());
        entity1.setProjectQuality(entity.getProjectQuality());
        entity1.setJzsId(entity.getJzsId());
        entity1.setJzsName(entity.getJzsName());
        entity1.setXmnbcbrId(entity.getXmnbcbrId());
        entity1.setXmnbcbrName(entity.getXmnbcbrName());
        UndertakeVO vo = (UndertakeVO)BeanMapper.map((Object)((Object)entity1), UndertakeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getContractingProvinceContrast"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getContractingProvinceContrast(String timeFlag, Long orgId, Integer dateIn) {
        ArrayList result = new ArrayList();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgIdList = ((List)this.orgApi.findChildrenByParentId(_orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        ArrayList contractingList = new ArrayList();
        ArrayList contrastList = new ArrayList();
        ArrayList dateList = new ArrayList();
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        if ("firstQuarter".equals(timeFlag)) {
            endMonth = "-3-31";
        } else if ("halfYear".equals(timeFlag)) {
            endMonth = "-6-30";
        } else if ("thirdQuarter".equals(timeFlag)) {
            endMonth = "-9-30";
        } else if ("thisYear".equals(timeFlag)) {
            endMonth = "-12-31";
        } else if ("now".equals(timeFlag)) {
            endMonth = "-" + LocalDate.now().getMonth().getValue() + "-" + LocalDate.now().getDayOfMonth();
        }
        QueryWrapper undertakeWrapper = new QueryWrapper();
        undertakeWrapper.in((Object)"org_id", orgIdList);
        undertakeWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        undertakeWrapper.between((Object)"yw_date", (Object)(dateIn + startMonth), (Object)(dateIn + endMonth));
        List allData = this.service.list((Wrapper)undertakeWrapper);
        List<UndertakeEntity> provinceIn = allData.stream().filter(s -> s.getAreaName() != null && s.getAreaName().contains("\u6cb3\u5357\u7701")).collect(Collectors.toList());
        BigDecimal provinceInUnderFive = this.getSumProjectCostByRange(provinceIn, null, FIFTY_MILLION);
        BigDecimal provinceInBetweenFiveToTen = this.getSumProjectCostByRange(provinceIn, FIFTY_MILLION, ONE_HUNDRED_MILLION);
        BigDecimal provinceInAboveTen = this.getSumProjectCostByRange(provinceIn, ONE_HUNDRED_MILLION, null);
        List<UndertakeEntity> provinceOut = allData.stream().filter(s -> s.getAreaName() != null && !s.getAreaName().contains("\u6cb3\u5357\u7701")).collect(Collectors.toList());
        BigDecimal provinceOutUnderFive = this.getSumProjectCostByRange(provinceOut, null, FIFTY_MILLION);
        BigDecimal provinceOutBetweenFiveToTen = this.getSumProjectCostByRange(provinceOut, FIFTY_MILLION, ONE_HUNDRED_MILLION);
        BigDecimal provinceOutAboveTen = this.getSumProjectCostByRange(provinceOut, ONE_HUNDRED_MILLION, null);
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>();
        values.add(provinceInUnderFive);
        values.add(provinceInBetweenFiveToTen);
        values.add(provinceInAboveTen);
        values.add(provinceOutUnderFive);
        values.add(provinceOutBetweenFiveToTen);
        values.add(provinceOutAboveTen);
        ArrayList<String> names = new ArrayList<String>();
        names.add("\u7701\u51855000\u4e07\u4ee5\u4e0b\u627f\u63fd\u989d");
        names.add("\u7701\u51855\u5343\u4e07\u52301\u4ebf\u627f\u63fd\u989d");
        names.add("\u7701\u51851\u4ebf\u4ee5\u4e0a\u627f\u63fd\u989d");
        names.add("\u7701\u59165000\u4e07\u4ee5\u4e0b\u627f\u63fd\u989d");
        names.add("\u7701\u59165\u5343\u4e07\u52301\u4ebf\u627f\u63fd\u989d");
        names.add("\u7701\u59161\u4ebf\u4ee5\u4e0a\u627f\u63fd\u989d");
        for (int i = 0; i < values.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", names.get(i));
            map.put("value", ((BigDecimal)values.get(i)).toString());
            result.add(map);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", result);
    }

    private BigDecimal getSumProjectCostByRange(List<UndertakeEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getProjectCost() != null && s.getProjectCost().compareTo(start) > 0 && s.getProjectCost().compareTo(end) <= 0).map(UndertakeEntity::getProjectCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getProjectCost() != null && s.getProjectCost().compareTo(end) <= 0).map(UndertakeEntity::getProjectCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getProjectCost() != null && s.getProjectCost().compareTo(start) > 0).map(UndertakeEntity::getProjectCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    @RequestMapping(value={"/queryDetailByProjectName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UndertakeVO> queryDetail(String projectName) {
        QueryWrapper undertakeWrapper = new QueryWrapper();
        undertakeWrapper.eq((Object)"porject_name", (Object)projectName);
        undertakeWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        undertakeWrapper.eq((Object)"supplement_flag", (Object)0);
        List entity = this.service.list((Wrapper)undertakeWrapper);
        List undertakeVOS = BeanMapper.mapList((Iterable)entity, UndertakeVO.class);
        UndertakeVO vo = new UndertakeVO();
        if (undertakeVOS != null && undertakeVOS.size() > 0) {
            vo = (UndertakeVO)undertakeVOS.get(0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

