/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller.external;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IBidFileReviewBisService;
import com.ejianc.business.bid.service.IBidFileReviewService;
import com.ejianc.business.bid.service.IBidFileReviewTecService;
import com.ejianc.business.bid.service.IBidFileReviewValueService;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.ResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statistic"})
public class StatisticController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    @Autowired
    private ISummaryService summaryService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBidFileReviewBisService bidFileReviewBisService;
    @Autowired
    private IBidFileReviewTecService bidFileReviewTecService;
    @Autowired
    private IBidFileReviewValueService bidFileReviewValueService;

    @RequestMapping(value={"/getBidState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidState(String timeFlag, Long orgId) {
        ArrayList<ResultVO> resultVOS = new ArrayList<ResultVO>();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgIdList = ((List)this.orgApi.findChildrenByParentId(_orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper enrollWrapper = new QueryWrapper();
        enrollWrapper.in((Object)"org_id", orgIdList);
        enrollWrapper.eq((Object)"dr", (Object)0);
        if ("thisYear".equals(timeFlag)) {
            enrollWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            enrollWrapper.eq((Object)"YEAR(create_time)", (Object)DateUtil.getYear());
        } else {
            enrollWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int entrollCount = this.enrollService.count((Wrapper)enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("\u9879\u76ee\u6295\u6807\u4fe1\u606f", Integer.valueOf(entrollCount));
        QueryWrapper biddingFileReviewWrapper = new QueryWrapper();
        biddingFileReviewWrapper.in((Object)"org_id", orgIdList);
        biddingFileReviewWrapper.eq((Object)"dr", (Object)0);
        if ("thisYear".equals(timeFlag)) {
            biddingFileReviewWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            biddingFileReviewWrapper.eq((Object)"YEAR(create_time)", (Object)DateUtil.getYear());
        } else {
            biddingFileReviewWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int biddingFileReviewCount = this.biddingFileReviewService.count((Wrapper)biddingFileReviewWrapper);
        ResultVO biddingFileReviewResultVO = new ResultVO("\u62db\u6807\u6587\u4ef6\u8bc4\u5ba1", Integer.valueOf(biddingFileReviewCount));
        QueryWrapper bidFileReviewWrapper = new QueryWrapper();
        bidFileReviewWrapper.in((Object)"org_id", orgIdList);
        bidFileReviewWrapper.eq((Object)"dr", (Object)0);
        if ("thisYear".equals(timeFlag)) {
            bidFileReviewWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            bidFileReviewWrapper.eq((Object)"YEAR(create_time)", (Object)DateUtil.getYear());
        } else {
            bidFileReviewWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int bidFileReviewCount = this.bidFileReviewBisService.count((Wrapper)bidFileReviewWrapper);
        QueryWrapper bidFileReviewTecWrapper = new QueryWrapper();
        bidFileReviewTecWrapper.in((Object)"org_id", orgIdList);
        bidFileReviewTecWrapper.eq((Object)"dr", (Object)0);
        if ("thisYear".equals(timeFlag)) {
            bidFileReviewTecWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            bidFileReviewTecWrapper.eq((Object)"YEAR(create_time)", (Object)DateUtil.getYear());
        } else {
            bidFileReviewTecWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int bidFileReviewTecCount = this.bidFileReviewTecService.count((Wrapper)bidFileReviewTecWrapper);
        QueryWrapper bidFileReviewValueWrapper = new QueryWrapper();
        bidFileReviewValueWrapper.in((Object)"org_id", orgIdList);
        bidFileReviewValueWrapper.eq((Object)"dr", (Object)0);
        if ("thisYear".equals(timeFlag)) {
            bidFileReviewValueWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            bidFileReviewValueWrapper.eq((Object)"YEAR(create_time)", (Object)DateUtil.getYear());
        } else {
            bidFileReviewValueWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        }
        int bidFileReviewValueCount = this.bidFileReviewValueService.count((Wrapper)bidFileReviewValueWrapper);
        ResultVO zbResultVO = new ResultVO("\u6295\u6807\u6587\u4ef6\u8bc4\u5ba1", Integer.valueOf(bidFileReviewCount + bidFileReviewTecCount + bidFileReviewValueCount));
        QueryWrapper summaryWrapper = new QueryWrapper();
        summaryWrapper.in((Object)"org_id", orgIdList);
        summaryWrapper.eq((Object)"dr", (Object)0);
        if ("thisYear".equals(timeFlag)) {
            summaryWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            summaryWrapper.eq((Object)"YEAR(create_time)", (Object)DateUtil.getYear());
            summaryWrapper.eq((Object)"bid_result", (Object)0);
        } else {
            summaryWrapper.eq((Object)"bill_state", (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            summaryWrapper.eq((Object)"bid_result", (Object)0);
        }
        int summaryCount = this.summaryService.count((Wrapper)summaryWrapper);
        ResultVO summaryResultVO = new ResultVO("\u4e2d\u6807", Integer.valueOf(summaryCount));
        resultVOS.add(enrollResultVO);
        resultVOS.add(biddingFileReviewResultVO);
        resultVOS.add(zbResultVO);
        resultVOS.add(summaryResultVO);
        return CommonResponse.success(resultVOS);
    }

    @RequestMapping(value={"/getBidSurvey"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ResultVO>> getBidSurvey(String timeFlag, Long orgId) {
        ArrayList<ResultVO> resultVOS = new ArrayList<ResultVO>();
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgIdList = ((List)this.orgApi.findChildrenByParentId(_orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List enrollList = new ArrayList();
        QueryWrapper enrollWrapper = new QueryWrapper();
        enrollWrapper.in((Object)"org_id", orgIdList);
        enrollWrapper.eq("thisYear".equals(timeFlag), (Object)"YEAR(sign_date)", (Object)DateUtil.getYear());
        enrollList = this.enrollService.list((Wrapper)enrollWrapper);
        ResultVO enrollResultVO = new ResultVO("\u6295\u6807\u603b\u6570", Integer.valueOf(enrollList.size()));
        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6L);
        LocalDate afterOneMonthDay = today.plusDays(29L);
        QueryWrapper monthWrapper = new QueryWrapper();
        monthWrapper.in((Object)"org_id", orgIdList);
        monthWrapper.eq((Object)"bid_state", (Object)BidStateEnum.JIN_XING_ZHONG.getCode());
        monthWrapper.ge((Object)"bidding_date", (Object)today.toString());
        monthWrapper.le((Object)"bidding_date", (Object)afterOneMonthDay.toString());
        int count1 = this.enrollService.count((Wrapper)monthWrapper);
        ResultVO collectResultVO = new ResultVO("\u8fd1\u4e00\u6708\u9884\u8ba1\u5f00\u6807\u6570", Integer.valueOf(count1));
        QueryWrapper weekWrapper = new QueryWrapper();
        weekWrapper.in((Object)"org_id", orgIdList);
        weekWrapper.eq((Object)"bid_state", (Object)BidStateEnum.JIN_XING_ZHONG.getCode());
        weekWrapper.ge((Object)"bidding_date", (Object)today.toString());
        weekWrapper.le((Object)"bidding_date", (Object)afterOneWeekDay.toString());
        int count2 = this.enrollService.count((Wrapper)weekWrapper);
        ResultVO weekResultVO = new ResultVO("\u8fd1\u4e00\u5468\u9884\u8ba1\u5f00\u6807\u6570", Integer.valueOf(count2));
        ArrayList<Long> enrollIds = new ArrayList<Long>();
        Integer bidSumNum = 0;
        for (EnrollEntity enroll : enrollList) {
            enrollIds.add(enroll.getId());
            Integer bidNum = enroll.getBidNum() != null ? enroll.getBidNum() : 0;
            bidSumNum = bidSumNum + bidNum;
        }
        int count = 0;
        if (CollectionUtils.isNotEmpty(enrollIds)) {
            QueryWrapper summaryWrapper = new QueryWrapper();
            summaryWrapper.in((Object)"org_id", orgIdList);
            summaryWrapper.eq((Object)"bid_result", (Object)0);
            summaryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            summaryWrapper.in((Object)"enroll_id", enrollIds);
            count = this.summaryService.count((Wrapper)summaryWrapper);
        }
        ResultVO summaryResultVO = new ResultVO("\u4e2d\u6807\u6570", Integer.valueOf(count));
        ResultVO bidSumNumVO = new ResultVO("\u6295\u6807\u603b\u6807\u6bb5\u6570", bidSumNum);
        resultVOS.add(bidSumNumVO);
        resultVOS.add(summaryResultVO);
        resultVOS.add(collectResultVO);
        resultVOS.add(weekResultVO);
        resultVOS.add(enrollResultVO);
        return CommonResponse.success(resultVOS);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    public static void main(String[] args) {
        LocalDate today = LocalDate.now();
        LocalDate afterOneWeekDay = today.plusDays(6L);
        LocalDate afterOneMonthDay = today.plusDays(29L);
        System.out.println(today);
        System.out.println(afterOneMonthDay);
        System.out.println(afterOneWeekDay);
    }
}

