/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.mapper.RecordMapper;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.vo.RecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="recordService")
public class RecordServiceImpl
extends BaseServiceImpl<RecordMapper, RecordEntity>
implements IRecordService {
    @Override
    public RecordVO saveRecord(BidStageEnum stageEnum, Long billId, String engineeringCode) {
        RecordVO recordVO = new RecordVO(billId, engineeringCode, stageEnum.getCode(), stageEnum.getName(), new Date());
        this.saveOrUpdate(BeanMapper.map((Object)recordVO, RecordEntity.class));
        return recordVO;
    }

    @Override
    public List<RecordVO> getRecord(String engineeringCode) {
        ArrayList<RecordVO> recordVOS = new ArrayList<RecordVO>();
        if (StringUtils.isNotEmpty((CharSequence)engineeringCode)) {
            LambdaQueryWrapper lambd = Wrappers.lambdaQuery();
            lambd.eq(RecordEntity::getEngineeringCode, (Object)engineeringCode);
            lambd.orderByAsc(BaseEntity::getCreateTime);
            List list = this.list((Wrapper)lambd);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.forEach(t -> {
                    if (BidStageEnum.TOU_BIAO_ZONG_JIE_WEI_ZHONG_BIAO.getCode().equals(t.getBidStage())) {
                        t.setBidStage(BidStageEnum.TOU_BIAO_ZONG_JIE_ZHONG_BIAO.getCode());
                    }
                });
                Map<Integer, List<RecordEntity>> map = list.stream().collect(Collectors.groupingBy(RecordEntity::getBidStage));
                for (Map.Entry<Integer, List<RecordEntity>> m : map.entrySet()) {
                    List<RecordEntity> value = m.getValue();
                    List subRecords = BeanMapper.mapList(value, RecordVO.class);
                    RecordVO recordVO = new RecordVO(m.getKey(), subRecords);
                    if (subRecords.size() == 1) {
                        recordVO.setBillDate(((RecordVO)subRecords.get(0)).getBillDate());
                    } else {
                        recordVO.setBidStageName(recordVO.getBidStageName() + " (" + subRecords.size() + ")");
                        recordVO.setBillDate(((RecordVO)subRecords.get(subRecords.size() - 1)).getBillDate());
                    }
                    recordVOS.add(recordVO);
                }
            }
        }
        return recordVOS;
    }
}

