package com.ejianc.business.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.vo.WinningBidVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.vo.SummaryVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 投标总结
 *
 * @author generator
 */
@Controller
@RequestMapping("summary")
@Api(value = "  投标总结 ", tags = {"  投标总结 "})
public class SummaryController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_SUMMARY_CODE";
    @Autowired
    private ISummaryService service;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SummaryVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody SummaryVO saveorUpdateVO) {
        SummaryEntity entity = BeanMapper.map(saveorUpdateVO, SummaryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
                entity.setUseFlag(BidCommonConsts.NO);
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        /**报价形式 0:总价 1:费率 **/
        if (BidCommonConsts.NO.equals(entity.getQuotationForm())) {
            entity.setBiddingControlRate(null);
            entity.setBidQuotationRate(null);
            entity.setControlQuoteLowerRate(null);
        } else {
            entity.setBidMmy(null);
            entity.setBiddingControlMmy(null);
            entity.setQuoteLowerRate(null);
        }
        service.saveOrUpdate(entity, false);
        SummaryVO vo = BeanMapper.map(entity, SummaryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SummaryVO> queryDetail(@RequestParam Long id) {
        SummaryEntity entity = service.selectById(id);
        SummaryVO vo = BeanMapper.map(entity, SummaryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SummaryVO> vos) {
        service.removeByIds(vos.stream().map(SummaryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        fuzzyFields.add("bidEvaluationMethod");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SummaryEntity> page = service.queryPage(param, false);
        IPage<SummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SummaryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        fuzzyFields.add("bidEvaluationMethod");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SummaryVO> summaryVoS = BeanMapper.mapList(list, SummaryVO.class);
        Map<String, Object> beans = new HashMap<>(summaryVoS.size());
        for (SummaryVO summaryVO : summaryVoS) {
            summaryVO.setBillStateName(BillStateEnum.getEnumByStateCode(summaryVO.getBillState()).getDescription());
            summaryVO.setBidResultName(summaryVO.getBidResult().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) ? "已中标" : "未中标");
        }
        beans.put("records", summaryVoS);
        ExcelExport.getInstance().export("Summary-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refsummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SummaryVO>> refsummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("engineeringName", "engineeringCode", "billCode", "bidWinner"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }

        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        param.getParams().put("bidResult", new Parameter(QueryParam.EQ, BidCommonConsts.NO));
        param.getParams().put("quotationForm", new Parameter(QueryParam.EQ, BidCommonConsts.NO));
        param.getParams().put("useFlag", new Parameter(QueryParam.EQ, BidCommonConsts.NO));
        IPage<SummaryEntity> page = service.queryPage(param, false);
        IPage<SummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SummaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("优惠率分析")
    @RequestMapping(value = "/preferentialRateAnalysisList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WinningBidVO>> preferentialRateAnalysisList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<WinningBidVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<WinningBidVO> winningBidVOS = service.queryWinningBidPage(page, wrapper);
        page.setTotal(page.getTotal());
        page.setRecords(winningBidVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    @ApiOperation("优惠率图表数据")
    @RequestMapping(value = "/queryRateAnalysisDataList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryRateAnalysisDataList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.orderByAsc("win_bidding_date");
        List<WinningBidVO> winningBidVOS = service.queryWinningBidList(wrapper);

        List<BigDecimal> tmp_list = new ArrayList<>();
        winningBidVOS.forEach(item -> {
            if (item.getQuoteLowerRate() != null) {
                item.setQuoteLowerRate(item.getQuoteLowerRate().setScale(2, BigDecimal.ROUND_HALF_UP));
                tmp_list.add(item.getQuoteLowerRate());
            }
        });
        Map<String, Object> map = new HashMap<>();
        map.put("data", winningBidVOS);
        BigDecimal max = new BigDecimal("0");
        BigDecimal min = new BigDecimal("0");
        if (CollectionUtils.isNotEmpty(tmp_list)) {
            max = Collections.max(tmp_list);
            min = Collections.min(tmp_list);
        }
        map.put("max", max);
        map.put("min", min);
        return CommonResponse.success("查询列表数据成功！", map);
    }

    /**
     * 获取中标情况 饼状图信息
     *
     * @param orgId
     * @param time time 1：月度  2：季度  3：年度
     * @return
     */
    @ApiOperation("获取中标情况 饼状图信息")
    @GetMapping(value = "/getWinCaseInfo")
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getWinCaseInfo(@RequestParam(value = "orgId", required = false) Long orgId,
                                                         @RequestParam(value = "time") Integer time) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("tenantId", InvocationInfoProxy.getTenantid());
        if(null != orgId) {
            paramMap.put("orgId", iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (time == 1) {
            paramMap.put("startDate", getMonthStartTime(dateTimeFormatter));
            paramMap.put("endDate", getMonthEndTime(dateTimeFormatter));
        } else if (time == 2) {
            paramMap.put("startDate", getFromThisQuarterStartTime(nowDate, dateTimeFormatter));
            paramMap.put("endDate", getFromThisQuarterEndTime(nowDate, dateTimeFormatter));
        } else {
            paramMap.put("startDate", getFromThisYearStartTime(nowDate, dateTimeFormatter));
            paramMap.put("endDate", getFromThisYearEndTime(nowDate, dateTimeFormatter));
        }
        return CommonResponse.success(service.getWinCaseInfo(paramMap));
    }

    /**
     * 本月开始时间
     *
     * @param dateTimeFormatter
     *
     * @return
     */
    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    /**
     * 本月结束时间
     *
     * @return
     */
    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }

    //获取本季度开始时间
    public static String getFromThisQuarterStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);

    }

    //获取本季度结束时间
    public static String getFromThisQuarterEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    /**
     * 今年起开始时间
     *
     * @return
     */
    public static String getFromThisYearStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    /**
     * 今年起结束时间
     *
     * @return
     */
    public static String getFromThisYearEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }

    @ApiOperation("获取中标率")
    @RequestMapping(value = "/getWinningRateAnalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WinningBidVO> getWinningRateAnalysis(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("bidWinner");
        /** 租户隔离 */
        Long tenantId = InvocationInfoProxy.getTenantid();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

        QueryWrapper wrapper = changeToQueryWrapper(param);
        /**中标列表**/
        List<WinningBidVO> winningBidVOS = service.queryWinningBidList(wrapper);
        /**
         * 查询总和标段数量 total   中标数量 SumBidWinningNumber
         * **/
        WinningBidVO winningBidVO = service.querySumbidNumList(orgIds, tenantId);
        winningBidVO.setSumBidWinningNumber(winningBidVOS.size());
        return CommonResponse.success("查询列表数据成功！", winningBidVO);
    }

    @ApiOperation("校验总结次数")
    @RequestMapping(value = "/checkSummaryNumber", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkSummaryNumber(Long enrollId) {
        /**查询投标自由态下面进行过滤**/
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("enroll_id", new Parameter(QueryParam.EQ, enrollId));
        List<SummaryEntity> summaryEntities = service.queryList(queryParam);
        /**查询投标总结次数**/
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        List<SummaryEntity> summaryEntityList = service.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(summaryEntities)) {
            /**只能投标总结有一个自由态**/
            List<SummaryEntity> collect = summaryEntities.stream().filter(s -> BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(s.getBillState())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                if (collect.size() > 0) {
                    return CommonResponse.error("只能有一个自由态,请及时的提交之前的单子！");
                }
            }
            if (CollectionUtils.isNotEmpty(summaryEntityList)) {
                if (summaryEntityList.get(0).getBidSectionNumber().equals(summaryEntityList.size())) {
                    return CommonResponse.error("投标总结次数不能超过标段数量！");
                }
            }
        }
        return CommonResponse.success("校验通过！");
    }
}
