/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.InfoTrackRecordContentEntity;
import com.ejianc.business.bid.bean.InfoTrackUpdateContentEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.controller.SqlParam;
import com.ejianc.business.bid.service.IInfoTrackRecordContentService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.service.IInfoTrackStopService;
import com.ejianc.business.bid.service.IInfoTrackUpdateContentService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"infoTrack"})
@Api(value="\u6295\u6807\u4fe1\u606f\u8ddf\u8e2a", tags={"\u6295\u6807\u4fe1\u606f\u8ddf\u8e2a"})
public class InfoTrackController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_ENGINEERING_CODE";
    @Autowired
    private ITenantApi tenantApi;
    private static final String PC_A_URL = "/ejc-bid-frontend/#/infoTrack/card?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IInfoTrackService service;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IInfoTrackStopService infoTrackStopService;
    @Autowired
    private IInfoTrackRecordContentService infoTrackRecordContentService;
    @Autowired
    private IInfoTrackUpdateContentService infoTrackUpdateContentService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InfoTrackVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody InfoTrackVO saveorUpdateVO) {
        InfoTrackEntity entity = (InfoTrackEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InfoTrackEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setIsStop(BidCommonConsts.NO);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        InfoTrackRecordContentEntity infoTrackRecordContentEntity = new InfoTrackRecordContentEntity();
        InfoTrackUpdateContentEntity infoTrackUpdateContentEntity = new InfoTrackUpdateContentEntity();
        Boolean oldFlag = false;
        InfoTrackEntity oldEntity = new InfoTrackEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            infoTrackUpdateContentEntity.setUpdatePeople(InvocationInfoProxy.getUsercode());
            infoTrackUpdateContentEntity.setUpdateSummary(entity.getProjectOverview());
            infoTrackUpdateContentEntity.setUpdatePrice(entity.getInvestorAmount());
            infoTrackUpdateContentEntity.setUpdateTime(new Date());
            if (entity.getRemark() == null || entity.getRemark().equals("")) {
                entity.setRemark(InvocationInfoProxy.getUsercode() + BidStateEnum.GEN_ZONG_ZHONG.getName());
            }
            infoTrackRecordContentEntity.setFollowPeople(InvocationInfoProxy.getUsercode());
            infoTrackRecordContentEntity.setNewTrackStatus(entity.getRemark());
            infoTrackRecordContentEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            infoTrackRecordContentEntity.setTrackTime(new Date());
            entity.getRecordList().add(infoTrackRecordContentEntity);
            entity.getUpdateList().add(infoTrackUpdateContentEntity);
        } else {
            oldFlag = true;
            oldEntity = (InfoTrackEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            if ((oldEntity.getBillState() == 1 || oldEntity.getBillState() == 3) && oldEntity.getFollowState().equals(BidStateEnum.GEN_ZONG_ZHONG.getCode())) {
                if (oldEntity.getInvestorAmount().longValue() != entity.getInvestorAmount().longValue() || !oldEntity.getProjectOverview().equals(entity.getProjectOverview())) {
                    infoTrackUpdateContentEntity.setUpdatePeople(InvocationInfoProxy.getUsercode());
                    infoTrackUpdateContentEntity.setUpdateSummary(entity.getProjectOverview());
                    infoTrackUpdateContentEntity.setUpdatePrice(entity.getInvestorAmount());
                    infoTrackUpdateContentEntity.setUpdateTime(new Date());
                    entity.getUpdateList().add(infoTrackUpdateContentEntity);
                }
                if (null == oldEntity.getRemark() || !oldEntity.getRemark().equals(entity.getRemark())) {
                    infoTrackRecordContentEntity.setFollowPeople(InvocationInfoProxy.getUsercode());
                    infoTrackRecordContentEntity.setNewTrackStatus(entity.getRemark());
                    infoTrackRecordContentEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    infoTrackRecordContentEntity.setTrackTime(new Date());
                    entity.getRecordList().add(infoTrackRecordContentEntity);
                }
            }
        }
        ArrayList<String> nameItems = new ArrayList<String>();
        for (char c : saveorUpdateVO.getEngineeringName().toCharArray()) {
            nameItems.add(String.valueOf(c));
        }
        List<String> nameRepeatList = this.service.countNameRepeatNum(nameItems);
        Integer nameRepeatNum = 0;
        if (CollectionUtils.isNotEmpty(nameRepeatList)) {
            nameRepeatNum = nameRepeatList.stream().map(item -> {
                String tmp = item;
                for (String s : nameItems) {
                    tmp = tmp.replace(s, "");
                }
                return item.length() - tmp.length();
            }).max((v1, v2) -> v1 - v2).get();
        }
        entity.setNameRepeatPercent(ComputeUtil.safeDiv((BigDecimal)new BigDecimal(nameRepeatNum + ""), (BigDecimal)new BigDecimal(nameItems.size() + "")));
        this.service.saveOrUpdate((Object)entity, false);
        if (oldFlag.booleanValue() && oldEntity.getBillState() == 0) {
            if (oldEntity.getInvestorAmount().longValue() != entity.getInvestorAmount().longValue() || !oldEntity.getProjectOverview().equals(entity.getProjectOverview())) {
                this.infoTrackUpdateContentService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"update_people", (Object)InvocationInfoProxy.getUsercode())).set((Object)"update_summary", (Object)entity.getProjectOverview())).set((Object)"update_price", (Object)entity.getInvestorAmount())).eq((Object)"track_id", (Object)oldEntity.getId()));
            }
            if (!oldEntity.getRemark().equals(entity.getRemark())) {
                this.infoTrackRecordContentService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"follow_people", (Object)InvocationInfoProxy.getUsercode())).set((Object)"new_track_status", (Object)entity.getRemark())).set((Object)"track_time", (Object)new Date())).eq((Object)"track_id", (Object)oldEntity.getId()));
            }
        }
        InfoTrackVO vo = (InfoTrackVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), InfoTrackVO.class);
        this.infoTrackStopService.insertInfoTrackStop(vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InfoTrackVO> queryDetail(@RequestParam Long id) {
        InfoTrackEntity entity = (InfoTrackEntity)((Object)this.service.selectById(id));
        InfoTrackVO vo = (InfoTrackVO)BeanMapper.map((Object)((Object)entity), InfoTrackVO.class);
        vo.setRecords(this.recordService.getRecord(vo.getBillCode()));
        if (vo != null) {
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode((Integer)vo.getBiddingForm()));
            vo.setFollowStateName(BidStateEnum.getNameByCode((Integer)vo.getFollowState()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InfoTrackVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u8ddf\u8e2a\u9879\u76ee\u4fe1\u606f\u5c55\u793a\u8868")
    @RequestMapping(value={"/queryListForTrack"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> queryListForTrack(@RequestBody QueryParam param) {
        LinkedHashMap orderMap = param.getOrderMap();
        if (ObjectUtil.isNotEmpty((Object)orderMap)) {
            param.getOrderMap().put("billDate", orderMap.get("billDate"));
        } else {
            param.getOrderMap().put("billDate", "desc");
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("followUnitName", "engineeringName", "engineeringTypeName", "area"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        List records = page.getRecords();
        Map<Long, InfoTrackRecordContentEntity> map = this.getLongInfoTrackRecordContentEntityMap(records);
        ArrayList result = new ArrayList();
        records.forEach(record -> {
            InfoTrackVO infoTrackVO = (InfoTrackVO)BeanMapper.map((Object)record, InfoTrackVO.class);
            InfoTrackRecordContentEntity infoTrackRecordContentEntity = (InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackVO.getId())));
            if (infoTrackRecordContentEntity != null) {
                infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
            }
            result.add(infoTrackVO);
        });
        Page resultPage = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        resultPage.setRecords(result);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resultPage);
    }

    private Map<Long, InfoTrackRecordContentEntity> getLongInfoTrackRecordContentEntityMap(List<InfoTrackEntity> records) {
        List ids = records.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(InfoTrackRecordContentEntity::getTrackId, ids);
        List list = this.infoTrackRecordContentService.list((Wrapper)queryWrapper);
        HashMap<Long, InfoTrackRecordContentEntity> map = new HashMap<Long, InfoTrackRecordContentEntity>();
        list.forEach(infoTrackRecordContentEntity -> {
            if (map.containsKey(infoTrackRecordContentEntity.getTrackId())) {
                if (map.get(infoTrackRecordContentEntity.getTrackId()) == null) {
                    map.put(infoTrackRecordContentEntity.getTrackId(), (InfoTrackRecordContentEntity)((Object)infoTrackRecordContentEntity));
                } else if (((InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackRecordContentEntity.getTrackId())))).getTrackTime() == null || infoTrackRecordContentEntity.getTrackTime() != null && infoTrackRecordContentEntity.getTrackTime().after(((InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackRecordContentEntity.getTrackId())))).getTrackTime())) {
                    map.put(infoTrackRecordContentEntity.getTrackId(), (InfoTrackRecordContentEntity)((Object)infoTrackRecordContentEntity));
                }
            } else {
                map.put(infoTrackRecordContentEntity.getTrackId(), (InfoTrackRecordContentEntity)((Object)infoTrackRecordContentEntity));
            }
        });
        return map;
    }

    @ApiOperation(value="\u67e5\u8be2")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> queryList(@RequestBody QueryParam param) {
        Parameter report = (Parameter)param.getParams().get("isReport");
        String isReport = "0";
        if (ObjectUtil.isNotEmpty((Object)report)) {
            isReport = ((Parameter)param.getParams().get("isReport")).getValue().toString();
        }
        List fuzzyFields = param.getFuzzyFields();
        LinkedHashMap orderMap = param.getOrderMap();
        param.getParams().remove("isReport");
        if (isReport.equals("1")) {
            fuzzyFields.addAll(Arrays.asList("followUnitName", "engineeringName", "engineeringTypeName", "area", "investorAmount", "constructionUnitName"));
            if (ObjectUtil.isNotEmpty((Object)orderMap)) {
                param.getOrderMap().put("billDate", orderMap.get("billDate"));
            } else {
                param.getOrderMap().put("billDate", "desc");
            }
        } else {
            fuzzyFields.add("billCode");
            fuzzyFields.add("engineeringName");
            fuzzyFields.add("followUnitName");
            fuzzyFields.add("employeeName");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        if (isReport.equals("1")) {
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            ArrayList infoTrackVOS = new ArrayList();
            page.getRecords().forEach(item -> {
                String engineeringName = this.dofiter(item.getEngineeringName());
                item.setEngineeringName(engineeringName);
                String constructionUnitName = this.dofiter(item.getConstructionUnitName());
                item.setConstructionUnitName(constructionUnitName);
                infoTrackVOS.add(BeanMapper.map((Object)item, InfoTrackVO.class));
            });
            pageData.setRecords(infoTrackVOS);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InfoTrackVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private String dofiter(String name) {
        if (name.length() <= 2) {
            return name;
        }
        String newName = name.substring(0, 2);
        int i = name.length() - 2;
        for (int j = 0; j < i; ++j) {
            newName = newName + "*";
        }
        return newName;
    }

    @ApiOperation(value="\u5bfc\u51fa\u8ddf\u8e2a\u9879\u76ee\u4fe1\u606f\u5c55\u793a\u8868")
    @RequestMapping(value={"/excelTrackExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelTrackExport(@RequestBody QueryParam param, HttpServletResponse response) {
        LinkedHashMap orderMap = param.getOrderMap();
        if (ObjectUtil.isNotEmpty((Object)orderMap)) {
            param.getOrderMap().put("billDate", orderMap.get("billDate"));
        } else {
            param.getOrderMap().put("billDate", "desc");
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("followUnitName", "engineeringName", "engineeringTypeName", "area"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        Map<Long, InfoTrackRecordContentEntity> map = this.getLongInfoTrackRecordContentEntityMap(list);
        ArrayList result = new ArrayList();
        list.forEach(record -> {
            Integer followState;
            InfoTrackVO infoTrackVO = (InfoTrackVO)BeanMapper.map((Object)record, InfoTrackVO.class);
            InfoTrackRecordContentEntity infoTrackRecordContentEntity = (InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackVO.getId())));
            if (infoTrackRecordContentEntity != null) {
                infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
            }
            if ((followState = record.getFollowState()) == 1) {
                infoTrackVO.setFollowStateName("\u8ddf\u8e2a\u4e2d");
            } else if (followState == 2) {
                infoTrackVO.setFollowStateName("\u5df2\u62a5\u540d");
            } else {
                infoTrackVO.setFollowStateName("\u5df2\u7ed3\u675f");
            }
            result.add(infoTrackVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", result);
        ExcelExport.getInstance().export("InfoTrackPeopleReport-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Parameter report = (Parameter)param.getParams().get("isReport");
        String isReport = "0";
        if (ObjectUtil.isNotEmpty((Object)report)) {
            isReport = ((Parameter)param.getParams().get("isReport")).getValue().toString();
        }
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("isReport");
        LinkedHashMap orderMap = param.getOrderMap();
        if (isReport.equals("1")) {
            if (ObjectUtil.isNotEmpty((Object)orderMap)) {
                param.getOrderMap().put("billDate", orderMap.get("billDate"));
            } else {
                param.getOrderMap().put("billDate", "desc");
            }
            fuzzyFields.addAll(Arrays.asList("followUnitName", "engineeringName", "engineeringTypeName", "area", "investorAmount", "constructionUnitName"));
        } else {
            fuzzyFields.add("billCode");
            fuzzyFields.add("engineeringName");
            fuzzyFields.add("followUnitName");
            fuzzyFields.add("employeeName");
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, InfoTrackVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setFollowStateName(BidStateEnum.getNameByCode((Integer)vo.getFollowState()));
            });
        }
        if (isReport.equals("1")) {
            ArrayList Vo = new ArrayList();
            HashMap beans = new HashMap();
            voList.forEach(item -> {
                Integer followState = item.getFollowState();
                if (followState == 1) {
                    item.setFollowStateName("\u8ddf\u8e2a\u4e2d");
                } else if (followState == 2) {
                    item.setFollowStateName("\u5df2\u62a5\u540d");
                } else {
                    item.setFollowStateName("\u5df2\u7ed3\u675f");
                }
                String engineeringName = this.dofiter(item.getEngineeringName());
                item.setEngineeringName(engineeringName);
                String constructionUnitName = this.dofiter(item.getConstructionUnitName());
                item.setConstructionUnitName(constructionUnitName);
                Vo.add(item);
            });
            beans.put("records", Vo);
            ExcelExport.getInstance().export("InfoTrackReport-export.xlsx", beans, response);
        } else {
            HashMap beans = new HashMap();
            beans.put("records", voList);
            ExcelExport.getInstance().export("InfoTrack-export.xlsx", beans, response);
        }
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refInfoTrackData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> refInfoTrackData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("unitDirectorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("isStop", new Parameter("eq", (Object)BidCommonConsts.NO));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("followState", new Parameter("eq", (Object)BidCommonConsts.YES));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InfoTrackVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"infoTrackFollowWarn"})
    public CommonResponse<String> infoTrackFollowWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        String warnLevel = "";
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u8bc1\u7167\u5230\u671f\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bc1\u7167\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bc1\u7167\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                warnLevel = p.getWarnLevel();
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }
        List<InfoTrackVO> result = this.service.queryRecordList();
        this.logger.info("\u672c\u6b21\u5171\u83b7\u53d67\u5929\u672a\u66f4\u65b0\u8ddf\u8fdb\u60c5\u51b5\u5355\u636e\u6570\u91cf{}\u6761", (Object)result.size());
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u8bc1\u7167\u5230\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo, 0, warnLevel), defaultWarnInfo.getLong("warnSetId"));
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<InfoTrackVO> result, JSONObject defaultWarnInfo, Integer type, String warnLevel) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (InfoTrackVO m : result) {
            if (new BigDecimal(DateUtil.getBetweenDays(new Date(), m.getTrackTime()).toString()).compareTo(new BigDecimal(7)) <= -1) continue;
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.getBillCode());
            vo.setPcTitle("\u9879\u76ee\u4fe1\u606f\u7acb\u9879");
            vo.setPcUrl(PC_A_URL + m.getId());
            vo.setOrgId(Long.valueOf(m.getOrgId()));
            vo.setOrgName(m.getOrgName());
            vo.setSourceId(m.getId().toString());
            vo.setTenantId(m.getTenantId());
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            if (type == 0) {
                tmpContent = "\u9879\u76ee\u7acb\u9879\u4fe1\u606f-" + m.getEngineeringName() + "\u5df2\u7ecf7\u5929\u672a\u4fee\u6539\u8ddf\u8fdb\u60c5\u51b5\uff0c\u8bf7\u66f4\u65b0\u8ddf\u8fdb\u60c5\u51b5\uff01";
            }
            vo.setEarlywarnContent(tmpContent);
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

