/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.consts.ProjectTrackSurveyEnum;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectSurvey"})
public class ProjectSurveyController {
    @Autowired
    private IInfoTrackService infoTrackService;

    @RequestMapping(value={"/projectCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<InfoTrackVO>> projectCount(@RequestParam(value="range", required=false) String range, @RequestParam(value="name", required=false) String name, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return CommonResponse.success(this.infoTrackService.trackCount(range, name, dateIn, orgId));
    }

    @GetMapping(value={"businessStatusCount"})
    public CommonResponse<JSONObject> businessStatusCount(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="yearType", required=false) String yearType) {
        JSONObject resp = new JSONObject();
        String year = EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)) {
            year = EJCDateUtil.getYear() - 1 + "";
        }
        String thisYear = year;
        Integer buildNum = 0;
        Integer thisYearProjectNum = 0;
        List<InfoTrackVO> trackVOS = this.infoTrackService.trackCount(null, null, "0".equals(yearType) ? ProjectTrackSurveyEnum.LASTYEAR.getCode() : null, orgId);
        resp.put("totalNumAll", (Object)trackVOS.size());
        resp.put("totalNum", (Object)trackVOS.size());
        HashMap<String, JSONObject> statusMap = new HashMap<String, JSONObject>();
        JSONObject tmpStatus = null;
        for (InfoTrackVO e : trackVOS) {
            Integer n;
            Integer n2;
            if (ProjectTrackSurveyEnum.RANGE_TRACKING.getCode().equals(e.getTrackStatus())) {
                n2 = buildNum;
                n = buildNum = Integer.valueOf(buildNum + 1);
            }
            if (thisYear.equals(DateUtil.format(e.getCreateTime(), "yyyy"))) {
                n2 = thisYearProjectNum;
                n = thisYearProjectNum = Integer.valueOf(thisYearProjectNum + 1);
            }
            if (!statusMap.containsKey(e.getTrackStatus())) {
                tmpStatus = new JSONObject();
                tmpStatus.put("businessStatus", (Object)e.getTrackStatus());
                tmpStatus.put("businessStatusName", (Object)ProjectTrackSurveyEnum.valueOf((String)e.getTrackStatus()));
                tmpStatus.put("num", (Object)0);
                statusMap.put(e.getTrackStatus(), tmpStatus);
            }
            tmpStatus = (JSONObject)statusMap.get(e.getTrackStatus());
            tmpStatus.put("num", (Object)(tmpStatus.getInteger("num") + 1));
            statusMap.put(e.getTrackStatus(), tmpStatus);
        }
        resp.put("buildNum", (Object)buildNum);
        resp.put("thisYearProjectNum", (Object)thisYearProjectNum);
        resp.put("detail", statusMap.values());
        return CommonResponse.success((Object)resp);
    }
}

